// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Istio Service Mesh Certificate Authority (CA) configuration. For now, we only support plugin certificates as
 * described here https://aka.ms/asm-plugin-ca.
 */
@Fluent
public final class IstioCertificateAuthority implements JsonSerializable<IstioCertificateAuthority> {
    /*
     * Plugin certificates information for Service Mesh.
     */
    private IstioPluginCertificateAuthority plugin;

    /**
     * Creates an instance of IstioCertificateAuthority class.
     */
    public IstioCertificateAuthority() {
    }

    /**
     * Get the plugin property: Plugin certificates information for Service Mesh.
     * 
     * @return the plugin value.
     */
    public IstioPluginCertificateAuthority plugin() {
        return this.plugin;
    }

    /**
     * Set the plugin property: Plugin certificates information for Service Mesh.
     * 
     * @param plugin the plugin value to set.
     * @return the IstioCertificateAuthority object itself.
     */
    public IstioCertificateAuthority withPlugin(IstioPluginCertificateAuthority plugin) {
        this.plugin = plugin;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (plugin() != null) {
            plugin().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("plugin", this.plugin);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of IstioCertificateAuthority from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of IstioCertificateAuthority if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the IstioCertificateAuthority.
     */
    public static IstioCertificateAuthority fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            IstioCertificateAuthority deserializedIstioCertificateAuthority = new IstioCertificateAuthority();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("plugin".equals(fieldName)) {
                    deserializedIstioCertificateAuthority.plugin = IstioPluginCertificateAuthority.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedIstioCertificateAuthority;
        });
    }
}
