// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Settings for upgrading an agentpool.
 */
@Fluent
public final class AgentPoolUpgradeSettings implements JsonSerializable<AgentPoolUpgradeSettings> {
    /*
     * The maximum number or percentage of nodes that are surged during upgrade. This can either be set to an integer
     * (e.g. '5') or a percentage (e.g. '50%'). If a percentage is specified, it is the percentage of the total agent
     * pool size at the time of the upgrade. For percentages, fractional nodes are rounded up. If not specified, the
     * default is 10%. For more information, including best practices, see:
     * https://learn.microsoft.com/en-us/azure/aks/upgrade-cluster
     */
    private String maxSurge;

    /*
     * The maximum number or percentage of nodes that can be simultaneously unavailable during upgrade. This can either
     * be set to an integer (e.g. '1') or a percentage (e.g. '5%'). If a percentage is specified, it is the percentage
     * of the total agent pool size at the time of the upgrade. For percentages, fractional nodes are rounded up. If not
     * specified, the default is 0. For more information, including best practices, see:
     * https://learn.microsoft.com/en-us/azure/aks/upgrade-cluster
     */
    private String maxUnavailable;

    /*
     * The drain timeout for a node. The amount of time (in minutes) to wait on eviction of pods and graceful
     * termination per node. This eviction wait time honors waiting on pod disruption budgets. If this time is exceeded,
     * the upgrade fails. If not specified, the default is 30 minutes.
     */
    private Integer drainTimeoutInMinutes;

    /*
     * The soak duration for a node. The amount of time (in minutes) to wait after draining a node and before reimaging
     * it and moving on to next node. If not specified, the default is 0 minutes.
     */
    private Integer nodeSoakDurationInMinutes;

    /*
     * Defines the behavior for undrainable nodes during upgrade. The most common cause of undrainable nodes is Pod
     * Disruption Budgets (PDBs), but other issues, such as pod termination grace period is exceeding the remaining
     * per-node drain timeout or pod is still being in a running state, can also cause undrainable nodes.
     */
    private UndrainableNodeBehavior undrainableNodeBehavior;

    /**
     * Creates an instance of AgentPoolUpgradeSettings class.
     */
    public AgentPoolUpgradeSettings() {
    }

    /**
     * Get the maxSurge property: The maximum number or percentage of nodes that are surged during upgrade. This can
     * either be set to an integer (e.g. '5') or a percentage (e.g. '50%'). If a percentage is specified, it is the
     * percentage of the total agent pool size at the time of the upgrade. For percentages, fractional nodes are rounded
     * up. If not specified, the default is 10%. For more information, including best practices, see:
     * https://learn.microsoft.com/en-us/azure/aks/upgrade-cluster.
     * 
     * @return the maxSurge value.
     */
    public String maxSurge() {
        return this.maxSurge;
    }

    /**
     * Set the maxSurge property: The maximum number or percentage of nodes that are surged during upgrade. This can
     * either be set to an integer (e.g. '5') or a percentage (e.g. '50%'). If a percentage is specified, it is the
     * percentage of the total agent pool size at the time of the upgrade. For percentages, fractional nodes are rounded
     * up. If not specified, the default is 10%. For more information, including best practices, see:
     * https://learn.microsoft.com/en-us/azure/aks/upgrade-cluster.
     * 
     * @param maxSurge the maxSurge value to set.
     * @return the AgentPoolUpgradeSettings object itself.
     */
    public AgentPoolUpgradeSettings withMaxSurge(String maxSurge) {
        this.maxSurge = maxSurge;
        return this;
    }

    /**
     * Get the maxUnavailable property: The maximum number or percentage of nodes that can be simultaneously unavailable
     * during upgrade. This can either be set to an integer (e.g. '1') or a percentage (e.g. '5%'). If a percentage is
     * specified, it is the percentage of the total agent pool size at the time of the upgrade. For percentages,
     * fractional nodes are rounded up. If not specified, the default is 0. For more information, including best
     * practices, see: https://learn.microsoft.com/en-us/azure/aks/upgrade-cluster.
     * 
     * @return the maxUnavailable value.
     */
    public String maxUnavailable() {
        return this.maxUnavailable;
    }

    /**
     * Set the maxUnavailable property: The maximum number or percentage of nodes that can be simultaneously unavailable
     * during upgrade. This can either be set to an integer (e.g. '1') or a percentage (e.g. '5%'). If a percentage is
     * specified, it is the percentage of the total agent pool size at the time of the upgrade. For percentages,
     * fractional nodes are rounded up. If not specified, the default is 0. For more information, including best
     * practices, see: https://learn.microsoft.com/en-us/azure/aks/upgrade-cluster.
     * 
     * @param maxUnavailable the maxUnavailable value to set.
     * @return the AgentPoolUpgradeSettings object itself.
     */
    public AgentPoolUpgradeSettings withMaxUnavailable(String maxUnavailable) {
        this.maxUnavailable = maxUnavailable;
        return this;
    }

    /**
     * Get the drainTimeoutInMinutes property: The drain timeout for a node. The amount of time (in minutes) to wait on
     * eviction of pods and graceful termination per node. This eviction wait time honors waiting on pod disruption
     * budgets. If this time is exceeded, the upgrade fails. If not specified, the default is 30 minutes.
     * 
     * @return the drainTimeoutInMinutes value.
     */
    public Integer drainTimeoutInMinutes() {
        return this.drainTimeoutInMinutes;
    }

    /**
     * Set the drainTimeoutInMinutes property: The drain timeout for a node. The amount of time (in minutes) to wait on
     * eviction of pods and graceful termination per node. This eviction wait time honors waiting on pod disruption
     * budgets. If this time is exceeded, the upgrade fails. If not specified, the default is 30 minutes.
     * 
     * @param drainTimeoutInMinutes the drainTimeoutInMinutes value to set.
     * @return the AgentPoolUpgradeSettings object itself.
     */
    public AgentPoolUpgradeSettings withDrainTimeoutInMinutes(Integer drainTimeoutInMinutes) {
        this.drainTimeoutInMinutes = drainTimeoutInMinutes;
        return this;
    }

    /**
     * Get the nodeSoakDurationInMinutes property: The soak duration for a node. The amount of time (in minutes) to wait
     * after draining a node and before reimaging it and moving on to next node. If not specified, the default is 0
     * minutes.
     * 
     * @return the nodeSoakDurationInMinutes value.
     */
    public Integer nodeSoakDurationInMinutes() {
        return this.nodeSoakDurationInMinutes;
    }

    /**
     * Set the nodeSoakDurationInMinutes property: The soak duration for a node. The amount of time (in minutes) to wait
     * after draining a node and before reimaging it and moving on to next node. If not specified, the default is 0
     * minutes.
     * 
     * @param nodeSoakDurationInMinutes the nodeSoakDurationInMinutes value to set.
     * @return the AgentPoolUpgradeSettings object itself.
     */
    public AgentPoolUpgradeSettings withNodeSoakDurationInMinutes(Integer nodeSoakDurationInMinutes) {
        this.nodeSoakDurationInMinutes = nodeSoakDurationInMinutes;
        return this;
    }

    /**
     * Get the undrainableNodeBehavior property: Defines the behavior for undrainable nodes during upgrade. The most
     * common cause of undrainable nodes is Pod Disruption Budgets (PDBs), but other issues, such as pod termination
     * grace period is exceeding the remaining per-node drain timeout or pod is still being in a running state, can also
     * cause undrainable nodes.
     * 
     * @return the undrainableNodeBehavior value.
     */
    public UndrainableNodeBehavior undrainableNodeBehavior() {
        return this.undrainableNodeBehavior;
    }

    /**
     * Set the undrainableNodeBehavior property: Defines the behavior for undrainable nodes during upgrade. The most
     * common cause of undrainable nodes is Pod Disruption Budgets (PDBs), but other issues, such as pod termination
     * grace period is exceeding the remaining per-node drain timeout or pod is still being in a running state, can also
     * cause undrainable nodes.
     * 
     * @param undrainableNodeBehavior the undrainableNodeBehavior value to set.
     * @return the AgentPoolUpgradeSettings object itself.
     */
    public AgentPoolUpgradeSettings withUndrainableNodeBehavior(UndrainableNodeBehavior undrainableNodeBehavior) {
        this.undrainableNodeBehavior = undrainableNodeBehavior;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("maxSurge", this.maxSurge);
        jsonWriter.writeStringField("maxUnavailable", this.maxUnavailable);
        jsonWriter.writeNumberField("drainTimeoutInMinutes", this.drainTimeoutInMinutes);
        jsonWriter.writeNumberField("nodeSoakDurationInMinutes", this.nodeSoakDurationInMinutes);
        jsonWriter.writeStringField("undrainableNodeBehavior",
            this.undrainableNodeBehavior == null ? null : this.undrainableNodeBehavior.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AgentPoolUpgradeSettings from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AgentPoolUpgradeSettings if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AgentPoolUpgradeSettings.
     */
    public static AgentPoolUpgradeSettings fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AgentPoolUpgradeSettings deserializedAgentPoolUpgradeSettings = new AgentPoolUpgradeSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("maxSurge".equals(fieldName)) {
                    deserializedAgentPoolUpgradeSettings.maxSurge = reader.getString();
                } else if ("maxUnavailable".equals(fieldName)) {
                    deserializedAgentPoolUpgradeSettings.maxUnavailable = reader.getString();
                } else if ("drainTimeoutInMinutes".equals(fieldName)) {
                    deserializedAgentPoolUpgradeSettings.drainTimeoutInMinutes = reader.getNullable(JsonReader::getInt);
                } else if ("nodeSoakDurationInMinutes".equals(fieldName)) {
                    deserializedAgentPoolUpgradeSettings.nodeSoakDurationInMinutes
                        = reader.getNullable(JsonReader::getInt);
                } else if ("undrainableNodeBehavior".equals(fieldName)) {
                    deserializedAgentPoolUpgradeSettings.undrainableNodeBehavior
                        = UndrainableNodeBehavior.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAgentPoolUpgradeSettings;
        });
    }
}
