// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerservice.models.KubernetesVersion;
import java.io.IOException;
import java.util.List;

/**
 * Hold values properties, which is array of KubernetesVersion.
 */
@Fluent
public final class KubernetesVersionListResultInner implements JsonSerializable<KubernetesVersionListResultInner> {
    /*
     * Array of AKS supported Kubernetes versions.
     */
    private List<KubernetesVersion> values;

    /**
     * Creates an instance of KubernetesVersionListResultInner class.
     */
    public KubernetesVersionListResultInner() {
    }

    /**
     * Get the values property: Array of AKS supported Kubernetes versions.
     * 
     * @return the values value.
     */
    public List<KubernetesVersion> values() {
        return this.values;
    }

    /**
     * Set the values property: Array of AKS supported Kubernetes versions.
     * 
     * @param values the values value to set.
     * @return the KubernetesVersionListResultInner object itself.
     */
    public KubernetesVersionListResultInner withValues(List<KubernetesVersion> values) {
        this.values = values;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (values() != null) {
            values().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("values", this.values, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KubernetesVersionListResultInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KubernetesVersionListResultInner if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the KubernetesVersionListResultInner.
     */
    public static KubernetesVersionListResultInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            KubernetesVersionListResultInner deserializedKubernetesVersionListResultInner
                = new KubernetesVersionListResultInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("values".equals(fieldName)) {
                    List<KubernetesVersion> values = reader.readArray(reader1 -> KubernetesVersion.fromJson(reader1));
                    deserializedKubernetesVersionListResultInner.values = values;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedKubernetesVersionListResultInner;
        });
    }
}
