// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerservice.models.AgentPoolUpgradeProfilePropertiesUpgradesItem;
import com.azure.resourcemanager.containerservice.models.OSType;
import java.io.IOException;
import java.util.List;

/**
 * The list of available upgrades for an agent pool.
 */
@Fluent
public final class AgentPoolUpgradeProfileInner implements JsonSerializable<AgentPoolUpgradeProfileInner> {
    /*
     * The ID of the agent pool upgrade profile.
     */
    private String id;

    /*
     * The name of the agent pool upgrade profile.
     */
    private String name;

    /*
     * The type of the agent pool upgrade profile.
     */
    private String type;

    /*
     * The properties of the agent pool upgrade profile.
     */
    private AgentPoolUpgradeProfileProperties innerProperties = new AgentPoolUpgradeProfileProperties();

    /**
     * Creates an instance of AgentPoolUpgradeProfileInner class.
     */
    public AgentPoolUpgradeProfileInner() {
    }

    /**
     * Get the id property: The ID of the agent pool upgrade profile.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The name of the agent pool upgrade profile.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The type of the agent pool upgrade profile.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Get the innerProperties property: The properties of the agent pool upgrade profile.
     * 
     * @return the innerProperties value.
     */
    private AgentPoolUpgradeProfileProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the kubernetesVersion property: The Kubernetes version (major.minor.patch).
     * 
     * @return the kubernetesVersion value.
     */
    public String kubernetesVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().kubernetesVersion();
    }

    /**
     * Set the kubernetesVersion property: The Kubernetes version (major.minor.patch).
     * 
     * @param kubernetesVersion the kubernetesVersion value to set.
     * @return the AgentPoolUpgradeProfileInner object itself.
     */
    public AgentPoolUpgradeProfileInner withKubernetesVersion(String kubernetesVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AgentPoolUpgradeProfileProperties();
        }
        this.innerProperties().withKubernetesVersion(kubernetesVersion);
        return this;
    }

    /**
     * Get the osType property: OsType to be used to specify os type. Choose from Linux and Windows. Default to Linux.
     * 
     * @return the osType value.
     */
    public OSType osType() {
        return this.innerProperties() == null ? null : this.innerProperties().osType();
    }

    /**
     * Set the osType property: OsType to be used to specify os type. Choose from Linux and Windows. Default to Linux.
     * 
     * @param osType the osType value to set.
     * @return the AgentPoolUpgradeProfileInner object itself.
     */
    public AgentPoolUpgradeProfileInner withOsType(OSType osType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AgentPoolUpgradeProfileProperties();
        }
        this.innerProperties().withOsType(osType);
        return this;
    }

    /**
     * Get the upgrades property: List of orchestrator types and versions available for upgrade.
     * 
     * @return the upgrades value.
     */
    public List<AgentPoolUpgradeProfilePropertiesUpgradesItem> upgrades() {
        return this.innerProperties() == null ? null : this.innerProperties().upgrades();
    }

    /**
     * Set the upgrades property: List of orchestrator types and versions available for upgrade.
     * 
     * @param upgrades the upgrades value to set.
     * @return the AgentPoolUpgradeProfileInner object itself.
     */
    public AgentPoolUpgradeProfileInner withUpgrades(List<AgentPoolUpgradeProfilePropertiesUpgradesItem> upgrades) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AgentPoolUpgradeProfileProperties();
        }
        this.innerProperties().withUpgrades(upgrades);
        return this;
    }

    /**
     * Get the latestNodeImageVersion property: The latest AKS supported node image version.
     * 
     * @return the latestNodeImageVersion value.
     */
    public String latestNodeImageVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().latestNodeImageVersion();
    }

    /**
     * Set the latestNodeImageVersion property: The latest AKS supported node image version.
     * 
     * @param latestNodeImageVersion the latestNodeImageVersion value to set.
     * @return the AgentPoolUpgradeProfileInner object itself.
     */
    public AgentPoolUpgradeProfileInner withLatestNodeImageVersion(String latestNodeImageVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AgentPoolUpgradeProfileProperties();
        }
        this.innerProperties().withLatestNodeImageVersion(latestNodeImageVersion);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property innerProperties in model AgentPoolUpgradeProfileInner"));
        } else {
            innerProperties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(AgentPoolUpgradeProfileInner.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AgentPoolUpgradeProfileInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AgentPoolUpgradeProfileInner if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AgentPoolUpgradeProfileInner.
     */
    public static AgentPoolUpgradeProfileInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AgentPoolUpgradeProfileInner deserializedAgentPoolUpgradeProfileInner = new AgentPoolUpgradeProfileInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("properties".equals(fieldName)) {
                    deserializedAgentPoolUpgradeProfileInner.innerProperties
                        = AgentPoolUpgradeProfileProperties.fromJson(reader);
                } else if ("id".equals(fieldName)) {
                    deserializedAgentPoolUpgradeProfileInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedAgentPoolUpgradeProfileInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedAgentPoolUpgradeProfileInner.type = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAgentPoolUpgradeProfileInner;
        });
    }
}
