// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerservice.models.AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem;
import java.io.IOException;
import java.util.List;

/**
 * The list of available agent pool versions.
 */
@Fluent
public final class AgentPoolAvailableVersionsProperties
    implements JsonSerializable<AgentPoolAvailableVersionsProperties> {
    /*
     * List of versions available for agent pool.
     */
    private List<AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem> agentPoolVersions;

    /**
     * Creates an instance of AgentPoolAvailableVersionsProperties class.
     */
    public AgentPoolAvailableVersionsProperties() {
    }

    /**
     * Get the agentPoolVersions property: List of versions available for agent pool.
     * 
     * @return the agentPoolVersions value.
     */
    public List<AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem> agentPoolVersions() {
        return this.agentPoolVersions;
    }

    /**
     * Set the agentPoolVersions property: List of versions available for agent pool.
     * 
     * @param agentPoolVersions the agentPoolVersions value to set.
     * @return the AgentPoolAvailableVersionsProperties object itself.
     */
    public AgentPoolAvailableVersionsProperties
        withAgentPoolVersions(List<AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem> agentPoolVersions) {
        this.agentPoolVersions = agentPoolVersions;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (agentPoolVersions() != null) {
            agentPoolVersions().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("agentPoolVersions", this.agentPoolVersions,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AgentPoolAvailableVersionsProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AgentPoolAvailableVersionsProperties if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AgentPoolAvailableVersionsProperties.
     */
    public static AgentPoolAvailableVersionsProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AgentPoolAvailableVersionsProperties deserializedAgentPoolAvailableVersionsProperties
                = new AgentPoolAvailableVersionsProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("agentPoolVersions".equals(fieldName)) {
                    List<AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem> agentPoolVersions
                        = reader.readArray(
                            reader1 -> AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem.fromJson(reader1));
                    deserializedAgentPoolAvailableVersionsProperties.agentPoolVersions = agentPoolVersions;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAgentPoolAvailableVersionsProperties;
        });
    }
}
