// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Current status on a group of nodes of the same vm size.
 */
@Fluent
public final class VirtualMachineNodes implements JsonSerializable<VirtualMachineNodes> {
    /*
     * The VM size of the agents used to host this group of nodes.
     */
    private String size;

    /*
     * Number of nodes.
     */
    private Integer count;

    /**
     * Creates an instance of VirtualMachineNodes class.
     */
    public VirtualMachineNodes() {
    }

    /**
     * Get the size property: The VM size of the agents used to host this group of nodes.
     * 
     * @return the size value.
     */
    public String size() {
        return this.size;
    }

    /**
     * Set the size property: The VM size of the agents used to host this group of nodes.
     * 
     * @param size the size value to set.
     * @return the VirtualMachineNodes object itself.
     */
    public VirtualMachineNodes withSize(String size) {
        this.size = size;
        return this;
    }

    /**
     * Get the count property: Number of nodes.
     * 
     * @return the count value.
     */
    public Integer count() {
        return this.count;
    }

    /**
     * Set the count property: Number of nodes.
     * 
     * @param count the count value to set.
     * @return the VirtualMachineNodes object itself.
     */
    public VirtualMachineNodes withCount(Integer count) {
        this.count = count;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("size", this.size);
        jsonWriter.writeNumberField("count", this.count);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VirtualMachineNodes from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VirtualMachineNodes if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the VirtualMachineNodes.
     */
    public static VirtualMachineNodes fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualMachineNodes deserializedVirtualMachineNodes = new VirtualMachineNodes();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("size".equals(fieldName)) {
                    deserializedVirtualMachineNodes.size = reader.getString();
                } else if ("count".equals(fieldName)) {
                    deserializedVirtualMachineNodes.count = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVirtualMachineNodes;
        });
    }
}
