// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The set of default Karpenter NodePools (CRDs) configured for node provisioning. This field has no effect unless mode
 * is 'Auto'. Warning: Changing this from Auto to None on an existing cluster will cause the default Karpenter NodePools
 * to be deleted, which will drain and delete the nodes associated with those pools. It is strongly recommended to not
 * do this unless there are idle nodes ready to take the pods evicted by that action. If not specified, the default is
 * Auto. For more information see aka.ms/aks/nap#node-pools.
 */
public final class NodeProvisioningDefaultNodePools extends ExpandableStringEnum<NodeProvisioningDefaultNodePools> {
    /**
     * Static value None for NodeProvisioningDefaultNodePools.
     */
    public static final NodeProvisioningDefaultNodePools NONE = fromString("None");

    /**
     * Static value Auto for NodeProvisioningDefaultNodePools.
     */
    public static final NodeProvisioningDefaultNodePools AUTO = fromString("Auto");

    /**
     * Creates a new instance of NodeProvisioningDefaultNodePools value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public NodeProvisioningDefaultNodePools() {
    }

    /**
     * Creates or finds a NodeProvisioningDefaultNodePools from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding NodeProvisioningDefaultNodePools.
     */
    public static NodeProvisioningDefaultNodePools fromString(String name) {
        return fromString(name, NodeProvisioningDefaultNodePools.class);
    }

    /**
     * Gets known NodeProvisioningDefaultNodePools values.
     * 
     * @return known NodeProvisioningDefaultNodePools values.
     */
    public static Collection<NodeProvisioningDefaultNodePools> values() {
        return values(NodeProvisioningDefaultNodePools.class);
    }
}
