// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The properties of the machine.
 */
@Immutable
public final class MachineProperties implements JsonSerializable<MachineProperties> {
    /*
     * network properties of the machine
     */
    private MachineNetworkProperties network;

    /*
     * Azure resource id of the machine. It can be used to GET underlying VM Instance
     */
    private String resourceId;

    /**
     * Creates an instance of MachineProperties class.
     */
    public MachineProperties() {
    }

    /**
     * Get the network property: network properties of the machine.
     * 
     * @return the network value.
     */
    public MachineNetworkProperties network() {
        return this.network;
    }

    /**
     * Get the resourceId property: Azure resource id of the machine. It can be used to GET underlying VM Instance.
     * 
     * @return the resourceId value.
     */
    public String resourceId() {
        return this.resourceId;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (network() != null) {
            network().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MachineProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MachineProperties if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the MachineProperties.
     */
    public static MachineProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MachineProperties deserializedMachineProperties = new MachineProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("network".equals(fieldName)) {
                    deserializedMachineProperties.network = MachineNetworkProperties.fromJson(reader);
                } else if ("resourceId".equals(fieldName)) {
                    deserializedMachineProperties.resourceId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMachineProperties;
        });
    }
}
