// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Network access of the key vault. Network access of key vault. The possible values are `Public` and `Private`.
 * `Public` means the key vault allows public access from all networks. `Private` means the key vault disables public
 * access and enables private link. The default value is `Public`.
 */
public final class KeyVaultNetworkAccessTypes extends ExpandableStringEnum<KeyVaultNetworkAccessTypes> {
    /**
     * Static value Public for KeyVaultNetworkAccessTypes.
     */
    public static final KeyVaultNetworkAccessTypes PUBLIC = fromString("Public");

    /**
     * Static value Private for KeyVaultNetworkAccessTypes.
     */
    public static final KeyVaultNetworkAccessTypes PRIVATE = fromString("Private");

    /**
     * Creates a new instance of KeyVaultNetworkAccessTypes value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public KeyVaultNetworkAccessTypes() {
    }

    /**
     * Creates or finds a KeyVaultNetworkAccessTypes from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding KeyVaultNetworkAccessTypes.
     */
    public static KeyVaultNetworkAccessTypes fromString(String name) {
        return fromString(name, KeyVaultNetworkAccessTypes.class);
    }

    /**
     * Gets known KeyVaultNetworkAccessTypes values.
     * 
     * @return known KeyVaultNetworkAccessTypes values.
     */
    public static Collection<KeyVaultNetworkAccessTypes> values() {
        return values(KeyVaultNetworkAccessTypes.class);
    }
}
