// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Profile of network configuration.
 */
@Fluent
public final class ContainerServiceNetworkProfile implements JsonSerializable<ContainerServiceNetworkProfile> {
    /*
     * Network plugin used for building the Kubernetes network.
     */
    private NetworkPlugin networkPlugin;

    /*
     * The mode the network plugin should use.
     */
    private NetworkPluginMode networkPluginMode;

    /*
     * Network policy used for building the Kubernetes network.
     */
    private NetworkPolicy networkPolicy;

    /*
     * The network mode Azure CNI is configured with. This cannot be specified if networkPlugin is anything other than
     * 'azure'.
     */
    private NetworkMode networkMode;

    /*
     * Network dataplane used in the Kubernetes cluster.
     */
    private NetworkDataplane networkDataplane;

    /*
     * Advanced Networking profile for enabling observability and security feature suite on a cluster. For more
     * information see aka.ms/aksadvancednetworking.
     */
    private AdvancedNetworking advancedNetworking;

    /*
     * A CIDR notation IP range from which to assign pod IPs when kubenet is used.
     */
    private String podCidr;

    /*
     * A CIDR notation IP range from which to assign service cluster IPs. It must not overlap with any Subnet IP ranges.
     */
    private String serviceCidr;

    /*
     * An IP address assigned to the Kubernetes DNS service. It must be within the Kubernetes service address range
     * specified in serviceCidr.
     */
    private String dnsServiceIp;

    /*
     * The outbound (egress) routing method. This can only be set at cluster creation time and cannot be changed later.
     * For more information see [egress outbound type](https://docs.microsoft.com/azure/aks/egress-outboundtype).
     */
    private OutboundType outboundType;

    /*
     * The load balancer sku for the managed cluster. The default is 'standard'. See [Azure Load Balancer
     * SKUs](https://docs.microsoft.com/azure/load-balancer/skus) for more information about the differences between
     * load balancer SKUs.
     */
    private LoadBalancerSku loadBalancerSku;

    /*
     * Profile of the cluster load balancer.
     */
    private ManagedClusterLoadBalancerProfile loadBalancerProfile;

    /*
     * Profile of the cluster NAT gateway.
     */
    private ManagedClusterNatGatewayProfile natGatewayProfile;

    /*
     * The profile for Static Egress Gateway addon. For more details about Static Egress Gateway, see
     * https://aka.ms/aks/static-egress-gateway.
     */
    private ManagedClusterStaticEgressGatewayProfile staticEgressGatewayProfile;

    /*
     * The CIDR notation IP ranges from which to assign pod IPs. One IPv4 CIDR is expected for single-stack networking.
     * Two CIDRs, one for each IP family (IPv4/IPv6), is expected for dual-stack networking.
     */
    private List<String> podCidrs;

    /*
     * The CIDR notation IP ranges from which to assign service cluster IPs. One IPv4 CIDR is expected for single-stack
     * networking. Two CIDRs, one for each IP family (IPv4/IPv6), is expected for dual-stack networking. They must not
     * overlap with any Subnet IP ranges.
     */
    private List<String> serviceCidrs;

    /*
     * The IP families used to specify IP versions available to the cluster. IP families are used to determine
     * single-stack or dual-stack clusters. For single-stack, the expected value is IPv4. For dual-stack, the expected
     * values are IPv4 and IPv6.
     */
    private List<IpFamily> ipFamilies;

    /**
     * Creates an instance of ContainerServiceNetworkProfile class.
     */
    public ContainerServiceNetworkProfile() {
    }

    /**
     * Get the networkPlugin property: Network plugin used for building the Kubernetes network.
     * 
     * @return the networkPlugin value.
     */
    public NetworkPlugin networkPlugin() {
        return this.networkPlugin;
    }

    /**
     * Set the networkPlugin property: Network plugin used for building the Kubernetes network.
     * 
     * @param networkPlugin the networkPlugin value to set.
     * @return the ContainerServiceNetworkProfile object itself.
     */
    public ContainerServiceNetworkProfile withNetworkPlugin(NetworkPlugin networkPlugin) {
        this.networkPlugin = networkPlugin;
        return this;
    }

    /**
     * Get the networkPluginMode property: The mode the network plugin should use.
     * 
     * @return the networkPluginMode value.
     */
    public NetworkPluginMode networkPluginMode() {
        return this.networkPluginMode;
    }

    /**
     * Set the networkPluginMode property: The mode the network plugin should use.
     * 
     * @param networkPluginMode the networkPluginMode value to set.
     * @return the ContainerServiceNetworkProfile object itself.
     */
    public ContainerServiceNetworkProfile withNetworkPluginMode(NetworkPluginMode networkPluginMode) {
        this.networkPluginMode = networkPluginMode;
        return this;
    }

    /**
     * Get the networkPolicy property: Network policy used for building the Kubernetes network.
     * 
     * @return the networkPolicy value.
     */
    public NetworkPolicy networkPolicy() {
        return this.networkPolicy;
    }

    /**
     * Set the networkPolicy property: Network policy used for building the Kubernetes network.
     * 
     * @param networkPolicy the networkPolicy value to set.
     * @return the ContainerServiceNetworkProfile object itself.
     */
    public ContainerServiceNetworkProfile withNetworkPolicy(NetworkPolicy networkPolicy) {
        this.networkPolicy = networkPolicy;
        return this;
    }

    /**
     * Get the networkMode property: The network mode Azure CNI is configured with. This cannot be specified if
     * networkPlugin is anything other than 'azure'.
     * 
     * @return the networkMode value.
     */
    public NetworkMode networkMode() {
        return this.networkMode;
    }

    /**
     * Set the networkMode property: The network mode Azure CNI is configured with. This cannot be specified if
     * networkPlugin is anything other than 'azure'.
     * 
     * @param networkMode the networkMode value to set.
     * @return the ContainerServiceNetworkProfile object itself.
     */
    public ContainerServiceNetworkProfile withNetworkMode(NetworkMode networkMode) {
        this.networkMode = networkMode;
        return this;
    }

    /**
     * Get the networkDataplane property: Network dataplane used in the Kubernetes cluster.
     * 
     * @return the networkDataplane value.
     */
    public NetworkDataplane networkDataplane() {
        return this.networkDataplane;
    }

    /**
     * Set the networkDataplane property: Network dataplane used in the Kubernetes cluster.
     * 
     * @param networkDataplane the networkDataplane value to set.
     * @return the ContainerServiceNetworkProfile object itself.
     */
    public ContainerServiceNetworkProfile withNetworkDataplane(NetworkDataplane networkDataplane) {
        this.networkDataplane = networkDataplane;
        return this;
    }

    /**
     * Get the advancedNetworking property: Advanced Networking profile for enabling observability and security feature
     * suite on a cluster. For more information see aka.ms/aksadvancednetworking.
     * 
     * @return the advancedNetworking value.
     */
    public AdvancedNetworking advancedNetworking() {
        return this.advancedNetworking;
    }

    /**
     * Set the advancedNetworking property: Advanced Networking profile for enabling observability and security feature
     * suite on a cluster. For more information see aka.ms/aksadvancednetworking.
     * 
     * @param advancedNetworking the advancedNetworking value to set.
     * @return the ContainerServiceNetworkProfile object itself.
     */
    public ContainerServiceNetworkProfile withAdvancedNetworking(AdvancedNetworking advancedNetworking) {
        this.advancedNetworking = advancedNetworking;
        return this;
    }

    /**
     * Get the podCidr property: A CIDR notation IP range from which to assign pod IPs when kubenet is used.
     * 
     * @return the podCidr value.
     */
    public String podCidr() {
        return this.podCidr;
    }

    /**
     * Set the podCidr property: A CIDR notation IP range from which to assign pod IPs when kubenet is used.
     * 
     * @param podCidr the podCidr value to set.
     * @return the ContainerServiceNetworkProfile object itself.
     */
    public ContainerServiceNetworkProfile withPodCidr(String podCidr) {
        this.podCidr = podCidr;
        return this;
    }

    /**
     * Get the serviceCidr property: A CIDR notation IP range from which to assign service cluster IPs. It must not
     * overlap with any Subnet IP ranges.
     * 
     * @return the serviceCidr value.
     */
    public String serviceCidr() {
        return this.serviceCidr;
    }

    /**
     * Set the serviceCidr property: A CIDR notation IP range from which to assign service cluster IPs. It must not
     * overlap with any Subnet IP ranges.
     * 
     * @param serviceCidr the serviceCidr value to set.
     * @return the ContainerServiceNetworkProfile object itself.
     */
    public ContainerServiceNetworkProfile withServiceCidr(String serviceCidr) {
        this.serviceCidr = serviceCidr;
        return this;
    }

    /**
     * Get the dnsServiceIp property: An IP address assigned to the Kubernetes DNS service. It must be within the
     * Kubernetes service address range specified in serviceCidr.
     * 
     * @return the dnsServiceIp value.
     */
    public String dnsServiceIp() {
        return this.dnsServiceIp;
    }

    /**
     * Set the dnsServiceIp property: An IP address assigned to the Kubernetes DNS service. It must be within the
     * Kubernetes service address range specified in serviceCidr.
     * 
     * @param dnsServiceIp the dnsServiceIp value to set.
     * @return the ContainerServiceNetworkProfile object itself.
     */
    public ContainerServiceNetworkProfile withDnsServiceIp(String dnsServiceIp) {
        this.dnsServiceIp = dnsServiceIp;
        return this;
    }

    /**
     * Get the outboundType property: The outbound (egress) routing method. This can only be set at cluster creation
     * time and cannot be changed later. For more information see [egress outbound
     * type](https://docs.microsoft.com/azure/aks/egress-outboundtype).
     * 
     * @return the outboundType value.
     */
    public OutboundType outboundType() {
        return this.outboundType;
    }

    /**
     * Set the outboundType property: The outbound (egress) routing method. This can only be set at cluster creation
     * time and cannot be changed later. For more information see [egress outbound
     * type](https://docs.microsoft.com/azure/aks/egress-outboundtype).
     * 
     * @param outboundType the outboundType value to set.
     * @return the ContainerServiceNetworkProfile object itself.
     */
    public ContainerServiceNetworkProfile withOutboundType(OutboundType outboundType) {
        this.outboundType = outboundType;
        return this;
    }

    /**
     * Get the loadBalancerSku property: The load balancer sku for the managed cluster. The default is 'standard'. See
     * [Azure Load Balancer SKUs](https://docs.microsoft.com/azure/load-balancer/skus) for more information about the
     * differences between load balancer SKUs.
     * 
     * @return the loadBalancerSku value.
     */
    public LoadBalancerSku loadBalancerSku() {
        return this.loadBalancerSku;
    }

    /**
     * Set the loadBalancerSku property: The load balancer sku for the managed cluster. The default is 'standard'. See
     * [Azure Load Balancer SKUs](https://docs.microsoft.com/azure/load-balancer/skus) for more information about the
     * differences between load balancer SKUs.
     * 
     * @param loadBalancerSku the loadBalancerSku value to set.
     * @return the ContainerServiceNetworkProfile object itself.
     */
    public ContainerServiceNetworkProfile withLoadBalancerSku(LoadBalancerSku loadBalancerSku) {
        this.loadBalancerSku = loadBalancerSku;
        return this;
    }

    /**
     * Get the loadBalancerProfile property: Profile of the cluster load balancer.
     * 
     * @return the loadBalancerProfile value.
     */
    public ManagedClusterLoadBalancerProfile loadBalancerProfile() {
        return this.loadBalancerProfile;
    }

    /**
     * Set the loadBalancerProfile property: Profile of the cluster load balancer.
     * 
     * @param loadBalancerProfile the loadBalancerProfile value to set.
     * @return the ContainerServiceNetworkProfile object itself.
     */
    public ContainerServiceNetworkProfile
        withLoadBalancerProfile(ManagedClusterLoadBalancerProfile loadBalancerProfile) {
        this.loadBalancerProfile = loadBalancerProfile;
        return this;
    }

    /**
     * Get the natGatewayProfile property: Profile of the cluster NAT gateway.
     * 
     * @return the natGatewayProfile value.
     */
    public ManagedClusterNatGatewayProfile natGatewayProfile() {
        return this.natGatewayProfile;
    }

    /**
     * Set the natGatewayProfile property: Profile of the cluster NAT gateway.
     * 
     * @param natGatewayProfile the natGatewayProfile value to set.
     * @return the ContainerServiceNetworkProfile object itself.
     */
    public ContainerServiceNetworkProfile withNatGatewayProfile(ManagedClusterNatGatewayProfile natGatewayProfile) {
        this.natGatewayProfile = natGatewayProfile;
        return this;
    }

    /**
     * Get the staticEgressGatewayProfile property: The profile for Static Egress Gateway addon. For more details about
     * Static Egress Gateway, see https://aka.ms/aks/static-egress-gateway.
     * 
     * @return the staticEgressGatewayProfile value.
     */
    public ManagedClusterStaticEgressGatewayProfile staticEgressGatewayProfile() {
        return this.staticEgressGatewayProfile;
    }

    /**
     * Set the staticEgressGatewayProfile property: The profile for Static Egress Gateway addon. For more details about
     * Static Egress Gateway, see https://aka.ms/aks/static-egress-gateway.
     * 
     * @param staticEgressGatewayProfile the staticEgressGatewayProfile value to set.
     * @return the ContainerServiceNetworkProfile object itself.
     */
    public ContainerServiceNetworkProfile
        withStaticEgressGatewayProfile(ManagedClusterStaticEgressGatewayProfile staticEgressGatewayProfile) {
        this.staticEgressGatewayProfile = staticEgressGatewayProfile;
        return this;
    }

    /**
     * Get the podCidrs property: The CIDR notation IP ranges from which to assign pod IPs. One IPv4 CIDR is expected
     * for single-stack networking. Two CIDRs, one for each IP family (IPv4/IPv6), is expected for dual-stack
     * networking.
     * 
     * @return the podCidrs value.
     */
    public List<String> podCidrs() {
        return this.podCidrs;
    }

    /**
     * Set the podCidrs property: The CIDR notation IP ranges from which to assign pod IPs. One IPv4 CIDR is expected
     * for single-stack networking. Two CIDRs, one for each IP family (IPv4/IPv6), is expected for dual-stack
     * networking.
     * 
     * @param podCidrs the podCidrs value to set.
     * @return the ContainerServiceNetworkProfile object itself.
     */
    public ContainerServiceNetworkProfile withPodCidrs(List<String> podCidrs) {
        this.podCidrs = podCidrs;
        return this;
    }

    /**
     * Get the serviceCidrs property: The CIDR notation IP ranges from which to assign service cluster IPs. One IPv4
     * CIDR is expected for single-stack networking. Two CIDRs, one for each IP family (IPv4/IPv6), is expected for
     * dual-stack networking. They must not overlap with any Subnet IP ranges.
     * 
     * @return the serviceCidrs value.
     */
    public List<String> serviceCidrs() {
        return this.serviceCidrs;
    }

    /**
     * Set the serviceCidrs property: The CIDR notation IP ranges from which to assign service cluster IPs. One IPv4
     * CIDR is expected for single-stack networking. Two CIDRs, one for each IP family (IPv4/IPv6), is expected for
     * dual-stack networking. They must not overlap with any Subnet IP ranges.
     * 
     * @param serviceCidrs the serviceCidrs value to set.
     * @return the ContainerServiceNetworkProfile object itself.
     */
    public ContainerServiceNetworkProfile withServiceCidrs(List<String> serviceCidrs) {
        this.serviceCidrs = serviceCidrs;
        return this;
    }

    /**
     * Get the ipFamilies property: The IP families used to specify IP versions available to the cluster. IP families
     * are used to determine single-stack or dual-stack clusters. For single-stack, the expected value is IPv4. For
     * dual-stack, the expected values are IPv4 and IPv6.
     * 
     * @return the ipFamilies value.
     */
    public List<IpFamily> ipFamilies() {
        return this.ipFamilies;
    }

    /**
     * Set the ipFamilies property: The IP families used to specify IP versions available to the cluster. IP families
     * are used to determine single-stack or dual-stack clusters. For single-stack, the expected value is IPv4. For
     * dual-stack, the expected values are IPv4 and IPv6.
     * 
     * @param ipFamilies the ipFamilies value to set.
     * @return the ContainerServiceNetworkProfile object itself.
     */
    public ContainerServiceNetworkProfile withIpFamilies(List<IpFamily> ipFamilies) {
        this.ipFamilies = ipFamilies;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (advancedNetworking() != null) {
            advancedNetworking().validate();
        }
        if (loadBalancerProfile() != null) {
            loadBalancerProfile().validate();
        }
        if (natGatewayProfile() != null) {
            natGatewayProfile().validate();
        }
        if (staticEgressGatewayProfile() != null) {
            staticEgressGatewayProfile().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("networkPlugin", this.networkPlugin == null ? null : this.networkPlugin.toString());
        jsonWriter.writeStringField("networkPluginMode",
            this.networkPluginMode == null ? null : this.networkPluginMode.toString());
        jsonWriter.writeStringField("networkPolicy", this.networkPolicy == null ? null : this.networkPolicy.toString());
        jsonWriter.writeStringField("networkMode", this.networkMode == null ? null : this.networkMode.toString());
        jsonWriter.writeStringField("networkDataplane",
            this.networkDataplane == null ? null : this.networkDataplane.toString());
        jsonWriter.writeJsonField("advancedNetworking", this.advancedNetworking);
        jsonWriter.writeStringField("podCidr", this.podCidr);
        jsonWriter.writeStringField("serviceCidr", this.serviceCidr);
        jsonWriter.writeStringField("dnsServiceIP", this.dnsServiceIp);
        jsonWriter.writeStringField("outboundType", this.outboundType == null ? null : this.outboundType.toString());
        jsonWriter.writeStringField("loadBalancerSku",
            this.loadBalancerSku == null ? null : this.loadBalancerSku.toString());
        jsonWriter.writeJsonField("loadBalancerProfile", this.loadBalancerProfile);
        jsonWriter.writeJsonField("natGatewayProfile", this.natGatewayProfile);
        jsonWriter.writeJsonField("staticEgressGatewayProfile", this.staticEgressGatewayProfile);
        jsonWriter.writeArrayField("podCidrs", this.podCidrs, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("serviceCidrs", this.serviceCidrs, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("ipFamilies", this.ipFamilies,
            (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ContainerServiceNetworkProfile from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ContainerServiceNetworkProfile if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ContainerServiceNetworkProfile.
     */
    public static ContainerServiceNetworkProfile fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ContainerServiceNetworkProfile deserializedContainerServiceNetworkProfile
                = new ContainerServiceNetworkProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("networkPlugin".equals(fieldName)) {
                    deserializedContainerServiceNetworkProfile.networkPlugin
                        = NetworkPlugin.fromString(reader.getString());
                } else if ("networkPluginMode".equals(fieldName)) {
                    deserializedContainerServiceNetworkProfile.networkPluginMode
                        = NetworkPluginMode.fromString(reader.getString());
                } else if ("networkPolicy".equals(fieldName)) {
                    deserializedContainerServiceNetworkProfile.networkPolicy
                        = NetworkPolicy.fromString(reader.getString());
                } else if ("networkMode".equals(fieldName)) {
                    deserializedContainerServiceNetworkProfile.networkMode = NetworkMode.fromString(reader.getString());
                } else if ("networkDataplane".equals(fieldName)) {
                    deserializedContainerServiceNetworkProfile.networkDataplane
                        = NetworkDataplane.fromString(reader.getString());
                } else if ("advancedNetworking".equals(fieldName)) {
                    deserializedContainerServiceNetworkProfile.advancedNetworking = AdvancedNetworking.fromJson(reader);
                } else if ("podCidr".equals(fieldName)) {
                    deserializedContainerServiceNetworkProfile.podCidr = reader.getString();
                } else if ("serviceCidr".equals(fieldName)) {
                    deserializedContainerServiceNetworkProfile.serviceCidr = reader.getString();
                } else if ("dnsServiceIP".equals(fieldName)) {
                    deserializedContainerServiceNetworkProfile.dnsServiceIp = reader.getString();
                } else if ("outboundType".equals(fieldName)) {
                    deserializedContainerServiceNetworkProfile.outboundType
                        = OutboundType.fromString(reader.getString());
                } else if ("loadBalancerSku".equals(fieldName)) {
                    deserializedContainerServiceNetworkProfile.loadBalancerSku
                        = LoadBalancerSku.fromString(reader.getString());
                } else if ("loadBalancerProfile".equals(fieldName)) {
                    deserializedContainerServiceNetworkProfile.loadBalancerProfile
                        = ManagedClusterLoadBalancerProfile.fromJson(reader);
                } else if ("natGatewayProfile".equals(fieldName)) {
                    deserializedContainerServiceNetworkProfile.natGatewayProfile
                        = ManagedClusterNatGatewayProfile.fromJson(reader);
                } else if ("staticEgressGatewayProfile".equals(fieldName)) {
                    deserializedContainerServiceNetworkProfile.staticEgressGatewayProfile
                        = ManagedClusterStaticEgressGatewayProfile.fromJson(reader);
                } else if ("podCidrs".equals(fieldName)) {
                    List<String> podCidrs = reader.readArray(reader1 -> reader1.getString());
                    deserializedContainerServiceNetworkProfile.podCidrs = podCidrs;
                } else if ("serviceCidrs".equals(fieldName)) {
                    List<String> serviceCidrs = reader.readArray(reader1 -> reader1.getString());
                    deserializedContainerServiceNetworkProfile.serviceCidrs = serviceCidrs;
                } else if ("ipFamilies".equals(fieldName)) {
                    List<IpFamily> ipFamilies = reader.readArray(reader1 -> IpFamily.fromString(reader1.getString()));
                    deserializedContainerServiceNetworkProfile.ipFamilies = ipFamilies;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedContainerServiceNetworkProfile;
        });
    }
}
