// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerservice.models.ManagedClusterPoolUpgradeProfile;
import java.io.IOException;
import java.util.List;

/**
 * Control plane and agent pool upgrade profiles.
 */
@Fluent
public final class ManagedClusterUpgradeProfileProperties
    implements JsonSerializable<ManagedClusterUpgradeProfileProperties> {
    /*
     * The list of available upgrade versions for the control plane.
     */
    private ManagedClusterPoolUpgradeProfile controlPlaneProfile;

    /*
     * The list of available upgrade versions for agent pools.
     */
    private List<ManagedClusterPoolUpgradeProfile> agentPoolProfiles;

    /**
     * Creates an instance of ManagedClusterUpgradeProfileProperties class.
     */
    public ManagedClusterUpgradeProfileProperties() {
    }

    /**
     * Get the controlPlaneProfile property: The list of available upgrade versions for the control plane.
     * 
     * @return the controlPlaneProfile value.
     */
    public ManagedClusterPoolUpgradeProfile controlPlaneProfile() {
        return this.controlPlaneProfile;
    }

    /**
     * Set the controlPlaneProfile property: The list of available upgrade versions for the control plane.
     * 
     * @param controlPlaneProfile the controlPlaneProfile value to set.
     * @return the ManagedClusterUpgradeProfileProperties object itself.
     */
    public ManagedClusterUpgradeProfileProperties
        withControlPlaneProfile(ManagedClusterPoolUpgradeProfile controlPlaneProfile) {
        this.controlPlaneProfile = controlPlaneProfile;
        return this;
    }

    /**
     * Get the agentPoolProfiles property: The list of available upgrade versions for agent pools.
     * 
     * @return the agentPoolProfiles value.
     */
    public List<ManagedClusterPoolUpgradeProfile> agentPoolProfiles() {
        return this.agentPoolProfiles;
    }

    /**
     * Set the agentPoolProfiles property: The list of available upgrade versions for agent pools.
     * 
     * @param agentPoolProfiles the agentPoolProfiles value to set.
     * @return the ManagedClusterUpgradeProfileProperties object itself.
     */
    public ManagedClusterUpgradeProfileProperties
        withAgentPoolProfiles(List<ManagedClusterPoolUpgradeProfile> agentPoolProfiles) {
        this.agentPoolProfiles = agentPoolProfiles;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (controlPlaneProfile() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property controlPlaneProfile in model ManagedClusterUpgradeProfileProperties"));
        } else {
            controlPlaneProfile().validate();
        }
        if (agentPoolProfiles() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property agentPoolProfiles in model ManagedClusterUpgradeProfileProperties"));
        } else {
            agentPoolProfiles().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ManagedClusterUpgradeProfileProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("controlPlaneProfile", this.controlPlaneProfile);
        jsonWriter.writeArrayField("agentPoolProfiles", this.agentPoolProfiles,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagedClusterUpgradeProfileProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagedClusterUpgradeProfileProperties if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ManagedClusterUpgradeProfileProperties.
     */
    public static ManagedClusterUpgradeProfileProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedClusterUpgradeProfileProperties deserializedManagedClusterUpgradeProfileProperties
                = new ManagedClusterUpgradeProfileProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("controlPlaneProfile".equals(fieldName)) {
                    deserializedManagedClusterUpgradeProfileProperties.controlPlaneProfile
                        = ManagedClusterPoolUpgradeProfile.fromJson(reader);
                } else if ("agentPoolProfiles".equals(fieldName)) {
                    List<ManagedClusterPoolUpgradeProfile> agentPoolProfiles
                        = reader.readArray(reader1 -> ManagedClusterPoolUpgradeProfile.fromJson(reader1));
                    deserializedManagedClusterUpgradeProfileProperties.agentPoolProfiles = agentPoolProfiles;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagedClusterUpgradeProfileProperties;
        });
    }
}
