// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * KEDA (Kubernetes Event-driven Autoscaling) settings for the workload auto-scaler profile.
 */
@Fluent
public final class ManagedClusterWorkloadAutoScalerProfileKeda
    implements JsonSerializable<ManagedClusterWorkloadAutoScalerProfileKeda> {
    /*
     * Whether to enable KEDA.
     */
    private boolean enabled;

    /**
     * Creates an instance of ManagedClusterWorkloadAutoScalerProfileKeda class.
     */
    public ManagedClusterWorkloadAutoScalerProfileKeda() {
    }

    /**
     * Get the enabled property: Whether to enable KEDA.
     * 
     * @return the enabled value.
     */
    public boolean enabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: Whether to enable KEDA.
     * 
     * @param enabled the enabled value to set.
     * @return the ManagedClusterWorkloadAutoScalerProfileKeda object itself.
     */
    public ManagedClusterWorkloadAutoScalerProfileKeda withEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagedClusterWorkloadAutoScalerProfileKeda from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagedClusterWorkloadAutoScalerProfileKeda if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ManagedClusterWorkloadAutoScalerProfileKeda.
     */
    public static ManagedClusterWorkloadAutoScalerProfileKeda fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedClusterWorkloadAutoScalerProfileKeda deserializedManagedClusterWorkloadAutoScalerProfileKeda
                = new ManagedClusterWorkloadAutoScalerProfileKeda();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("enabled".equals(fieldName)) {
                    deserializedManagedClusterWorkloadAutoScalerProfileKeda.enabled = reader.getBoolean();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagedClusterWorkloadAutoScalerProfileKeda;
        });
    }
}
