// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * AzureBlob CSI Driver settings for the storage profile.
 */
@Fluent
public final class ManagedClusterStorageProfileBlobCsiDriver
    implements JsonSerializable<ManagedClusterStorageProfileBlobCsiDriver> {
    /*
     * Whether to enable AzureBlob CSI Driver. The default value is false.
     */
    private Boolean enabled;

    /**
     * Creates an instance of ManagedClusterStorageProfileBlobCsiDriver class.
     */
    public ManagedClusterStorageProfileBlobCsiDriver() {
    }

    /**
     * Get the enabled property: Whether to enable AzureBlob CSI Driver. The default value is false.
     * 
     * @return the enabled value.
     */
    public Boolean enabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: Whether to enable AzureBlob CSI Driver. The default value is false.
     * 
     * @param enabled the enabled value to set.
     * @return the ManagedClusterStorageProfileBlobCsiDriver object itself.
     */
    public ManagedClusterStorageProfileBlobCsiDriver withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagedClusterStorageProfileBlobCsiDriver from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagedClusterStorageProfileBlobCsiDriver if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ManagedClusterStorageProfileBlobCsiDriver.
     */
    public static ManagedClusterStorageProfileBlobCsiDriver fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedClusterStorageProfileBlobCsiDriver deserializedManagedClusterStorageProfileBlobCsiDriver
                = new ManagedClusterStorageProfileBlobCsiDriver();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("enabled".equals(fieldName)) {
                    deserializedManagedClusterStorageProfileBlobCsiDriver.enabled
                        = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagedClusterStorageProfileBlobCsiDriver;
        });
    }
}
