// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Security profile for the container service cluster.
 */
@Fluent
public final class ManagedClusterSecurityProfile implements JsonSerializable<ManagedClusterSecurityProfile> {
    /*
     * Microsoft Defender settings for the security profile.
     */
    private ManagedClusterSecurityProfileDefender defender;

    /*
     * Azure Key Vault [key management service](https://kubernetes.io/docs/tasks/administer-cluster/kms-provider/)
     * settings for the security profile.
     */
    private AzureKeyVaultKms azureKeyVaultKms;

    /*
     * Workload identity settings for the security profile. Workload identity enables Kubernetes applications to access
     * Azure cloud resources securely with Azure AD. See https://aka.ms/aks/wi for more details.
     */
    private ManagedClusterSecurityProfileWorkloadIdentity workloadIdentity;

    /*
     * Image Cleaner settings for the security profile.
     */
    private ManagedClusterSecurityProfileImageCleaner imageCleaner;

    /*
     * A list of up to 10 base64 encoded CAs that will be added to the trust store on all nodes in the cluster. For more
     * information see [Custom CA Trust
     * Certificates](https://learn.microsoft.com/en-us/azure/aks/custom-certificate-authority).
     */
    private List<byte[]> customCATrustCertificates;

    /**
     * Creates an instance of ManagedClusterSecurityProfile class.
     */
    public ManagedClusterSecurityProfile() {
    }

    /**
     * Get the defender property: Microsoft Defender settings for the security profile.
     * 
     * @return the defender value.
     */
    public ManagedClusterSecurityProfileDefender defender() {
        return this.defender;
    }

    /**
     * Set the defender property: Microsoft Defender settings for the security profile.
     * 
     * @param defender the defender value to set.
     * @return the ManagedClusterSecurityProfile object itself.
     */
    public ManagedClusterSecurityProfile withDefender(ManagedClusterSecurityProfileDefender defender) {
        this.defender = defender;
        return this;
    }

    /**
     * Get the azureKeyVaultKms property: Azure Key Vault [key management
     * service](https://kubernetes.io/docs/tasks/administer-cluster/kms-provider/) settings for the security profile.
     * 
     * @return the azureKeyVaultKms value.
     */
    public AzureKeyVaultKms azureKeyVaultKms() {
        return this.azureKeyVaultKms;
    }

    /**
     * Set the azureKeyVaultKms property: Azure Key Vault [key management
     * service](https://kubernetes.io/docs/tasks/administer-cluster/kms-provider/) settings for the security profile.
     * 
     * @param azureKeyVaultKms the azureKeyVaultKms value to set.
     * @return the ManagedClusterSecurityProfile object itself.
     */
    public ManagedClusterSecurityProfile withAzureKeyVaultKms(AzureKeyVaultKms azureKeyVaultKms) {
        this.azureKeyVaultKms = azureKeyVaultKms;
        return this;
    }

    /**
     * Get the workloadIdentity property: Workload identity settings for the security profile. Workload identity enables
     * Kubernetes applications to access Azure cloud resources securely with Azure AD. See https://aka.ms/aks/wi for
     * more details.
     * 
     * @return the workloadIdentity value.
     */
    public ManagedClusterSecurityProfileWorkloadIdentity workloadIdentity() {
        return this.workloadIdentity;
    }

    /**
     * Set the workloadIdentity property: Workload identity settings for the security profile. Workload identity enables
     * Kubernetes applications to access Azure cloud resources securely with Azure AD. See https://aka.ms/aks/wi for
     * more details.
     * 
     * @param workloadIdentity the workloadIdentity value to set.
     * @return the ManagedClusterSecurityProfile object itself.
     */
    public ManagedClusterSecurityProfile
        withWorkloadIdentity(ManagedClusterSecurityProfileWorkloadIdentity workloadIdentity) {
        this.workloadIdentity = workloadIdentity;
        return this;
    }

    /**
     * Get the imageCleaner property: Image Cleaner settings for the security profile.
     * 
     * @return the imageCleaner value.
     */
    public ManagedClusterSecurityProfileImageCleaner imageCleaner() {
        return this.imageCleaner;
    }

    /**
     * Set the imageCleaner property: Image Cleaner settings for the security profile.
     * 
     * @param imageCleaner the imageCleaner value to set.
     * @return the ManagedClusterSecurityProfile object itself.
     */
    public ManagedClusterSecurityProfile withImageCleaner(ManagedClusterSecurityProfileImageCleaner imageCleaner) {
        this.imageCleaner = imageCleaner;
        return this;
    }

    /**
     * Get the customCATrustCertificates property: A list of up to 10 base64 encoded CAs that will be added to the trust
     * store on all nodes in the cluster. For more information see [Custom CA Trust
     * Certificates](https://learn.microsoft.com/en-us/azure/aks/custom-certificate-authority).
     * 
     * @return the customCATrustCertificates value.
     */
    public List<byte[]> customCATrustCertificates() {
        return this.customCATrustCertificates;
    }

    /**
     * Set the customCATrustCertificates property: A list of up to 10 base64 encoded CAs that will be added to the trust
     * store on all nodes in the cluster. For more information see [Custom CA Trust
     * Certificates](https://learn.microsoft.com/en-us/azure/aks/custom-certificate-authority).
     * 
     * @param customCATrustCertificates the customCATrustCertificates value to set.
     * @return the ManagedClusterSecurityProfile object itself.
     */
    public ManagedClusterSecurityProfile withCustomCATrustCertificates(List<byte[]> customCATrustCertificates) {
        this.customCATrustCertificates = customCATrustCertificates;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (defender() != null) {
            defender().validate();
        }
        if (azureKeyVaultKms() != null) {
            azureKeyVaultKms().validate();
        }
        if (workloadIdentity() != null) {
            workloadIdentity().validate();
        }
        if (imageCleaner() != null) {
            imageCleaner().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("defender", this.defender);
        jsonWriter.writeJsonField("azureKeyVaultKms", this.azureKeyVaultKms);
        jsonWriter.writeJsonField("workloadIdentity", this.workloadIdentity);
        jsonWriter.writeJsonField("imageCleaner", this.imageCleaner);
        jsonWriter.writeArrayField("customCATrustCertificates", this.customCATrustCertificates,
            (writer, element) -> writer.writeBinary(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagedClusterSecurityProfile from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagedClusterSecurityProfile if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ManagedClusterSecurityProfile.
     */
    public static ManagedClusterSecurityProfile fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedClusterSecurityProfile deserializedManagedClusterSecurityProfile
                = new ManagedClusterSecurityProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("defender".equals(fieldName)) {
                    deserializedManagedClusterSecurityProfile.defender
                        = ManagedClusterSecurityProfileDefender.fromJson(reader);
                } else if ("azureKeyVaultKms".equals(fieldName)) {
                    deserializedManagedClusterSecurityProfile.azureKeyVaultKms = AzureKeyVaultKms.fromJson(reader);
                } else if ("workloadIdentity".equals(fieldName)) {
                    deserializedManagedClusterSecurityProfile.workloadIdentity
                        = ManagedClusterSecurityProfileWorkloadIdentity.fromJson(reader);
                } else if ("imageCleaner".equals(fieldName)) {
                    deserializedManagedClusterSecurityProfile.imageCleaner
                        = ManagedClusterSecurityProfileImageCleaner.fromJson(reader);
                } else if ("customCATrustCertificates".equals(fieldName)) {
                    List<byte[]> customCATrustCertificates = reader.readArray(reader1 -> reader1.getBinary());
                    deserializedManagedClusterSecurityProfile.customCATrustCertificates = customCATrustCertificates;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagedClusterSecurityProfile;
        });
    }
}
