// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The OIDC issuer profile of the Managed Cluster.
 */
@Fluent
public final class ManagedClusterOidcIssuerProfile implements JsonSerializable<ManagedClusterOidcIssuerProfile> {
    /*
     * The OIDC issuer url of the Managed Cluster.
     */
    private String issuerUrl;

    /*
     * Whether the OIDC issuer is enabled.
     */
    private Boolean enabled;

    /**
     * Creates an instance of ManagedClusterOidcIssuerProfile class.
     */
    public ManagedClusterOidcIssuerProfile() {
    }

    /**
     * Get the issuerUrl property: The OIDC issuer url of the Managed Cluster.
     * 
     * @return the issuerUrl value.
     */
    public String issuerUrl() {
        return this.issuerUrl;
    }

    /**
     * Get the enabled property: Whether the OIDC issuer is enabled.
     * 
     * @return the enabled value.
     */
    public Boolean enabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: Whether the OIDC issuer is enabled.
     * 
     * @param enabled the enabled value to set.
     * @return the ManagedClusterOidcIssuerProfile object itself.
     */
    public ManagedClusterOidcIssuerProfile withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagedClusterOidcIssuerProfile from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagedClusterOidcIssuerProfile if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ManagedClusterOidcIssuerProfile.
     */
    public static ManagedClusterOidcIssuerProfile fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedClusterOidcIssuerProfile deserializedManagedClusterOidcIssuerProfile
                = new ManagedClusterOidcIssuerProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("issuerURL".equals(fieldName)) {
                    deserializedManagedClusterOidcIssuerProfile.issuerUrl = reader.getString();
                } else if ("enabled".equals(fieldName)) {
                    deserializedManagedClusterOidcIssuerProfile.enabled = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagedClusterOidcIssuerProfile;
        });
    }
}
