// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Ingress profile for the container service cluster.
 */
@Fluent
public final class ManagedClusterIngressProfile implements JsonSerializable<ManagedClusterIngressProfile> {
    /*
     * App Routing settings for the ingress profile. You can find an overview and onboarding guide for this feature at
     * https://learn.microsoft.com/en-us/azure/aks/app-routing?tabs=default%2Cdeploy-app-default.
     */
    private ManagedClusterIngressProfileWebAppRouting webAppRouting;

    /**
     * Creates an instance of ManagedClusterIngressProfile class.
     */
    public ManagedClusterIngressProfile() {
    }

    /**
     * Get the webAppRouting property: App Routing settings for the ingress profile. You can find an overview and
     * onboarding guide for this feature at
     * https://learn.microsoft.com/en-us/azure/aks/app-routing?tabs=default%2Cdeploy-app-default.
     * 
     * @return the webAppRouting value.
     */
    public ManagedClusterIngressProfileWebAppRouting webAppRouting() {
        return this.webAppRouting;
    }

    /**
     * Set the webAppRouting property: App Routing settings for the ingress profile. You can find an overview and
     * onboarding guide for this feature at
     * https://learn.microsoft.com/en-us/azure/aks/app-routing?tabs=default%2Cdeploy-app-default.
     * 
     * @param webAppRouting the webAppRouting value to set.
     * @return the ManagedClusterIngressProfile object itself.
     */
    public ManagedClusterIngressProfile withWebAppRouting(ManagedClusterIngressProfileWebAppRouting webAppRouting) {
        this.webAppRouting = webAppRouting;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (webAppRouting() != null) {
            webAppRouting().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("webAppRouting", this.webAppRouting);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagedClusterIngressProfile from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagedClusterIngressProfile if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ManagedClusterIngressProfile.
     */
    public static ManagedClusterIngressProfile fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedClusterIngressProfile deserializedManagedClusterIngressProfile = new ManagedClusterIngressProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("webAppRouting".equals(fieldName)) {
                    deserializedManagedClusterIngressProfile.webAppRouting
                        = ManagedClusterIngressProfileWebAppRouting.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagedClusterIngressProfile;
        });
    }
}
