// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Istio ingress gateway configuration. For now, we support up to one external ingress gateway named
 * `aks-istio-ingressgateway-external` and one internal ingress gateway named `aks-istio-ingressgateway-internal`.
 */
@Fluent
public final class IstioIngressGateway implements JsonSerializable<IstioIngressGateway> {
    /*
     * Mode of an ingress gateway.
     */
    private IstioIngressGatewayMode mode;

    /*
     * Whether to enable the ingress gateway.
     */
    private boolean enabled;

    /**
     * Creates an instance of IstioIngressGateway class.
     */
    public IstioIngressGateway() {
    }

    /**
     * Get the mode property: Mode of an ingress gateway.
     * 
     * @return the mode value.
     */
    public IstioIngressGatewayMode mode() {
        return this.mode;
    }

    /**
     * Set the mode property: Mode of an ingress gateway.
     * 
     * @param mode the mode value to set.
     * @return the IstioIngressGateway object itself.
     */
    public IstioIngressGateway withMode(IstioIngressGatewayMode mode) {
        this.mode = mode;
        return this;
    }

    /**
     * Get the enabled property: Whether to enable the ingress gateway.
     * 
     * @return the enabled value.
     */
    public boolean enabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: Whether to enable the ingress gateway.
     * 
     * @param enabled the enabled value to set.
     * @return the IstioIngressGateway object itself.
     */
    public IstioIngressGateway withEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (mode() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property mode in model IstioIngressGateway"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(IstioIngressGateway.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("mode", this.mode == null ? null : this.mode.toString());
        jsonWriter.writeBooleanField("enabled", this.enabled);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of IstioIngressGateway from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of IstioIngressGateway if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the IstioIngressGateway.
     */
    public static IstioIngressGateway fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            IstioIngressGateway deserializedIstioIngressGateway = new IstioIngressGateway();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("mode".equals(fieldName)) {
                    deserializedIstioIngressGateway.mode = IstioIngressGatewayMode.fromString(reader.getString());
                } else if ("enabled".equals(fieldName)) {
                    deserializedIstioIngressGateway.enabled = reader.getBoolean();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedIstioIngressGateway;
        });
    }
}
