// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * connect information from the AKS agent nodes to a single endpoint.
 */
@Fluent
public final class EndpointDetail implements JsonSerializable<EndpointDetail> {
    /*
     * An IP Address that Domain Name currently resolves to.
     */
    private String ipAddress;

    /*
     * The port an endpoint is connected to.
     */
    private Integer port;

    /*
     * The protocol used for connection
     */
    private String protocol;

    /*
     * Description of the detail
     */
    private String description;

    /**
     * Creates an instance of EndpointDetail class.
     */
    public EndpointDetail() {
    }

    /**
     * Get the ipAddress property: An IP Address that Domain Name currently resolves to.
     * 
     * @return the ipAddress value.
     */
    public String ipAddress() {
        return this.ipAddress;
    }

    /**
     * Set the ipAddress property: An IP Address that Domain Name currently resolves to.
     * 
     * @param ipAddress the ipAddress value to set.
     * @return the EndpointDetail object itself.
     */
    public EndpointDetail withIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    /**
     * Get the port property: The port an endpoint is connected to.
     * 
     * @return the port value.
     */
    public Integer port() {
        return this.port;
    }

    /**
     * Set the port property: The port an endpoint is connected to.
     * 
     * @param port the port value to set.
     * @return the EndpointDetail object itself.
     */
    public EndpointDetail withPort(Integer port) {
        this.port = port;
        return this;
    }

    /**
     * Get the protocol property: The protocol used for connection.
     * 
     * @return the protocol value.
     */
    public String protocol() {
        return this.protocol;
    }

    /**
     * Set the protocol property: The protocol used for connection.
     * 
     * @param protocol the protocol value to set.
     * @return the EndpointDetail object itself.
     */
    public EndpointDetail withProtocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    /**
     * Get the description property: Description of the detail.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: Description of the detail.
     * 
     * @param description the description value to set.
     * @return the EndpointDetail object itself.
     */
    public EndpointDetail withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("ipAddress", this.ipAddress);
        jsonWriter.writeNumberField("port", this.port);
        jsonWriter.writeStringField("protocol", this.protocol);
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of EndpointDetail from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of EndpointDetail if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the EndpointDetail.
     */
    public static EndpointDetail fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            EndpointDetail deserializedEndpointDetail = new EndpointDetail();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("ipAddress".equals(fieldName)) {
                    deserializedEndpointDetail.ipAddress = reader.getString();
                } else if ("port".equals(fieldName)) {
                    deserializedEndpointDetail.port = reader.getNullable(JsonReader::getInt);
                } else if ("protocol".equals(fieldName)) {
                    deserializedEndpointDetail.protocol = reader.getString();
                } else if ("description".equals(fieldName)) {
                    deserializedEndpointDetail.description = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedEndpointDetail;
        });
    }
}
