// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerservice.models.MachineProperties;
import java.io.IOException;
import java.util.List;

/**
 * A machine. Contains details about the underlying virtual machine. A machine may be visible here but not in kubectl
 * get nodes; if so it may be because the machine has not been registered with the Kubernetes API Server yet.
 */
@Fluent
public final class MachineInner extends SubResource {
    /*
     * The Availability zone in which machine is located.
     */
    private List<String> zones;

    /*
     * The properties of the machine
     */
    private MachineProperties properties;

    /*
     * The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    private String name;

    /*
     * Resource type
     */
    private String type;

    /**
     * Creates an instance of MachineInner class.
     */
    public MachineInner() {
    }

    /**
     * Get the zones property: The Availability zone in which machine is located.
     * 
     * @return the zones value.
     */
    public List<String> zones() {
        return this.zones;
    }

    /**
     * Get the properties property: The properties of the machine.
     * 
     * @return the properties value.
     */
    public MachineProperties properties() {
        return this.properties;
    }

    /**
     * Get the name property: The name of the resource that is unique within a resource group. This name can be used to
     * access the resource.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: Resource type.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MachineInner withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (properties() != null) {
            properties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MachineInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MachineInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the MachineInner.
     */
    public static MachineInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MachineInner deserializedMachineInner = new MachineInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMachineInner.withId(reader.getString());
                } else if ("zones".equals(fieldName)) {
                    List<String> zones = reader.readArray(reader1 -> reader1.getString());
                    deserializedMachineInner.zones = zones;
                } else if ("properties".equals(fieldName)) {
                    deserializedMachineInner.properties = MachineProperties.fromJson(reader);
                } else if ("name".equals(fieldName)) {
                    deserializedMachineInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedMachineInner.type = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMachineInner;
        });
    }
}
