// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerservice.models.CredentialResult;
import java.io.IOException;
import java.util.List;

/**
 * The list credential result response.
 */
@Immutable
public final class CredentialResultsInner implements JsonSerializable<CredentialResultsInner> {
    /*
     * Base64-encoded Kubernetes configuration file.
     */
    private List<CredentialResult> kubeconfigs;

    /**
     * Creates an instance of CredentialResultsInner class.
     */
    public CredentialResultsInner() {
    }

    /**
     * Get the kubeconfigs property: Base64-encoded Kubernetes configuration file.
     * 
     * @return the kubeconfigs value.
     */
    public List<CredentialResult> kubeconfigs() {
        return this.kubeconfigs;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (kubeconfigs() != null) {
            kubeconfigs().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CredentialResultsInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CredentialResultsInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the CredentialResultsInner.
     */
    public static CredentialResultsInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CredentialResultsInner deserializedCredentialResultsInner = new CredentialResultsInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("kubeconfigs".equals(fieldName)) {
                    List<CredentialResult> kubeconfigs
                        = reader.readArray(reader1 -> CredentialResult.fromJson(reader1));
                    deserializedCredentialResultsInner.kubeconfigs = kubeconfigs;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCredentialResultsInner;
        });
    }
}
