/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservice.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerservice.models.MaintenanceWindow;
import com.azure.resourcemanager.containerservice.models.TimeInWeek;
import com.azure.resourcemanager.containerservice.models.TimeSpan;
import java.io.IOException;
import java.util.List;

public final class MaintenanceConfigurationProperties
implements JsonSerializable<MaintenanceConfigurationProperties> {
    private List<TimeInWeek> timeInWeek;
    private List<TimeSpan> notAllowedTime;
    private MaintenanceWindow maintenanceWindow;

    public List<TimeInWeek> timeInWeek() {
        return this.timeInWeek;
    }

    public MaintenanceConfigurationProperties withTimeInWeek(List<TimeInWeek> timeInWeek) {
        this.timeInWeek = timeInWeek;
        return this;
    }

    public List<TimeSpan> notAllowedTime() {
        return this.notAllowedTime;
    }

    public MaintenanceConfigurationProperties withNotAllowedTime(List<TimeSpan> notAllowedTime) {
        this.notAllowedTime = notAllowedTime;
        return this;
    }

    public MaintenanceWindow maintenanceWindow() {
        return this.maintenanceWindow;
    }

    public MaintenanceConfigurationProperties withMaintenanceWindow(MaintenanceWindow maintenanceWindow) {
        this.maintenanceWindow = maintenanceWindow;
        return this;
    }

    public void validate() {
        if (this.timeInWeek() != null) {
            this.timeInWeek().forEach(e -> e.validate());
        }
        if (this.notAllowedTime() != null) {
            this.notAllowedTime().forEach(e -> e.validate());
        }
        if (this.maintenanceWindow() != null) {
            this.maintenanceWindow().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("timeInWeek", this.timeInWeek, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("notAllowedTime", this.notAllowedTime, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("maintenanceWindow", (JsonSerializable)this.maintenanceWindow);
        return jsonWriter.writeEndObject();
    }

    public static MaintenanceConfigurationProperties fromJson(JsonReader jsonReader) throws IOException {
        return (MaintenanceConfigurationProperties)jsonReader.readObject(reader -> {
            MaintenanceConfigurationProperties deserializedMaintenanceConfigurationProperties = new MaintenanceConfigurationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("timeInWeek".equals(fieldName)) {
                    List timeInWeek;
                    deserializedMaintenanceConfigurationProperties.timeInWeek = timeInWeek = reader.readArray(reader1 -> TimeInWeek.fromJson(reader1));
                    continue;
                }
                if ("notAllowedTime".equals(fieldName)) {
                    List notAllowedTime;
                    deserializedMaintenanceConfigurationProperties.notAllowedTime = notAllowedTime = reader.readArray(reader1 -> TimeSpan.fromJson(reader1));
                    continue;
                }
                if ("maintenanceWindow".equals(fieldName)) {
                    deserializedMaintenanceConfigurationProperties.maintenanceWindow = MaintenanceWindow.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMaintenanceConfigurationProperties;
        });
    }
}

