// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Pod IP Allocation Mode
 * 
 * The IP allocation mode for pods in the agent pool. Must be used with podSubnetId. The default is 'DynamicIndividual'.
 */
public final class PodIpAllocationMode extends ExpandableStringEnum<PodIpAllocationMode> {
    /**
     * Static value DynamicIndividual for PodIpAllocationMode.
     */
    public static final PodIpAllocationMode DYNAMIC_INDIVIDUAL = fromString("DynamicIndividual");

    /**
     * Static value StaticBlock for PodIpAllocationMode.
     */
    public static final PodIpAllocationMode STATIC_BLOCK = fromString("StaticBlock");

    /**
     * Creates a new instance of PodIpAllocationMode value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public PodIpAllocationMode() {
    }

    /**
     * Creates or finds a PodIpAllocationMode from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding PodIpAllocationMode.
     */
    public static PodIpAllocationMode fromString(String name) {
        return fromString(name, PodIpAllocationMode.class);
    }

    /**
     * Gets known PodIpAllocationMode values.
     * 
     * @return known PodIpAllocationMode values.
     */
    public static Collection<PodIpAllocationMode> values() {
        return values(PodIpAllocationMode.class);
    }
}
