// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Whether to install GPU drivers. When it's not specified, default is Install.
 */
public final class GpuDriver extends ExpandableStringEnum<GpuDriver> {
    /**
     * Static value Install for GpuDriver.
     */
    public static final GpuDriver INSTALL = fromString("Install");

    /**
     * Static value None for GpuDriver.
     */
    public static final GpuDriver NONE = fromString("None");

    /**
     * Creates a new instance of GpuDriver value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public GpuDriver() {
    }

    /**
     * Creates or finds a GpuDriver from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding GpuDriver.
     */
    public static GpuDriver fromString(String name) {
        return fromString(name, GpuDriver.class);
    }

    /**
     * Gets known GpuDriver values.
     * 
     * @return known GpuDriver values.
     */
    public static Collection<GpuDriver> values() {
        return values(GpuDriver.class);
    }
}
