// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Contains information about SSH certificate public key data.
 */
@Fluent
public final class ContainerServiceSshPublicKey implements JsonSerializable<ContainerServiceSshPublicKey> {
    /*
     * Certificate public key used to authenticate with VMs through SSH. The certificate must be in PEM format with or
     * without headers.
     */
    private String keyData;

    /**
     * Creates an instance of ContainerServiceSshPublicKey class.
     */
    public ContainerServiceSshPublicKey() {
    }

    /**
     * Get the keyData property: Certificate public key used to authenticate with VMs through SSH. The certificate must
     * be in PEM format with or without headers.
     * 
     * @return the keyData value.
     */
    public String keyData() {
        return this.keyData;
    }

    /**
     * Set the keyData property: Certificate public key used to authenticate with VMs through SSH. The certificate must
     * be in PEM format with or without headers.
     * 
     * @param keyData the keyData value to set.
     * @return the ContainerServiceSshPublicKey object itself.
     */
    public ContainerServiceSshPublicKey withKeyData(String keyData) {
        this.keyData = keyData;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (keyData() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property keyData in model ContainerServiceSshPublicKey"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ContainerServiceSshPublicKey.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("keyData", this.keyData);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ContainerServiceSshPublicKey from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ContainerServiceSshPublicKey if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ContainerServiceSshPublicKey.
     */
    public static ContainerServiceSshPublicKey fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ContainerServiceSshPublicKey deserializedContainerServiceSshPublicKey = new ContainerServiceSshPublicKey();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("keyData".equals(fieldName)) {
                    deserializedContainerServiceSshPublicKey.keyData = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedContainerServiceSshPublicKey;
        });
    }
}
