// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * For schedules like: 'recur every month on the 15th' or 'recur every 3 months on the 20th'.
 */
@Fluent
public final class AbsoluteMonthlySchedule implements JsonSerializable<AbsoluteMonthlySchedule> {
    /*
     * Specifies the number of months between each set of occurrences.
     */
    private int intervalMonths;

    /*
     * The date of the month.
     */
    private int dayOfMonth;

    /**
     * Creates an instance of AbsoluteMonthlySchedule class.
     */
    public AbsoluteMonthlySchedule() {
    }

    /**
     * Get the intervalMonths property: Specifies the number of months between each set of occurrences.
     * 
     * @return the intervalMonths value.
     */
    public int intervalMonths() {
        return this.intervalMonths;
    }

    /**
     * Set the intervalMonths property: Specifies the number of months between each set of occurrences.
     * 
     * @param intervalMonths the intervalMonths value to set.
     * @return the AbsoluteMonthlySchedule object itself.
     */
    public AbsoluteMonthlySchedule withIntervalMonths(int intervalMonths) {
        this.intervalMonths = intervalMonths;
        return this;
    }

    /**
     * Get the dayOfMonth property: The date of the month.
     * 
     * @return the dayOfMonth value.
     */
    public int dayOfMonth() {
        return this.dayOfMonth;
    }

    /**
     * Set the dayOfMonth property: The date of the month.
     * 
     * @param dayOfMonth the dayOfMonth value to set.
     * @return the AbsoluteMonthlySchedule object itself.
     */
    public AbsoluteMonthlySchedule withDayOfMonth(int dayOfMonth) {
        this.dayOfMonth = dayOfMonth;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("intervalMonths", this.intervalMonths);
        jsonWriter.writeIntField("dayOfMonth", this.dayOfMonth);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AbsoluteMonthlySchedule from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AbsoluteMonthlySchedule if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AbsoluteMonthlySchedule.
     */
    public static AbsoluteMonthlySchedule fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AbsoluteMonthlySchedule deserializedAbsoluteMonthlySchedule = new AbsoluteMonthlySchedule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("intervalMonths".equals(fieldName)) {
                    deserializedAbsoluteMonthlySchedule.intervalMonths = reader.getInt();
                } else if ("dayOfMonth".equals(fieldName)) {
                    deserializedAbsoluteMonthlySchedule.dayOfMonth = reader.getInt();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAbsoluteMonthlySchedule;
        });
    }
}
