// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerservice.models.AgentPoolGatewayProfile;
import com.azure.resourcemanager.containerservice.models.AgentPoolMode;
import com.azure.resourcemanager.containerservice.models.AgentPoolNetworkProfile;
import com.azure.resourcemanager.containerservice.models.AgentPoolSecurityProfile;
import com.azure.resourcemanager.containerservice.models.AgentPoolStatus;
import com.azure.resourcemanager.containerservice.models.AgentPoolType;
import com.azure.resourcemanager.containerservice.models.AgentPoolUpgradeSettings;
import com.azure.resourcemanager.containerservice.models.AgentPoolWindowsProfile;
import com.azure.resourcemanager.containerservice.models.CreationData;
import com.azure.resourcemanager.containerservice.models.GpuInstanceProfile;
import com.azure.resourcemanager.containerservice.models.GpuProfile;
import com.azure.resourcemanager.containerservice.models.KubeletConfig;
import com.azure.resourcemanager.containerservice.models.KubeletDiskType;
import com.azure.resourcemanager.containerservice.models.LinuxOSConfig;
import com.azure.resourcemanager.containerservice.models.OSDiskType;
import com.azure.resourcemanager.containerservice.models.OSSku;
import com.azure.resourcemanager.containerservice.models.OSType;
import com.azure.resourcemanager.containerservice.models.PodIpAllocationMode;
import com.azure.resourcemanager.containerservice.models.PowerState;
import com.azure.resourcemanager.containerservice.models.ScaleDownMode;
import com.azure.resourcemanager.containerservice.models.ScaleSetEvictionPolicy;
import com.azure.resourcemanager.containerservice.models.ScaleSetPriority;
import com.azure.resourcemanager.containerservice.models.VirtualMachineNodes;
import com.azure.resourcemanager.containerservice.models.VirtualMachinesProfile;
import com.azure.resourcemanager.containerservice.models.WorkloadRuntime;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * Properties for the container service agent pool profile.
 */
@Fluent
public class ManagedClusterAgentPoolProfileProperties
    implements JsonSerializable<ManagedClusterAgentPoolProfileProperties> {
    /*
     * Unique read-only string used to implement optimistic concurrency. The eTag value will change when the resource is
     * updated. Specify an if-match or if-none-match header with the eTag value for a subsequent request to enable
     * optimistic concurrency per the normal etag convention.
     */
    private String etag;

    /*
     * Number of agents (VMs) to host docker containers. Allowed values must be in the range of 0 to 1000 (inclusive)
     * for user pools and in the range of 1 to 1000 (inclusive) for system pools. The default value is 1.
     */
    private Integer count;

    /*
     * VM size availability varies by region. If a node contains insufficient compute resources (memory, cpu, etc) pods
     * might fail to run correctly. For more details on restricted VM sizes, see:
     * https://docs.microsoft.com/azure/aks/quotas-skus-regions
     */
    private String vmSize;

    /*
     * OS Disk Size in GB to be used to specify the disk size for every machine in the master/agent pool. If you specify
     * 0, it will apply the default osDisk size according to the vmSize specified.
     */
    private Integer osDiskSizeGB;

    /*
     * The default is 'Ephemeral' if the VM supports it and has a cache disk larger than the requested OSDiskSizeGB.
     * Otherwise, defaults to 'Managed'. May not be changed after creation. For more information see [Ephemeral
     * OS](https://docs.microsoft.com/azure/aks/cluster-configuration#ephemeral-os).
     */
    private OSDiskType osDiskType;

    /*
     * Determines the placement of emptyDir volumes, container runtime data root, and Kubelet ephemeral storage.
     */
    private KubeletDiskType kubeletDiskType;

    /*
     * Determines the type of workload a node can run.
     */
    private WorkloadRuntime workloadRuntime;

    /*
     * A base64-encoded string which will be written to /etc/motd after decoding. This allows customization of the
     * message of the day for Linux nodes. It must not be specified for Windows nodes. It must be a static string (i.e.,
     * will be printed raw and not be executed as a script).
     */
    private String messageOfTheDay;

    /*
     * If this is not specified, a VNET and subnet will be generated and used. If no podSubnetID is specified, this
     * applies to nodes and pods, otherwise it applies to just nodes. This is of the form:
     * /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{
     * virtualNetworkName}/subnets/{subnetName}
     */
    private String vnetSubnetId;

    /*
     * If omitted, pod IPs are statically assigned on the node subnet (see vnetSubnetID for more details). This is of
     * the form:
     * /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{
     * virtualNetworkName}/subnets/{subnetName}
     */
    private String podSubnetId;

    /*
     * The IP allocation mode for pods in the agent pool. Must be used with podSubnetId. The default is
     * 'DynamicIndividual'.
     */
    private PodIpAllocationMode podIpAllocationMode;

    /*
     * The maximum number of pods that can run on a node.
     */
    private Integer maxPods;

    /*
     * OsType to be used to specify os type. Choose from Linux and Windows. Default to Linux.
     */
    private OSType osType;

    /*
     * Specifies the OS SKU used by the agent pool. The default is Ubuntu if OSType is Linux. The default is Windows2019
     * when Kubernetes <= 1.24 or Windows2022 when Kubernetes >= 1.25 if OSType is Windows.
     */
    private OSSku osSku;

    /*
     * The maximum number of nodes for auto-scaling
     */
    private Integer maxCount;

    /*
     * The minimum number of nodes for auto-scaling
     */
    private Integer minCount;

    /*
     * Whether to enable auto-scaler
     */
    private Boolean enableAutoScaling;

    /*
     * This also effects the cluster autoscaler behavior. If not specified, it defaults to Delete.
     */
    private ScaleDownMode scaleDownMode;

    /*
     * The type of Agent Pool.
     */
    private AgentPoolType type;

    /*
     * A cluster must have at least one 'System' Agent Pool at all times. For additional information on agent pool
     * restrictions and best practices, see: https://docs.microsoft.com/azure/aks/use-system-pools
     */
    private AgentPoolMode mode;

    /*
     * Both patch version <major.minor.patch> (e.g. 1.20.13) and <major.minor> (e.g. 1.20) are supported. When
     * <major.minor> is specified, the latest supported GA patch version is chosen automatically. Updating the cluster
     * with the same <major.minor> once it has been created (e.g. 1.14.x -> 1.14) will not trigger an upgrade, even if a
     * newer patch version is available. As a best practice, you should upgrade all node pools in an AKS cluster to the
     * same Kubernetes version. The node pool version must have the same major version as the control plane. The node
     * pool minor version must be within two minor versions of the control plane version. The node pool version cannot
     * be greater than the control plane version. For more information see [upgrading a node
     * pool](https://docs.microsoft.com/azure/aks/use-multiple-node-pools#upgrade-a-node-pool).
     */
    private String orchestratorVersion;

    /*
     * If orchestratorVersion is a fully specified version <major.minor.patch>, this field will be exactly equal to it.
     * If orchestratorVersion is <major.minor>, this field will contain the full <major.minor.patch> version being used.
     */
    private String currentOrchestratorVersion;

    /*
     * The version of node image
     */
    private String nodeImageVersion;

    /*
     * Settings for upgrading the agentpool
     */
    private AgentPoolUpgradeSettings upgradeSettings;

    /*
     * The current deployment or provisioning state.
     */
    private String provisioningState;

    /*
     * When an Agent Pool is first created it is initially Running. The Agent Pool can be stopped by setting this field
     * to Stopped. A stopped Agent Pool stops all of its VMs and does not accrue billing charges. An Agent Pool can only
     * be stopped if it is Running and provisioning state is Succeeded
     */
    private PowerState powerState;

    /*
     * The list of Availability zones to use for nodes. This can only be specified if the AgentPoolType property is
     * 'VirtualMachineScaleSets'.
     */
    private List<String> availabilityZones;

    /*
     * Some scenarios may require nodes in a node pool to receive their own dedicated public IP addresses. A common
     * scenario is for gaming workloads, where a console needs to make a direct connection to a cloud virtual machine to
     * minimize hops. For more information see [assigning a public IP per
     * node](https://docs.microsoft.com/azure/aks/use-multiple-node-pools#assign-a-public-ip-per-node-for-your-node-
     * pools). The default is false.
     */
    private Boolean enableNodePublicIp;

    /*
     * This is of the form:
     * /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/publicIPPrefixes/{
     * publicIPPrefixName}
     */
    private String nodePublicIpPrefixId;

    /*
     * The Virtual Machine Scale Set priority. If not specified, the default is 'Regular'.
     */
    private ScaleSetPriority scaleSetPriority;

    /*
     * This cannot be specified unless the scaleSetPriority is 'Spot'. If not specified, the default is 'Delete'.
     */
    private ScaleSetEvictionPolicy scaleSetEvictionPolicy;

    /*
     * Possible values are any decimal value greater than zero or -1 which indicates the willingness to pay any
     * on-demand price. For more details on spot pricing, see [spot VMs
     * pricing](https://docs.microsoft.com/azure/virtual-machines/spot-vms#pricing)
     */
    private Float spotMaxPrice;

    /*
     * The tags to be persisted on the agent pool virtual machine scale set.
     */
    private Map<String, String> tags;

    /*
     * The node labels to be persisted across all nodes in agent pool.
     */
    private Map<String, String> nodeLabels;

    /*
     * The taints added to new nodes during node pool create and scale. For example, key=value:NoSchedule.
     */
    private List<String> nodeTaints;

    /*
     * The ID for Proximity Placement Group.
     */
    private String proximityPlacementGroupId;

    /*
     * The Kubelet configuration on the agent pool nodes.
     */
    private KubeletConfig kubeletConfig;

    /*
     * The OS configuration of Linux agent nodes.
     */
    private LinuxOSConfig linuxOSConfig;

    /*
     * This is only supported on certain VM sizes and in certain Azure regions. For more information, see:
     * https://docs.microsoft.com/azure/aks/enable-host-encryption
     */
    private Boolean enableEncryptionAtHost;

    /*
     * Whether to enable UltraSSD
     */
    private Boolean enableUltraSsd;

    /*
     * See [Add a FIPS-enabled node
     * pool](https://docs.microsoft.com/azure/aks/use-multiple-node-pools#add-a-fips-enabled-node-pool-preview) for more
     * details.
     */
    private Boolean enableFips;

    /*
     * GPUInstanceProfile to be used to specify GPU MIG instance profile for supported GPU VM SKU.
     */
    private GpuInstanceProfile gpuInstanceProfile;

    /*
     * CreationData to be used to specify the source Snapshot ID if the node pool will be created/upgraded using a
     * snapshot.
     */
    private CreationData creationData;

    /*
     * AKS will associate the specified agent pool with the Capacity Reservation Group.
     */
    private String capacityReservationGroupId;

    /*
     * This is of the form:
     * /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/hostGroups/{
     * hostGroupName}. For more information see [Azure dedicated
     * hosts](https://docs.microsoft.com/azure/virtual-machines/dedicated-hosts).
     */
    private String hostGroupId;

    /*
     * Network-related settings of an agent pool.
     */
    private AgentPoolNetworkProfile networkProfile;

    /*
     * The Windows agent pool's specific profile.
     */
    private AgentPoolWindowsProfile windowsProfile;

    /*
     * The security settings of an agent pool.
     */
    private AgentPoolSecurityProfile securityProfile;

    /*
     * GPU settings for the Agent Pool.
     */
    private GpuProfile gpuProfile;

    /*
     * Profile specific to a managed agent pool in Gateway mode. This field cannot be set if agent pool mode is not
     * Gateway.
     */
    private AgentPoolGatewayProfile gatewayProfile;

    /*
     * Specifications on VirtualMachines agent pool.
     */
    private VirtualMachinesProfile virtualMachinesProfile;

    /*
     * The status of nodes in a VirtualMachines agent pool.
     */
    private List<VirtualMachineNodes> virtualMachineNodesStatus;

    /*
     * Contains read-only information about the Agent Pool.
     */
    private AgentPoolStatus status;

    /**
     * Creates an instance of ManagedClusterAgentPoolProfileProperties class.
     */
    public ManagedClusterAgentPoolProfileProperties() {
    }

    /**
     * Get the etag property: Unique read-only string used to implement optimistic concurrency. The eTag value will
     * change when the resource is updated. Specify an if-match or if-none-match header with the eTag value for a
     * subsequent request to enable optimistic concurrency per the normal etag convention.
     * 
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * Set the etag property: Unique read-only string used to implement optimistic concurrency. The eTag value will
     * change when the resource is updated. Specify an if-match or if-none-match header with the eTag value for a
     * subsequent request to enable optimistic concurrency per the normal etag convention.
     * 
     * @param etag the etag value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    ManagedClusterAgentPoolProfileProperties withEtag(String etag) {
        this.etag = etag;
        return this;
    }

    /**
     * Get the count property: Number of agents (VMs) to host docker containers. Allowed values must be in the range of
     * 0 to 1000 (inclusive) for user pools and in the range of 1 to 1000 (inclusive) for system pools. The default
     * value is 1.
     * 
     * @return the count value.
     */
    public Integer count() {
        return this.count;
    }

    /**
     * Set the count property: Number of agents (VMs) to host docker containers. Allowed values must be in the range of
     * 0 to 1000 (inclusive) for user pools and in the range of 1 to 1000 (inclusive) for system pools. The default
     * value is 1.
     * 
     * @param count the count value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withCount(Integer count) {
        this.count = count;
        return this;
    }

    /**
     * Get the vmSize property: VM size availability varies by region. If a node contains insufficient compute resources
     * (memory, cpu, etc) pods might fail to run correctly. For more details on restricted VM sizes, see:
     * https://docs.microsoft.com/azure/aks/quotas-skus-regions.
     * 
     * @return the vmSize value.
     */
    public String vmSize() {
        return this.vmSize;
    }

    /**
     * Set the vmSize property: VM size availability varies by region. If a node contains insufficient compute resources
     * (memory, cpu, etc) pods might fail to run correctly. For more details on restricted VM sizes, see:
     * https://docs.microsoft.com/azure/aks/quotas-skus-regions.
     * 
     * @param vmSize the vmSize value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withVmSize(String vmSize) {
        this.vmSize = vmSize;
        return this;
    }

    /**
     * Get the osDiskSizeGB property: OS Disk Size in GB to be used to specify the disk size for every machine in the
     * master/agent pool. If you specify 0, it will apply the default osDisk size according to the vmSize specified.
     * 
     * @return the osDiskSizeGB value.
     */
    public Integer osDiskSizeGB() {
        return this.osDiskSizeGB;
    }

    /**
     * Set the osDiskSizeGB property: OS Disk Size in GB to be used to specify the disk size for every machine in the
     * master/agent pool. If you specify 0, it will apply the default osDisk size according to the vmSize specified.
     * 
     * @param osDiskSizeGB the osDiskSizeGB value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withOsDiskSizeGB(Integer osDiskSizeGB) {
        this.osDiskSizeGB = osDiskSizeGB;
        return this;
    }

    /**
     * Get the osDiskType property: The default is 'Ephemeral' if the VM supports it and has a cache disk larger than
     * the requested OSDiskSizeGB. Otherwise, defaults to 'Managed'. May not be changed after creation. For more
     * information see [Ephemeral OS](https://docs.microsoft.com/azure/aks/cluster-configuration#ephemeral-os).
     * 
     * @return the osDiskType value.
     */
    public OSDiskType osDiskType() {
        return this.osDiskType;
    }

    /**
     * Set the osDiskType property: The default is 'Ephemeral' if the VM supports it and has a cache disk larger than
     * the requested OSDiskSizeGB. Otherwise, defaults to 'Managed'. May not be changed after creation. For more
     * information see [Ephemeral OS](https://docs.microsoft.com/azure/aks/cluster-configuration#ephemeral-os).
     * 
     * @param osDiskType the osDiskType value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withOsDiskType(OSDiskType osDiskType) {
        this.osDiskType = osDiskType;
        return this;
    }

    /**
     * Get the kubeletDiskType property: Determines the placement of emptyDir volumes, container runtime data root, and
     * Kubelet ephemeral storage.
     * 
     * @return the kubeletDiskType value.
     */
    public KubeletDiskType kubeletDiskType() {
        return this.kubeletDiskType;
    }

    /**
     * Set the kubeletDiskType property: Determines the placement of emptyDir volumes, container runtime data root, and
     * Kubelet ephemeral storage.
     * 
     * @param kubeletDiskType the kubeletDiskType value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withKubeletDiskType(KubeletDiskType kubeletDiskType) {
        this.kubeletDiskType = kubeletDiskType;
        return this;
    }

    /**
     * Get the workloadRuntime property: Determines the type of workload a node can run.
     * 
     * @return the workloadRuntime value.
     */
    public WorkloadRuntime workloadRuntime() {
        return this.workloadRuntime;
    }

    /**
     * Set the workloadRuntime property: Determines the type of workload a node can run.
     * 
     * @param workloadRuntime the workloadRuntime value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withWorkloadRuntime(WorkloadRuntime workloadRuntime) {
        this.workloadRuntime = workloadRuntime;
        return this;
    }

    /**
     * Get the messageOfTheDay property: A base64-encoded string which will be written to /etc/motd after decoding. This
     * allows customization of the message of the day for Linux nodes. It must not be specified for Windows nodes. It
     * must be a static string (i.e., will be printed raw and not be executed as a script).
     * 
     * @return the messageOfTheDay value.
     */
    public String messageOfTheDay() {
        return this.messageOfTheDay;
    }

    /**
     * Set the messageOfTheDay property: A base64-encoded string which will be written to /etc/motd after decoding. This
     * allows customization of the message of the day for Linux nodes. It must not be specified for Windows nodes. It
     * must be a static string (i.e., will be printed raw and not be executed as a script).
     * 
     * @param messageOfTheDay the messageOfTheDay value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withMessageOfTheDay(String messageOfTheDay) {
        this.messageOfTheDay = messageOfTheDay;
        return this;
    }

    /**
     * Get the vnetSubnetId property: If this is not specified, a VNET and subnet will be generated and used. If no
     * podSubnetID is specified, this applies to nodes and pods, otherwise it applies to just nodes. This is of the
     * form:
     * /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}.
     * 
     * @return the vnetSubnetId value.
     */
    public String vnetSubnetId() {
        return this.vnetSubnetId;
    }

    /**
     * Set the vnetSubnetId property: If this is not specified, a VNET and subnet will be generated and used. If no
     * podSubnetID is specified, this applies to nodes and pods, otherwise it applies to just nodes. This is of the
     * form:
     * /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}.
     * 
     * @param vnetSubnetId the vnetSubnetId value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withVnetSubnetId(String vnetSubnetId) {
        this.vnetSubnetId = vnetSubnetId;
        return this;
    }

    /**
     * Get the podSubnetId property: If omitted, pod IPs are statically assigned on the node subnet (see vnetSubnetID
     * for more details). This is of the form:
     * /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}.
     * 
     * @return the podSubnetId value.
     */
    public String podSubnetId() {
        return this.podSubnetId;
    }

    /**
     * Set the podSubnetId property: If omitted, pod IPs are statically assigned on the node subnet (see vnetSubnetID
     * for more details). This is of the form:
     * /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}.
     * 
     * @param podSubnetId the podSubnetId value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withPodSubnetId(String podSubnetId) {
        this.podSubnetId = podSubnetId;
        return this;
    }

    /**
     * Get the podIpAllocationMode property: The IP allocation mode for pods in the agent pool. Must be used with
     * podSubnetId. The default is 'DynamicIndividual'.
     * 
     * @return the podIpAllocationMode value.
     */
    public PodIpAllocationMode podIpAllocationMode() {
        return this.podIpAllocationMode;
    }

    /**
     * Set the podIpAllocationMode property: The IP allocation mode for pods in the agent pool. Must be used with
     * podSubnetId. The default is 'DynamicIndividual'.
     * 
     * @param podIpAllocationMode the podIpAllocationMode value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withPodIpAllocationMode(PodIpAllocationMode podIpAllocationMode) {
        this.podIpAllocationMode = podIpAllocationMode;
        return this;
    }

    /**
     * Get the maxPods property: The maximum number of pods that can run on a node.
     * 
     * @return the maxPods value.
     */
    public Integer maxPods() {
        return this.maxPods;
    }

    /**
     * Set the maxPods property: The maximum number of pods that can run on a node.
     * 
     * @param maxPods the maxPods value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withMaxPods(Integer maxPods) {
        this.maxPods = maxPods;
        return this;
    }

    /**
     * Get the osType property: OsType to be used to specify os type. Choose from Linux and Windows. Default to Linux.
     * 
     * @return the osType value.
     */
    public OSType osType() {
        return this.osType;
    }

    /**
     * Set the osType property: OsType to be used to specify os type. Choose from Linux and Windows. Default to Linux.
     * 
     * @param osType the osType value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withOsType(OSType osType) {
        this.osType = osType;
        return this;
    }

    /**
     * Get the osSku property: Specifies the OS SKU used by the agent pool. The default is Ubuntu if OSType is Linux.
     * The default is Windows2019 when Kubernetes &lt;= 1.24 or Windows2022 when Kubernetes &gt;= 1.25 if OSType is
     * Windows.
     * 
     * @return the osSku value.
     */
    public OSSku osSku() {
        return this.osSku;
    }

    /**
     * Set the osSku property: Specifies the OS SKU used by the agent pool. The default is Ubuntu if OSType is Linux.
     * The default is Windows2019 when Kubernetes &lt;= 1.24 or Windows2022 when Kubernetes &gt;= 1.25 if OSType is
     * Windows.
     * 
     * @param osSku the osSku value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withOsSku(OSSku osSku) {
        this.osSku = osSku;
        return this;
    }

    /**
     * Get the maxCount property: The maximum number of nodes for auto-scaling.
     * 
     * @return the maxCount value.
     */
    public Integer maxCount() {
        return this.maxCount;
    }

    /**
     * Set the maxCount property: The maximum number of nodes for auto-scaling.
     * 
     * @param maxCount the maxCount value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withMaxCount(Integer maxCount) {
        this.maxCount = maxCount;
        return this;
    }

    /**
     * Get the minCount property: The minimum number of nodes for auto-scaling.
     * 
     * @return the minCount value.
     */
    public Integer minCount() {
        return this.minCount;
    }

    /**
     * Set the minCount property: The minimum number of nodes for auto-scaling.
     * 
     * @param minCount the minCount value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withMinCount(Integer minCount) {
        this.minCount = minCount;
        return this;
    }

    /**
     * Get the enableAutoScaling property: Whether to enable auto-scaler.
     * 
     * @return the enableAutoScaling value.
     */
    public Boolean enableAutoScaling() {
        return this.enableAutoScaling;
    }

    /**
     * Set the enableAutoScaling property: Whether to enable auto-scaler.
     * 
     * @param enableAutoScaling the enableAutoScaling value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withEnableAutoScaling(Boolean enableAutoScaling) {
        this.enableAutoScaling = enableAutoScaling;
        return this;
    }

    /**
     * Get the scaleDownMode property: This also effects the cluster autoscaler behavior. If not specified, it defaults
     * to Delete.
     * 
     * @return the scaleDownMode value.
     */
    public ScaleDownMode scaleDownMode() {
        return this.scaleDownMode;
    }

    /**
     * Set the scaleDownMode property: This also effects the cluster autoscaler behavior. If not specified, it defaults
     * to Delete.
     * 
     * @param scaleDownMode the scaleDownMode value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withScaleDownMode(ScaleDownMode scaleDownMode) {
        this.scaleDownMode = scaleDownMode;
        return this;
    }

    /**
     * Get the type property: The type of Agent Pool.
     * 
     * @return the type value.
     */
    public AgentPoolType type() {
        return this.type;
    }

    /**
     * Set the type property: The type of Agent Pool.
     * 
     * @param type the type value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withType(AgentPoolType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the mode property: A cluster must have at least one 'System' Agent Pool at all times. For additional
     * information on agent pool restrictions and best practices, see:
     * https://docs.microsoft.com/azure/aks/use-system-pools.
     * 
     * @return the mode value.
     */
    public AgentPoolMode mode() {
        return this.mode;
    }

    /**
     * Set the mode property: A cluster must have at least one 'System' Agent Pool at all times. For additional
     * information on agent pool restrictions and best practices, see:
     * https://docs.microsoft.com/azure/aks/use-system-pools.
     * 
     * @param mode the mode value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withMode(AgentPoolMode mode) {
        this.mode = mode;
        return this;
    }

    /**
     * Get the orchestratorVersion property: Both patch version &lt;major.minor.patch&gt; (e.g. 1.20.13) and
     * &lt;major.minor&gt; (e.g. 1.20) are supported. When &lt;major.minor&gt; is specified, the latest supported GA
     * patch version is chosen automatically. Updating the cluster with the same &lt;major.minor&gt; once it has been
     * created (e.g. 1.14.x -&gt; 1.14) will not trigger an upgrade, even if a newer patch version is available. As a
     * best practice, you should upgrade all node pools in an AKS cluster to the same Kubernetes version. The node pool
     * version must have the same major version as the control plane. The node pool minor version must be within two
     * minor versions of the control plane version. The node pool version cannot be greater than the control plane
     * version. For more information see [upgrading a node
     * pool](https://docs.microsoft.com/azure/aks/use-multiple-node-pools#upgrade-a-node-pool).
     * 
     * @return the orchestratorVersion value.
     */
    public String orchestratorVersion() {
        return this.orchestratorVersion;
    }

    /**
     * Set the orchestratorVersion property: Both patch version &lt;major.minor.patch&gt; (e.g. 1.20.13) and
     * &lt;major.minor&gt; (e.g. 1.20) are supported. When &lt;major.minor&gt; is specified, the latest supported GA
     * patch version is chosen automatically. Updating the cluster with the same &lt;major.minor&gt; once it has been
     * created (e.g. 1.14.x -&gt; 1.14) will not trigger an upgrade, even if a newer patch version is available. As a
     * best practice, you should upgrade all node pools in an AKS cluster to the same Kubernetes version. The node pool
     * version must have the same major version as the control plane. The node pool minor version must be within two
     * minor versions of the control plane version. The node pool version cannot be greater than the control plane
     * version. For more information see [upgrading a node
     * pool](https://docs.microsoft.com/azure/aks/use-multiple-node-pools#upgrade-a-node-pool).
     * 
     * @param orchestratorVersion the orchestratorVersion value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withOrchestratorVersion(String orchestratorVersion) {
        this.orchestratorVersion = orchestratorVersion;
        return this;
    }

    /**
     * Get the currentOrchestratorVersion property: If orchestratorVersion is a fully specified version
     * &lt;major.minor.patch&gt;, this field will be exactly equal to it. If orchestratorVersion is &lt;major.minor&gt;,
     * this field will contain the full &lt;major.minor.patch&gt; version being used.
     * 
     * @return the currentOrchestratorVersion value.
     */
    public String currentOrchestratorVersion() {
        return this.currentOrchestratorVersion;
    }

    /**
     * Set the currentOrchestratorVersion property: If orchestratorVersion is a fully specified version
     * &lt;major.minor.patch&gt;, this field will be exactly equal to it. If orchestratorVersion is &lt;major.minor&gt;,
     * this field will contain the full &lt;major.minor.patch&gt; version being used.
     * 
     * @param currentOrchestratorVersion the currentOrchestratorVersion value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    ManagedClusterAgentPoolProfileProperties withCurrentOrchestratorVersion(String currentOrchestratorVersion) {
        this.currentOrchestratorVersion = currentOrchestratorVersion;
        return this;
    }

    /**
     * Get the nodeImageVersion property: The version of node image.
     * 
     * @return the nodeImageVersion value.
     */
    public String nodeImageVersion() {
        return this.nodeImageVersion;
    }

    /**
     * Set the nodeImageVersion property: The version of node image.
     * 
     * @param nodeImageVersion the nodeImageVersion value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    ManagedClusterAgentPoolProfileProperties withNodeImageVersion(String nodeImageVersion) {
        this.nodeImageVersion = nodeImageVersion;
        return this;
    }

    /**
     * Get the upgradeSettings property: Settings for upgrading the agentpool.
     * 
     * @return the upgradeSettings value.
     */
    public AgentPoolUpgradeSettings upgradeSettings() {
        return this.upgradeSettings;
    }

    /**
     * Set the upgradeSettings property: Settings for upgrading the agentpool.
     * 
     * @param upgradeSettings the upgradeSettings value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withUpgradeSettings(AgentPoolUpgradeSettings upgradeSettings) {
        this.upgradeSettings = upgradeSettings;
        return this;
    }

    /**
     * Get the provisioningState property: The current deployment or provisioning state.
     * 
     * @return the provisioningState value.
     */
    public String provisioningState() {
        return this.provisioningState;
    }

    /**
     * Set the provisioningState property: The current deployment or provisioning state.
     * 
     * @param provisioningState the provisioningState value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    ManagedClusterAgentPoolProfileProperties withProvisioningState(String provisioningState) {
        this.provisioningState = provisioningState;
        return this;
    }

    /**
     * Get the powerState property: When an Agent Pool is first created it is initially Running. The Agent Pool can be
     * stopped by setting this field to Stopped. A stopped Agent Pool stops all of its VMs and does not accrue billing
     * charges. An Agent Pool can only be stopped if it is Running and provisioning state is Succeeded.
     * 
     * @return the powerState value.
     */
    public PowerState powerState() {
        return this.powerState;
    }

    /**
     * Set the powerState property: When an Agent Pool is first created it is initially Running. The Agent Pool can be
     * stopped by setting this field to Stopped. A stopped Agent Pool stops all of its VMs and does not accrue billing
     * charges. An Agent Pool can only be stopped if it is Running and provisioning state is Succeeded.
     * 
     * @param powerState the powerState value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withPowerState(PowerState powerState) {
        this.powerState = powerState;
        return this;
    }

    /**
     * Get the availabilityZones property: The list of Availability zones to use for nodes. This can only be specified
     * if the AgentPoolType property is 'VirtualMachineScaleSets'.
     * 
     * @return the availabilityZones value.
     */
    public List<String> availabilityZones() {
        return this.availabilityZones;
    }

    /**
     * Set the availabilityZones property: The list of Availability zones to use for nodes. This can only be specified
     * if the AgentPoolType property is 'VirtualMachineScaleSets'.
     * 
     * @param availabilityZones the availabilityZones value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withAvailabilityZones(List<String> availabilityZones) {
        this.availabilityZones = availabilityZones;
        return this;
    }

    /**
     * Get the enableNodePublicIp property: Some scenarios may require nodes in a node pool to receive their own
     * dedicated public IP addresses. A common scenario is for gaming workloads, where a console needs to make a direct
     * connection to a cloud virtual machine to minimize hops. For more information see [assigning a public IP per
     * node](https://docs.microsoft.com/azure/aks/use-multiple-node-pools#assign-a-public-ip-per-node-for-your-node-pools).
     * The default is false.
     * 
     * @return the enableNodePublicIp value.
     */
    public Boolean enableNodePublicIp() {
        return this.enableNodePublicIp;
    }

    /**
     * Set the enableNodePublicIp property: Some scenarios may require nodes in a node pool to receive their own
     * dedicated public IP addresses. A common scenario is for gaming workloads, where a console needs to make a direct
     * connection to a cloud virtual machine to minimize hops. For more information see [assigning a public IP per
     * node](https://docs.microsoft.com/azure/aks/use-multiple-node-pools#assign-a-public-ip-per-node-for-your-node-pools).
     * The default is false.
     * 
     * @param enableNodePublicIp the enableNodePublicIp value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withEnableNodePublicIp(Boolean enableNodePublicIp) {
        this.enableNodePublicIp = enableNodePublicIp;
        return this;
    }

    /**
     * Get the nodePublicIpPrefixId property: This is of the form:
     * /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/publicIPPrefixes/{publicIPPrefixName}.
     * 
     * @return the nodePublicIpPrefixId value.
     */
    public String nodePublicIpPrefixId() {
        return this.nodePublicIpPrefixId;
    }

    /**
     * Set the nodePublicIpPrefixId property: This is of the form:
     * /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/publicIPPrefixes/{publicIPPrefixName}.
     * 
     * @param nodePublicIpPrefixId the nodePublicIpPrefixId value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withNodePublicIpPrefixId(String nodePublicIpPrefixId) {
        this.nodePublicIpPrefixId = nodePublicIpPrefixId;
        return this;
    }

    /**
     * Get the scaleSetPriority property: The Virtual Machine Scale Set priority. If not specified, the default is
     * 'Regular'.
     * 
     * @return the scaleSetPriority value.
     */
    public ScaleSetPriority scaleSetPriority() {
        return this.scaleSetPriority;
    }

    /**
     * Set the scaleSetPriority property: The Virtual Machine Scale Set priority. If not specified, the default is
     * 'Regular'.
     * 
     * @param scaleSetPriority the scaleSetPriority value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withScaleSetPriority(ScaleSetPriority scaleSetPriority) {
        this.scaleSetPriority = scaleSetPriority;
        return this;
    }

    /**
     * Get the scaleSetEvictionPolicy property: This cannot be specified unless the scaleSetPriority is 'Spot'. If not
     * specified, the default is 'Delete'.
     * 
     * @return the scaleSetEvictionPolicy value.
     */
    public ScaleSetEvictionPolicy scaleSetEvictionPolicy() {
        return this.scaleSetEvictionPolicy;
    }

    /**
     * Set the scaleSetEvictionPolicy property: This cannot be specified unless the scaleSetPriority is 'Spot'. If not
     * specified, the default is 'Delete'.
     * 
     * @param scaleSetEvictionPolicy the scaleSetEvictionPolicy value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties
        withScaleSetEvictionPolicy(ScaleSetEvictionPolicy scaleSetEvictionPolicy) {
        this.scaleSetEvictionPolicy = scaleSetEvictionPolicy;
        return this;
    }

    /**
     * Get the spotMaxPrice property: Possible values are any decimal value greater than zero or -1 which indicates the
     * willingness to pay any on-demand price. For more details on spot pricing, see [spot VMs
     * pricing](https://docs.microsoft.com/azure/virtual-machines/spot-vms#pricing).
     * 
     * @return the spotMaxPrice value.
     */
    public Float spotMaxPrice() {
        return this.spotMaxPrice;
    }

    /**
     * Set the spotMaxPrice property: Possible values are any decimal value greater than zero or -1 which indicates the
     * willingness to pay any on-demand price. For more details on spot pricing, see [spot VMs
     * pricing](https://docs.microsoft.com/azure/virtual-machines/spot-vms#pricing).
     * 
     * @param spotMaxPrice the spotMaxPrice value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withSpotMaxPrice(Float spotMaxPrice) {
        this.spotMaxPrice = spotMaxPrice;
        return this;
    }

    /**
     * Get the tags property: The tags to be persisted on the agent pool virtual machine scale set.
     * 
     * @return the tags value.
     */
    public Map<String, String> tags() {
        return this.tags;
    }

    /**
     * Set the tags property: The tags to be persisted on the agent pool virtual machine scale set.
     * 
     * @param tags the tags value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the nodeLabels property: The node labels to be persisted across all nodes in agent pool.
     * 
     * @return the nodeLabels value.
     */
    public Map<String, String> nodeLabels() {
        return this.nodeLabels;
    }

    /**
     * Set the nodeLabels property: The node labels to be persisted across all nodes in agent pool.
     * 
     * @param nodeLabels the nodeLabels value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withNodeLabels(Map<String, String> nodeLabels) {
        this.nodeLabels = nodeLabels;
        return this;
    }

    /**
     * Get the nodeTaints property: The taints added to new nodes during node pool create and scale. For example,
     * key=value:NoSchedule.
     * 
     * @return the nodeTaints value.
     */
    public List<String> nodeTaints() {
        return this.nodeTaints;
    }

    /**
     * Set the nodeTaints property: The taints added to new nodes during node pool create and scale. For example,
     * key=value:NoSchedule.
     * 
     * @param nodeTaints the nodeTaints value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withNodeTaints(List<String> nodeTaints) {
        this.nodeTaints = nodeTaints;
        return this;
    }

    /**
     * Get the proximityPlacementGroupId property: The ID for Proximity Placement Group.
     * 
     * @return the proximityPlacementGroupId value.
     */
    public String proximityPlacementGroupId() {
        return this.proximityPlacementGroupId;
    }

    /**
     * Set the proximityPlacementGroupId property: The ID for Proximity Placement Group.
     * 
     * @param proximityPlacementGroupId the proximityPlacementGroupId value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withProximityPlacementGroupId(String proximityPlacementGroupId) {
        this.proximityPlacementGroupId = proximityPlacementGroupId;
        return this;
    }

    /**
     * Get the kubeletConfig property: The Kubelet configuration on the agent pool nodes.
     * 
     * @return the kubeletConfig value.
     */
    public KubeletConfig kubeletConfig() {
        return this.kubeletConfig;
    }

    /**
     * Set the kubeletConfig property: The Kubelet configuration on the agent pool nodes.
     * 
     * @param kubeletConfig the kubeletConfig value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withKubeletConfig(KubeletConfig kubeletConfig) {
        this.kubeletConfig = kubeletConfig;
        return this;
    }

    /**
     * Get the linuxOSConfig property: The OS configuration of Linux agent nodes.
     * 
     * @return the linuxOSConfig value.
     */
    public LinuxOSConfig linuxOSConfig() {
        return this.linuxOSConfig;
    }

    /**
     * Set the linuxOSConfig property: The OS configuration of Linux agent nodes.
     * 
     * @param linuxOSConfig the linuxOSConfig value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withLinuxOSConfig(LinuxOSConfig linuxOSConfig) {
        this.linuxOSConfig = linuxOSConfig;
        return this;
    }

    /**
     * Get the enableEncryptionAtHost property: This is only supported on certain VM sizes and in certain Azure regions.
     * For more information, see: https://docs.microsoft.com/azure/aks/enable-host-encryption.
     * 
     * @return the enableEncryptionAtHost value.
     */
    public Boolean enableEncryptionAtHost() {
        return this.enableEncryptionAtHost;
    }

    /**
     * Set the enableEncryptionAtHost property: This is only supported on certain VM sizes and in certain Azure regions.
     * For more information, see: https://docs.microsoft.com/azure/aks/enable-host-encryption.
     * 
     * @param enableEncryptionAtHost the enableEncryptionAtHost value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withEnableEncryptionAtHost(Boolean enableEncryptionAtHost) {
        this.enableEncryptionAtHost = enableEncryptionAtHost;
        return this;
    }

    /**
     * Get the enableUltraSsd property: Whether to enable UltraSSD.
     * 
     * @return the enableUltraSsd value.
     */
    public Boolean enableUltraSsd() {
        return this.enableUltraSsd;
    }

    /**
     * Set the enableUltraSsd property: Whether to enable UltraSSD.
     * 
     * @param enableUltraSsd the enableUltraSsd value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withEnableUltraSsd(Boolean enableUltraSsd) {
        this.enableUltraSsd = enableUltraSsd;
        return this;
    }

    /**
     * Get the enableFips property: See [Add a FIPS-enabled node
     * pool](https://docs.microsoft.com/azure/aks/use-multiple-node-pools#add-a-fips-enabled-node-pool-preview) for more
     * details.
     * 
     * @return the enableFips value.
     */
    public Boolean enableFips() {
        return this.enableFips;
    }

    /**
     * Set the enableFips property: See [Add a FIPS-enabled node
     * pool](https://docs.microsoft.com/azure/aks/use-multiple-node-pools#add-a-fips-enabled-node-pool-preview) for more
     * details.
     * 
     * @param enableFips the enableFips value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withEnableFips(Boolean enableFips) {
        this.enableFips = enableFips;
        return this;
    }

    /**
     * Get the gpuInstanceProfile property: GPUInstanceProfile to be used to specify GPU MIG instance profile for
     * supported GPU VM SKU.
     * 
     * @return the gpuInstanceProfile value.
     */
    public GpuInstanceProfile gpuInstanceProfile() {
        return this.gpuInstanceProfile;
    }

    /**
     * Set the gpuInstanceProfile property: GPUInstanceProfile to be used to specify GPU MIG instance profile for
     * supported GPU VM SKU.
     * 
     * @param gpuInstanceProfile the gpuInstanceProfile value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withGpuInstanceProfile(GpuInstanceProfile gpuInstanceProfile) {
        this.gpuInstanceProfile = gpuInstanceProfile;
        return this;
    }

    /**
     * Get the creationData property: CreationData to be used to specify the source Snapshot ID if the node pool will be
     * created/upgraded using a snapshot.
     * 
     * @return the creationData value.
     */
    public CreationData creationData() {
        return this.creationData;
    }

    /**
     * Set the creationData property: CreationData to be used to specify the source Snapshot ID if the node pool will be
     * created/upgraded using a snapshot.
     * 
     * @param creationData the creationData value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withCreationData(CreationData creationData) {
        this.creationData = creationData;
        return this;
    }

    /**
     * Get the capacityReservationGroupId property: AKS will associate the specified agent pool with the Capacity
     * Reservation Group.
     * 
     * @return the capacityReservationGroupId value.
     */
    public String capacityReservationGroupId() {
        return this.capacityReservationGroupId;
    }

    /**
     * Set the capacityReservationGroupId property: AKS will associate the specified agent pool with the Capacity
     * Reservation Group.
     * 
     * @param capacityReservationGroupId the capacityReservationGroupId value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withCapacityReservationGroupId(String capacityReservationGroupId) {
        this.capacityReservationGroupId = capacityReservationGroupId;
        return this;
    }

    /**
     * Get the hostGroupId property: This is of the form:
     * /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/hostGroups/{hostGroupName}.
     * For more information see [Azure dedicated
     * hosts](https://docs.microsoft.com/azure/virtual-machines/dedicated-hosts).
     * 
     * @return the hostGroupId value.
     */
    public String hostGroupId() {
        return this.hostGroupId;
    }

    /**
     * Set the hostGroupId property: This is of the form:
     * /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/hostGroups/{hostGroupName}.
     * For more information see [Azure dedicated
     * hosts](https://docs.microsoft.com/azure/virtual-machines/dedicated-hosts).
     * 
     * @param hostGroupId the hostGroupId value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withHostGroupId(String hostGroupId) {
        this.hostGroupId = hostGroupId;
        return this;
    }

    /**
     * Get the networkProfile property: Network-related settings of an agent pool.
     * 
     * @return the networkProfile value.
     */
    public AgentPoolNetworkProfile networkProfile() {
        return this.networkProfile;
    }

    /**
     * Set the networkProfile property: Network-related settings of an agent pool.
     * 
     * @param networkProfile the networkProfile value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withNetworkProfile(AgentPoolNetworkProfile networkProfile) {
        this.networkProfile = networkProfile;
        return this;
    }

    /**
     * Get the windowsProfile property: The Windows agent pool's specific profile.
     * 
     * @return the windowsProfile value.
     */
    public AgentPoolWindowsProfile windowsProfile() {
        return this.windowsProfile;
    }

    /**
     * Set the windowsProfile property: The Windows agent pool's specific profile.
     * 
     * @param windowsProfile the windowsProfile value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withWindowsProfile(AgentPoolWindowsProfile windowsProfile) {
        this.windowsProfile = windowsProfile;
        return this;
    }

    /**
     * Get the securityProfile property: The security settings of an agent pool.
     * 
     * @return the securityProfile value.
     */
    public AgentPoolSecurityProfile securityProfile() {
        return this.securityProfile;
    }

    /**
     * Set the securityProfile property: The security settings of an agent pool.
     * 
     * @param securityProfile the securityProfile value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withSecurityProfile(AgentPoolSecurityProfile securityProfile) {
        this.securityProfile = securityProfile;
        return this;
    }

    /**
     * Get the gpuProfile property: GPU settings for the Agent Pool.
     * 
     * @return the gpuProfile value.
     */
    public GpuProfile gpuProfile() {
        return this.gpuProfile;
    }

    /**
     * Set the gpuProfile property: GPU settings for the Agent Pool.
     * 
     * @param gpuProfile the gpuProfile value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withGpuProfile(GpuProfile gpuProfile) {
        this.gpuProfile = gpuProfile;
        return this;
    }

    /**
     * Get the gatewayProfile property: Profile specific to a managed agent pool in Gateway mode. This field cannot be
     * set if agent pool mode is not Gateway.
     * 
     * @return the gatewayProfile value.
     */
    public AgentPoolGatewayProfile gatewayProfile() {
        return this.gatewayProfile;
    }

    /**
     * Set the gatewayProfile property: Profile specific to a managed agent pool in Gateway mode. This field cannot be
     * set if agent pool mode is not Gateway.
     * 
     * @param gatewayProfile the gatewayProfile value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withGatewayProfile(AgentPoolGatewayProfile gatewayProfile) {
        this.gatewayProfile = gatewayProfile;
        return this;
    }

    /**
     * Get the virtualMachinesProfile property: Specifications on VirtualMachines agent pool.
     * 
     * @return the virtualMachinesProfile value.
     */
    public VirtualMachinesProfile virtualMachinesProfile() {
        return this.virtualMachinesProfile;
    }

    /**
     * Set the virtualMachinesProfile property: Specifications on VirtualMachines agent pool.
     * 
     * @param virtualMachinesProfile the virtualMachinesProfile value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties
        withVirtualMachinesProfile(VirtualMachinesProfile virtualMachinesProfile) {
        this.virtualMachinesProfile = virtualMachinesProfile;
        return this;
    }

    /**
     * Get the virtualMachineNodesStatus property: The status of nodes in a VirtualMachines agent pool.
     * 
     * @return the virtualMachineNodesStatus value.
     */
    public List<VirtualMachineNodes> virtualMachineNodesStatus() {
        return this.virtualMachineNodesStatus;
    }

    /**
     * Set the virtualMachineNodesStatus property: The status of nodes in a VirtualMachines agent pool.
     * 
     * @param virtualMachineNodesStatus the virtualMachineNodesStatus value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties
        withVirtualMachineNodesStatus(List<VirtualMachineNodes> virtualMachineNodesStatus) {
        this.virtualMachineNodesStatus = virtualMachineNodesStatus;
        return this;
    }

    /**
     * Get the status property: Contains read-only information about the Agent Pool.
     * 
     * @return the status value.
     */
    public AgentPoolStatus status() {
        return this.status;
    }

    /**
     * Set the status property: Contains read-only information about the Agent Pool.
     * 
     * @param status the status value to set.
     * @return the ManagedClusterAgentPoolProfileProperties object itself.
     */
    public ManagedClusterAgentPoolProfileProperties withStatus(AgentPoolStatus status) {
        this.status = status;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (upgradeSettings() != null) {
            upgradeSettings().validate();
        }
        if (powerState() != null) {
            powerState().validate();
        }
        if (kubeletConfig() != null) {
            kubeletConfig().validate();
        }
        if (linuxOSConfig() != null) {
            linuxOSConfig().validate();
        }
        if (creationData() != null) {
            creationData().validate();
        }
        if (networkProfile() != null) {
            networkProfile().validate();
        }
        if (windowsProfile() != null) {
            windowsProfile().validate();
        }
        if (securityProfile() != null) {
            securityProfile().validate();
        }
        if (gpuProfile() != null) {
            gpuProfile().validate();
        }
        if (gatewayProfile() != null) {
            gatewayProfile().validate();
        }
        if (virtualMachinesProfile() != null) {
            virtualMachinesProfile().validate();
        }
        if (virtualMachineNodesStatus() != null) {
            virtualMachineNodesStatus().forEach(e -> e.validate());
        }
        if (status() != null) {
            status().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("count", this.count);
        jsonWriter.writeStringField("vmSize", this.vmSize);
        jsonWriter.writeNumberField("osDiskSizeGB", this.osDiskSizeGB);
        jsonWriter.writeStringField("osDiskType", this.osDiskType == null ? null : this.osDiskType.toString());
        jsonWriter.writeStringField("kubeletDiskType",
            this.kubeletDiskType == null ? null : this.kubeletDiskType.toString());
        jsonWriter.writeStringField("workloadRuntime",
            this.workloadRuntime == null ? null : this.workloadRuntime.toString());
        jsonWriter.writeStringField("messageOfTheDay", this.messageOfTheDay);
        jsonWriter.writeStringField("vnetSubnetID", this.vnetSubnetId);
        jsonWriter.writeStringField("podSubnetID", this.podSubnetId);
        jsonWriter.writeStringField("podIPAllocationMode",
            this.podIpAllocationMode == null ? null : this.podIpAllocationMode.toString());
        jsonWriter.writeNumberField("maxPods", this.maxPods);
        jsonWriter.writeStringField("osType", this.osType == null ? null : this.osType.toString());
        jsonWriter.writeStringField("osSKU", this.osSku == null ? null : this.osSku.toString());
        jsonWriter.writeNumberField("maxCount", this.maxCount);
        jsonWriter.writeNumberField("minCount", this.minCount);
        jsonWriter.writeBooleanField("enableAutoScaling", this.enableAutoScaling);
        jsonWriter.writeStringField("scaleDownMode", this.scaleDownMode == null ? null : this.scaleDownMode.toString());
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("mode", this.mode == null ? null : this.mode.toString());
        jsonWriter.writeStringField("orchestratorVersion", this.orchestratorVersion);
        jsonWriter.writeJsonField("upgradeSettings", this.upgradeSettings);
        jsonWriter.writeJsonField("powerState", this.powerState);
        jsonWriter.writeArrayField("availabilityZones", this.availabilityZones,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("enableNodePublicIP", this.enableNodePublicIp);
        jsonWriter.writeStringField("nodePublicIPPrefixID", this.nodePublicIpPrefixId);
        jsonWriter.writeStringField("scaleSetPriority",
            this.scaleSetPriority == null ? null : this.scaleSetPriority.toString());
        jsonWriter.writeStringField("scaleSetEvictionPolicy",
            this.scaleSetEvictionPolicy == null ? null : this.scaleSetEvictionPolicy.toString());
        jsonWriter.writeNumberField("spotMaxPrice", this.spotMaxPrice);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeMapField("nodeLabels", this.nodeLabels, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("nodeTaints", this.nodeTaints, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("proximityPlacementGroupID", this.proximityPlacementGroupId);
        jsonWriter.writeJsonField("kubeletConfig", this.kubeletConfig);
        jsonWriter.writeJsonField("linuxOSConfig", this.linuxOSConfig);
        jsonWriter.writeBooleanField("enableEncryptionAtHost", this.enableEncryptionAtHost);
        jsonWriter.writeBooleanField("enableUltraSSD", this.enableUltraSsd);
        jsonWriter.writeBooleanField("enableFIPS", this.enableFips);
        jsonWriter.writeStringField("gpuInstanceProfile",
            this.gpuInstanceProfile == null ? null : this.gpuInstanceProfile.toString());
        jsonWriter.writeJsonField("creationData", this.creationData);
        jsonWriter.writeStringField("capacityReservationGroupID", this.capacityReservationGroupId);
        jsonWriter.writeStringField("hostGroupID", this.hostGroupId);
        jsonWriter.writeJsonField("networkProfile", this.networkProfile);
        jsonWriter.writeJsonField("windowsProfile", this.windowsProfile);
        jsonWriter.writeJsonField("securityProfile", this.securityProfile);
        jsonWriter.writeJsonField("gpuProfile", this.gpuProfile);
        jsonWriter.writeJsonField("gatewayProfile", this.gatewayProfile);
        jsonWriter.writeJsonField("virtualMachinesProfile", this.virtualMachinesProfile);
        jsonWriter.writeArrayField("virtualMachineNodesStatus", this.virtualMachineNodesStatus,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("status", this.status);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagedClusterAgentPoolProfileProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagedClusterAgentPoolProfileProperties if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ManagedClusterAgentPoolProfileProperties.
     */
    public static ManagedClusterAgentPoolProfileProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedClusterAgentPoolProfileProperties deserializedManagedClusterAgentPoolProfileProperties
                = new ManagedClusterAgentPoolProfileProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("eTag".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.etag = reader.getString();
                } else if ("count".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.count = reader.getNullable(JsonReader::getInt);
                } else if ("vmSize".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.vmSize = reader.getString();
                } else if ("osDiskSizeGB".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.osDiskSizeGB
                        = reader.getNullable(JsonReader::getInt);
                } else if ("osDiskType".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.osDiskType
                        = OSDiskType.fromString(reader.getString());
                } else if ("kubeletDiskType".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.kubeletDiskType
                        = KubeletDiskType.fromString(reader.getString());
                } else if ("workloadRuntime".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.workloadRuntime
                        = WorkloadRuntime.fromString(reader.getString());
                } else if ("messageOfTheDay".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.messageOfTheDay = reader.getString();
                } else if ("vnetSubnetID".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.vnetSubnetId = reader.getString();
                } else if ("podSubnetID".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.podSubnetId = reader.getString();
                } else if ("podIPAllocationMode".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.podIpAllocationMode
                        = PodIpAllocationMode.fromString(reader.getString());
                } else if ("maxPods".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.maxPods
                        = reader.getNullable(JsonReader::getInt);
                } else if ("osType".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.osType = OSType.fromString(reader.getString());
                } else if ("osSKU".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.osSku = OSSku.fromString(reader.getString());
                } else if ("maxCount".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.maxCount
                        = reader.getNullable(JsonReader::getInt);
                } else if ("minCount".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.minCount
                        = reader.getNullable(JsonReader::getInt);
                } else if ("enableAutoScaling".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.enableAutoScaling
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("scaleDownMode".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.scaleDownMode
                        = ScaleDownMode.fromString(reader.getString());
                } else if ("type".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.type
                        = AgentPoolType.fromString(reader.getString());
                } else if ("mode".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.mode
                        = AgentPoolMode.fromString(reader.getString());
                } else if ("orchestratorVersion".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.orchestratorVersion = reader.getString();
                } else if ("currentOrchestratorVersion".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.currentOrchestratorVersion
                        = reader.getString();
                } else if ("nodeImageVersion".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.nodeImageVersion = reader.getString();
                } else if ("upgradeSettings".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.upgradeSettings
                        = AgentPoolUpgradeSettings.fromJson(reader);
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.provisioningState = reader.getString();
                } else if ("powerState".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.powerState = PowerState.fromJson(reader);
                } else if ("availabilityZones".equals(fieldName)) {
                    List<String> availabilityZones = reader.readArray(reader1 -> reader1.getString());
                    deserializedManagedClusterAgentPoolProfileProperties.availabilityZones = availabilityZones;
                } else if ("enableNodePublicIP".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.enableNodePublicIp
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("nodePublicIPPrefixID".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.nodePublicIpPrefixId = reader.getString();
                } else if ("scaleSetPriority".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.scaleSetPriority
                        = ScaleSetPriority.fromString(reader.getString());
                } else if ("scaleSetEvictionPolicy".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.scaleSetEvictionPolicy
                        = ScaleSetEvictionPolicy.fromString(reader.getString());
                } else if ("spotMaxPrice".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.spotMaxPrice
                        = reader.getNullable(JsonReader::getFloat);
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedManagedClusterAgentPoolProfileProperties.tags = tags;
                } else if ("nodeLabels".equals(fieldName)) {
                    Map<String, String> nodeLabels = reader.readMap(reader1 -> reader1.getString());
                    deserializedManagedClusterAgentPoolProfileProperties.nodeLabels = nodeLabels;
                } else if ("nodeTaints".equals(fieldName)) {
                    List<String> nodeTaints = reader.readArray(reader1 -> reader1.getString());
                    deserializedManagedClusterAgentPoolProfileProperties.nodeTaints = nodeTaints;
                } else if ("proximityPlacementGroupID".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.proximityPlacementGroupId = reader.getString();
                } else if ("kubeletConfig".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.kubeletConfig = KubeletConfig.fromJson(reader);
                } else if ("linuxOSConfig".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.linuxOSConfig = LinuxOSConfig.fromJson(reader);
                } else if ("enableEncryptionAtHost".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.enableEncryptionAtHost
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("enableUltraSSD".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.enableUltraSsd
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("enableFIPS".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.enableFips
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("gpuInstanceProfile".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.gpuInstanceProfile
                        = GpuInstanceProfile.fromString(reader.getString());
                } else if ("creationData".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.creationData = CreationData.fromJson(reader);
                } else if ("capacityReservationGroupID".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.capacityReservationGroupId
                        = reader.getString();
                } else if ("hostGroupID".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.hostGroupId = reader.getString();
                } else if ("networkProfile".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.networkProfile
                        = AgentPoolNetworkProfile.fromJson(reader);
                } else if ("windowsProfile".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.windowsProfile
                        = AgentPoolWindowsProfile.fromJson(reader);
                } else if ("securityProfile".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.securityProfile
                        = AgentPoolSecurityProfile.fromJson(reader);
                } else if ("gpuProfile".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.gpuProfile = GpuProfile.fromJson(reader);
                } else if ("gatewayProfile".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.gatewayProfile
                        = AgentPoolGatewayProfile.fromJson(reader);
                } else if ("virtualMachinesProfile".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.virtualMachinesProfile
                        = VirtualMachinesProfile.fromJson(reader);
                } else if ("virtualMachineNodesStatus".equals(fieldName)) {
                    List<VirtualMachineNodes> virtualMachineNodesStatus
                        = reader.readArray(reader1 -> VirtualMachineNodes.fromJson(reader1));
                    deserializedManagedClusterAgentPoolProfileProperties.virtualMachineNodesStatus
                        = virtualMachineNodesStatus;
                } else if ("status".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfileProperties.status = AgentPoolStatus.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagedClusterAgentPoolProfileProperties;
        });
    }
}
