// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Time in a week.
 */
@Fluent
public final class TimeInWeek implements JsonSerializable<TimeInWeek> {
    /*
     * The day of the week.
     */
    private WeekDay day;

    /*
     * Each integer hour represents a time range beginning at 0m after the hour ending at the next hour (non-inclusive).
     * 0 corresponds to 00:00 UTC, 23 corresponds to 23:00 UTC. Specifying [0, 1] means the 00:00 - 02:00 UTC time
     * range.
     */
    private List<Integer> hourSlots;

    /**
     * Creates an instance of TimeInWeek class.
     */
    public TimeInWeek() {
    }

    /**
     * Get the day property: The day of the week.
     * 
     * @return the day value.
     */
    public WeekDay day() {
        return this.day;
    }

    /**
     * Set the day property: The day of the week.
     * 
     * @param day the day value to set.
     * @return the TimeInWeek object itself.
     */
    public TimeInWeek withDay(WeekDay day) {
        this.day = day;
        return this;
    }

    /**
     * Get the hourSlots property: Each integer hour represents a time range beginning at 0m after the hour ending at
     * the next hour (non-inclusive). 0 corresponds to 00:00 UTC, 23 corresponds to 23:00 UTC. Specifying [0, 1] means
     * the 00:00 - 02:00 UTC time range.
     * 
     * @return the hourSlots value.
     */
    public List<Integer> hourSlots() {
        return this.hourSlots;
    }

    /**
     * Set the hourSlots property: Each integer hour represents a time range beginning at 0m after the hour ending at
     * the next hour (non-inclusive). 0 corresponds to 00:00 UTC, 23 corresponds to 23:00 UTC. Specifying [0, 1] means
     * the 00:00 - 02:00 UTC time range.
     * 
     * @param hourSlots the hourSlots value to set.
     * @return the TimeInWeek object itself.
     */
    public TimeInWeek withHourSlots(List<Integer> hourSlots) {
        this.hourSlots = hourSlots;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("day", this.day == null ? null : this.day.toString());
        jsonWriter.writeArrayField("hourSlots", this.hourSlots, (writer, element) -> writer.writeInt(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TimeInWeek from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TimeInWeek if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IOException If an error occurs while reading the TimeInWeek.
     */
    public static TimeInWeek fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TimeInWeek deserializedTimeInWeek = new TimeInWeek();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("day".equals(fieldName)) {
                    deserializedTimeInWeek.day = WeekDay.fromString(reader.getString());
                } else if ("hourSlots".equals(fieldName)) {
                    List<Integer> hourSlots = reader.readArray(reader1 -> reader1.getInt());
                    deserializedTimeInWeek.hourSlots = hourSlots;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTimeInWeek;
        });
    }
}
