// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerservice.fluent.models.MeshUpgradeProfileInner;
import java.io.IOException;
import java.util.List;

/**
 * Holds an array of MeshUpgradeProfiles.
 */
@Fluent
public final class MeshUpgradeProfileList implements JsonSerializable<MeshUpgradeProfileList> {
    /*
     * Array of supported service mesh add-on upgrade profiles.
     */
    private List<MeshUpgradeProfileInner> value;

    /*
     * The URL to get the next set of mesh upgrade profile.
     */
    private String nextLink;

    /**
     * Creates an instance of MeshUpgradeProfileList class.
     */
    public MeshUpgradeProfileList() {
    }

    /**
     * Get the value property: Array of supported service mesh add-on upgrade profiles.
     * 
     * @return the value value.
     */
    public List<MeshUpgradeProfileInner> value() {
        return this.value;
    }

    /**
     * Set the value property: Array of supported service mesh add-on upgrade profiles.
     * 
     * @param value the value value to set.
     * @return the MeshUpgradeProfileList object itself.
     */
    public MeshUpgradeProfileList withValue(List<MeshUpgradeProfileInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URL to get the next set of mesh upgrade profile.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MeshUpgradeProfileList from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MeshUpgradeProfileList if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MeshUpgradeProfileList.
     */
    public static MeshUpgradeProfileList fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MeshUpgradeProfileList deserializedMeshUpgradeProfileList = new MeshUpgradeProfileList();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<MeshUpgradeProfileInner> value
                        = reader.readArray(reader1 -> MeshUpgradeProfileInner.fromJson(reader1));
                    deserializedMeshUpgradeProfileList.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedMeshUpgradeProfileList.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMeshUpgradeProfileList;
        });
    }
}
