// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Auto upgrade profile for a managed cluster.
 */
@Fluent
public final class ManagedClusterAutoUpgradeProfile implements JsonSerializable<ManagedClusterAutoUpgradeProfile> {
    /*
     * For more information see [setting the AKS cluster auto-upgrade
     * channel](https://docs.microsoft.com/azure/aks/upgrade-cluster#set-auto-upgrade-channel).
     */
    private UpgradeChannel upgradeChannel;

    /*
     * Manner in which the OS on your nodes is updated. The default is NodeImage.
     */
    private NodeOSUpgradeChannel nodeOSUpgradeChannel;

    /**
     * Creates an instance of ManagedClusterAutoUpgradeProfile class.
     */
    public ManagedClusterAutoUpgradeProfile() {
    }

    /**
     * Get the upgradeChannel property: For more information see [setting the AKS cluster auto-upgrade
     * channel](https://docs.microsoft.com/azure/aks/upgrade-cluster#set-auto-upgrade-channel).
     * 
     * @return the upgradeChannel value.
     */
    public UpgradeChannel upgradeChannel() {
        return this.upgradeChannel;
    }

    /**
     * Set the upgradeChannel property: For more information see [setting the AKS cluster auto-upgrade
     * channel](https://docs.microsoft.com/azure/aks/upgrade-cluster#set-auto-upgrade-channel).
     * 
     * @param upgradeChannel the upgradeChannel value to set.
     * @return the ManagedClusterAutoUpgradeProfile object itself.
     */
    public ManagedClusterAutoUpgradeProfile withUpgradeChannel(UpgradeChannel upgradeChannel) {
        this.upgradeChannel = upgradeChannel;
        return this;
    }

    /**
     * Get the nodeOSUpgradeChannel property: Manner in which the OS on your nodes is updated. The default is NodeImage.
     * 
     * @return the nodeOSUpgradeChannel value.
     */
    public NodeOSUpgradeChannel nodeOSUpgradeChannel() {
        return this.nodeOSUpgradeChannel;
    }

    /**
     * Set the nodeOSUpgradeChannel property: Manner in which the OS on your nodes is updated. The default is NodeImage.
     * 
     * @param nodeOSUpgradeChannel the nodeOSUpgradeChannel value to set.
     * @return the ManagedClusterAutoUpgradeProfile object itself.
     */
    public ManagedClusterAutoUpgradeProfile withNodeOSUpgradeChannel(NodeOSUpgradeChannel nodeOSUpgradeChannel) {
        this.nodeOSUpgradeChannel = nodeOSUpgradeChannel;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("upgradeChannel",
            this.upgradeChannel == null ? null : this.upgradeChannel.toString());
        jsonWriter.writeStringField("nodeOSUpgradeChannel",
            this.nodeOSUpgradeChannel == null ? null : this.nodeOSUpgradeChannel.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagedClusterAutoUpgradeProfile from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagedClusterAutoUpgradeProfile if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ManagedClusterAutoUpgradeProfile.
     */
    public static ManagedClusterAutoUpgradeProfile fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedClusterAutoUpgradeProfile deserializedManagedClusterAutoUpgradeProfile
                = new ManagedClusterAutoUpgradeProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("upgradeChannel".equals(fieldName)) {
                    deserializedManagedClusterAutoUpgradeProfile.upgradeChannel
                        = UpgradeChannel.fromString(reader.getString());
                } else if ("nodeOSUpgradeChannel".equals(fieldName)) {
                    deserializedManagedClusterAutoUpgradeProfile.nodeOSUpgradeChannel
                        = NodeOSUpgradeChannel.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagedClusterAutoUpgradeProfile;
        });
    }
}
