// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Data used when creating a target resource from a source resource.
 */
@Fluent
public final class CreationData implements JsonSerializable<CreationData> {
    /*
     * This is the ARM ID of the source object to be used to create the target object.
     */
    private String sourceResourceId;

    /**
     * Creates an instance of CreationData class.
     */
    public CreationData() {
    }

    /**
     * Get the sourceResourceId property: This is the ARM ID of the source object to be used to create the target
     * object.
     * 
     * @return the sourceResourceId value.
     */
    public String sourceResourceId() {
        return this.sourceResourceId;
    }

    /**
     * Set the sourceResourceId property: This is the ARM ID of the source object to be used to create the target
     * object.
     * 
     * @param sourceResourceId the sourceResourceId value to set.
     * @return the CreationData object itself.
     */
    public CreationData withSourceResourceId(String sourceResourceId) {
        this.sourceResourceId = sourceResourceId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("sourceResourceId", this.sourceResourceId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CreationData from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CreationData if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the CreationData.
     */
    public static CreationData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CreationData deserializedCreationData = new CreationData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("sourceResourceId".equals(fieldName)) {
                    deserializedCreationData.sourceResourceId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCreationData;
        });
    }
}
