// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The Windows agent pool's specific profile.
 */
@Fluent
public final class AgentPoolWindowsProfile implements JsonSerializable<AgentPoolWindowsProfile> {
    /*
     * The default value is false. Outbound NAT can only be disabled if the cluster outboundType is NAT Gateway and the
     * Windows agent pool does not have node public IP enabled.
     */
    private Boolean disableOutboundNat;

    /**
     * Creates an instance of AgentPoolWindowsProfile class.
     */
    public AgentPoolWindowsProfile() {
    }

    /**
     * Get the disableOutboundNat property: The default value is false. Outbound NAT can only be disabled if the cluster
     * outboundType is NAT Gateway and the Windows agent pool does not have node public IP enabled.
     * 
     * @return the disableOutboundNat value.
     */
    public Boolean disableOutboundNat() {
        return this.disableOutboundNat;
    }

    /**
     * Set the disableOutboundNat property: The default value is false. Outbound NAT can only be disabled if the cluster
     * outboundType is NAT Gateway and the Windows agent pool does not have node public IP enabled.
     * 
     * @param disableOutboundNat the disableOutboundNat value to set.
     * @return the AgentPoolWindowsProfile object itself.
     */
    public AgentPoolWindowsProfile withDisableOutboundNat(Boolean disableOutboundNat) {
        this.disableOutboundNat = disableOutboundNat;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("disableOutboundNat", this.disableOutboundNat);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AgentPoolWindowsProfile from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AgentPoolWindowsProfile if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AgentPoolWindowsProfile.
     */
    public static AgentPoolWindowsProfile fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AgentPoolWindowsProfile deserializedAgentPoolWindowsProfile = new AgentPoolWindowsProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("disableOutboundNat".equals(fieldName)) {
                    deserializedAgentPoolWindowsProfile.disableOutboundNat = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAgentPoolWindowsProfile;
        });
    }
}
