/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservice.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerservice.fluent.models.ManagedClusterAgentPoolProfileProperties;
import com.azure.resourcemanager.containerservice.models.AgentPoolMode;
import com.azure.resourcemanager.containerservice.models.AgentPoolNetworkProfile;
import com.azure.resourcemanager.containerservice.models.AgentPoolSecurityProfile;
import com.azure.resourcemanager.containerservice.models.AgentPoolType;
import com.azure.resourcemanager.containerservice.models.AgentPoolUpgradeSettings;
import com.azure.resourcemanager.containerservice.models.AgentPoolWindowsProfile;
import com.azure.resourcemanager.containerservice.models.CreationData;
import com.azure.resourcemanager.containerservice.models.GpuInstanceProfile;
import com.azure.resourcemanager.containerservice.models.KubeletConfig;
import com.azure.resourcemanager.containerservice.models.KubeletDiskType;
import com.azure.resourcemanager.containerservice.models.LinuxOSConfig;
import com.azure.resourcemanager.containerservice.models.OSDiskType;
import com.azure.resourcemanager.containerservice.models.OSSku;
import com.azure.resourcemanager.containerservice.models.OSType;
import com.azure.resourcemanager.containerservice.models.PowerState;
import com.azure.resourcemanager.containerservice.models.ScaleDownMode;
import com.azure.resourcemanager.containerservice.models.ScaleSetEvictionPolicy;
import com.azure.resourcemanager.containerservice.models.ScaleSetPriority;
import com.azure.resourcemanager.containerservice.models.WorkloadRuntime;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class ManagedClusterAgentPoolProfile
extends ManagedClusterAgentPoolProfileProperties {
    private String name;
    private String provisioningState;
    private String nodeImageVersion;
    private String currentOrchestratorVersion;
    private String etag;
    private static final ClientLogger LOGGER = new ClientLogger(ManagedClusterAgentPoolProfile.class);

    public String name() {
        return this.name;
    }

    public ManagedClusterAgentPoolProfile withName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public String provisioningState() {
        return this.provisioningState;
    }

    @Override
    public String nodeImageVersion() {
        return this.nodeImageVersion;
    }

    @Override
    public String currentOrchestratorVersion() {
        return this.currentOrchestratorVersion;
    }

    @Override
    public String etag() {
        return this.etag;
    }

    @Override
    public ManagedClusterAgentPoolProfile withCount(Integer count) {
        super.withCount(count);
        return this;
    }

    @Override
    public ManagedClusterAgentPoolProfile withVmSize(String vmSize) {
        super.withVmSize(vmSize);
        return this;
    }

    @Override
    public ManagedClusterAgentPoolProfile withOsDiskSizeGB(Integer osDiskSizeGB) {
        super.withOsDiskSizeGB(osDiskSizeGB);
        return this;
    }

    @Override
    public ManagedClusterAgentPoolProfile withOsDiskType(OSDiskType osDiskType) {
        super.withOsDiskType(osDiskType);
        return this;
    }

    @Override
    public ManagedClusterAgentPoolProfile withKubeletDiskType(KubeletDiskType kubeletDiskType) {
        super.withKubeletDiskType(kubeletDiskType);
        return this;
    }

    @Override
    public ManagedClusterAgentPoolProfile withWorkloadRuntime(WorkloadRuntime workloadRuntime) {
        super.withWorkloadRuntime(workloadRuntime);
        return this;
    }

    @Override
    public ManagedClusterAgentPoolProfile withMessageOfTheDay(String messageOfTheDay) {
        super.withMessageOfTheDay(messageOfTheDay);
        return this;
    }

    @Override
    public ManagedClusterAgentPoolProfile withVnetSubnetId(String vnetSubnetId) {
        super.withVnetSubnetId(vnetSubnetId);
        return this;
    }

    @Override
    public ManagedClusterAgentPoolProfile withPodSubnetId(String podSubnetId) {
        super.withPodSubnetId(podSubnetId);
        return this;
    }

    @Override
    public ManagedClusterAgentPoolProfile withMaxPods(Integer maxPods) {
        super.withMaxPods(maxPods);
        return this;
    }

    @Override
    public ManagedClusterAgentPoolProfile withOsType(OSType osType) {
        super.withOsType(osType);
        return this;
    }

    @Override
    public ManagedClusterAgentPoolProfile withOsSku(OSSku osSku) {
        super.withOsSku(osSku);
        return this;
    }

    @Override
    public ManagedClusterAgentPoolProfile withMaxCount(Integer maxCount) {
        super.withMaxCount(maxCount);
        return this;
    }

    @Override
    public ManagedClusterAgentPoolProfile withMinCount(Integer minCount) {
        super.withMinCount(minCount);
        return this;
    }

    @Override
    public ManagedClusterAgentPoolProfile withEnableAutoScaling(Boolean enableAutoScaling) {
        super.withEnableAutoScaling(enableAutoScaling);
        return this;
    }

    @Override
    public ManagedClusterAgentPoolProfile withScaleDownMode(ScaleDownMode scaleDownMode) {
        super.withScaleDownMode(scaleDownMode);
        return this;
    }

    @Override
    public ManagedClusterAgentPoolProfile withType(AgentPoolType type) {
        super.withType(type);
        return this;
    }

    @Override
    public ManagedClusterAgentPoolProfile withMode(AgentPoolMode mode) {
        super.withMode(mode);
        return this;
    }

    @Override
    public ManagedClusterAgentPoolProfile withOrchestratorVersion(String orchestratorVersion) {
        super.withOrchestratorVersion(orchestratorVersion);
        return this;
    }

    @Override
    public ManagedClusterAgentPoolProfile withUpgradeSettings(AgentPoolUpgradeSettings upgradeSettings) {
        super.withUpgradeSettings(upgradeSettings);
        return this;
    }

    @Override
    public ManagedClusterAgentPoolProfile withPowerState(PowerState powerState) {
        super.withPowerState(powerState);
        return this;
    }

    @Override
    public ManagedClusterAgentPoolProfile withAvailabilityZones(List<String> availabilityZones) {
        super.withAvailabilityZones(availabilityZones);
        return this;
    }

    @Override
    public ManagedClusterAgentPoolProfile withEnableNodePublicIp(Boolean enableNodePublicIp) {
        super.withEnableNodePublicIp(enableNodePublicIp);
        return this;
    }

    @Override
    public ManagedClusterAgentPoolProfile withNodePublicIpPrefixId(String nodePublicIpPrefixId) {
        super.withNodePublicIpPrefixId(nodePublicIpPrefixId);
        return this;
    }

    @Override
    public ManagedClusterAgentPoolProfile withScaleSetPriority(ScaleSetPriority scaleSetPriority) {
        super.withScaleSetPriority(scaleSetPriority);
        return this;
    }

    @Override
    public ManagedClusterAgentPoolProfile withScaleSetEvictionPolicy(ScaleSetEvictionPolicy scaleSetEvictionPolicy) {
        super.withScaleSetEvictionPolicy(scaleSetEvictionPolicy);
        return this;
    }

    @Override
    public ManagedClusterAgentPoolProfile withSpotMaxPrice(Float spotMaxPrice) {
        super.withSpotMaxPrice(spotMaxPrice);
        return this;
    }

    @Override
    public ManagedClusterAgentPoolProfile withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    @Override
    public ManagedClusterAgentPoolProfile withNodeLabels(Map<String, String> nodeLabels) {
        super.withNodeLabels(nodeLabels);
        return this;
    }

    @Override
    public ManagedClusterAgentPoolProfile withNodeTaints(List<String> nodeTaints) {
        super.withNodeTaints(nodeTaints);
        return this;
    }

    @Override
    public ManagedClusterAgentPoolProfile withProximityPlacementGroupId(String proximityPlacementGroupId) {
        super.withProximityPlacementGroupId(proximityPlacementGroupId);
        return this;
    }

    @Override
    public ManagedClusterAgentPoolProfile withKubeletConfig(KubeletConfig kubeletConfig) {
        super.withKubeletConfig(kubeletConfig);
        return this;
    }

    @Override
    public ManagedClusterAgentPoolProfile withLinuxOSConfig(LinuxOSConfig linuxOSConfig) {
        super.withLinuxOSConfig(linuxOSConfig);
        return this;
    }

    @Override
    public ManagedClusterAgentPoolProfile withEnableEncryptionAtHost(Boolean enableEncryptionAtHost) {
        super.withEnableEncryptionAtHost(enableEncryptionAtHost);
        return this;
    }

    @Override
    public ManagedClusterAgentPoolProfile withEnableUltraSsd(Boolean enableUltraSsd) {
        super.withEnableUltraSsd(enableUltraSsd);
        return this;
    }

    @Override
    public ManagedClusterAgentPoolProfile withEnableFips(Boolean enableFips) {
        super.withEnableFips(enableFips);
        return this;
    }

    @Override
    public ManagedClusterAgentPoolProfile withGpuInstanceProfile(GpuInstanceProfile gpuInstanceProfile) {
        super.withGpuInstanceProfile(gpuInstanceProfile);
        return this;
    }

    @Override
    public ManagedClusterAgentPoolProfile withCreationData(CreationData creationData) {
        super.withCreationData(creationData);
        return this;
    }

    @Override
    public ManagedClusterAgentPoolProfile withCapacityReservationGroupId(String capacityReservationGroupId) {
        super.withCapacityReservationGroupId(capacityReservationGroupId);
        return this;
    }

    @Override
    public ManagedClusterAgentPoolProfile withHostGroupId(String hostGroupId) {
        super.withHostGroupId(hostGroupId);
        return this;
    }

    @Override
    public ManagedClusterAgentPoolProfile withNetworkProfile(AgentPoolNetworkProfile networkProfile) {
        super.withNetworkProfile(networkProfile);
        return this;
    }

    @Override
    public ManagedClusterAgentPoolProfile withWindowsProfile(AgentPoolWindowsProfile windowsProfile) {
        super.withWindowsProfile(windowsProfile);
        return this;
    }

    @Override
    public ManagedClusterAgentPoolProfile withSecurityProfile(AgentPoolSecurityProfile securityProfile) {
        super.withSecurityProfile(securityProfile);
        return this;
    }

    @Override
    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model ManagedClusterAgentPoolProfile"));
        }
        if (this.upgradeSettings() != null) {
            this.upgradeSettings().validate();
        }
        if (this.powerState() != null) {
            this.powerState().validate();
        }
        if (this.kubeletConfig() != null) {
            this.kubeletConfig().validate();
        }
        if (this.linuxOSConfig() != null) {
            this.linuxOSConfig().validate();
        }
        if (this.creationData() != null) {
            this.creationData().validate();
        }
        if (this.networkProfile() != null) {
            this.networkProfile().validate();
        }
        if (this.windowsProfile() != null) {
            this.windowsProfile().validate();
        }
        if (this.securityProfile() != null) {
            this.securityProfile().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("count", (Number)this.count());
        jsonWriter.writeStringField("vmSize", this.vmSize());
        jsonWriter.writeNumberField("osDiskSizeGB", (Number)this.osDiskSizeGB());
        jsonWriter.writeStringField("osDiskType", this.osDiskType() == null ? null : this.osDiskType().toString());
        jsonWriter.writeStringField("kubeletDiskType", this.kubeletDiskType() == null ? null : this.kubeletDiskType().toString());
        jsonWriter.writeStringField("workloadRuntime", this.workloadRuntime() == null ? null : this.workloadRuntime().toString());
        jsonWriter.writeStringField("messageOfTheDay", this.messageOfTheDay());
        jsonWriter.writeStringField("vnetSubnetID", this.vnetSubnetId());
        jsonWriter.writeStringField("podSubnetID", this.podSubnetId());
        jsonWriter.writeNumberField("maxPods", (Number)this.maxPods());
        jsonWriter.writeStringField("osType", this.osType() == null ? null : this.osType().toString());
        jsonWriter.writeStringField("osSKU", this.osSku() == null ? null : this.osSku().toString());
        jsonWriter.writeNumberField("maxCount", (Number)this.maxCount());
        jsonWriter.writeNumberField("minCount", (Number)this.minCount());
        jsonWriter.writeBooleanField("enableAutoScaling", this.enableAutoScaling());
        jsonWriter.writeStringField("scaleDownMode", this.scaleDownMode() == null ? null : this.scaleDownMode().toString());
        jsonWriter.writeStringField("type", this.type() == null ? null : this.type().toString());
        jsonWriter.writeStringField("mode", this.mode() == null ? null : this.mode().toString());
        jsonWriter.writeStringField("orchestratorVersion", this.orchestratorVersion());
        jsonWriter.writeJsonField("upgradeSettings", (JsonSerializable)this.upgradeSettings());
        jsonWriter.writeJsonField("powerState", (JsonSerializable)this.powerState());
        jsonWriter.writeArrayField("availabilityZones", this.availabilityZones(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("enableNodePublicIP", this.enableNodePublicIp());
        jsonWriter.writeStringField("nodePublicIPPrefixID", this.nodePublicIpPrefixId());
        jsonWriter.writeStringField("scaleSetPriority", this.scaleSetPriority() == null ? null : this.scaleSetPriority().toString());
        jsonWriter.writeStringField("scaleSetEvictionPolicy", this.scaleSetEvictionPolicy() == null ? null : this.scaleSetEvictionPolicy().toString());
        jsonWriter.writeNumberField("spotMaxPrice", (Number)this.spotMaxPrice());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeMapField("nodeLabels", this.nodeLabels(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("nodeTaints", this.nodeTaints(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("proximityPlacementGroupID", this.proximityPlacementGroupId());
        jsonWriter.writeJsonField("kubeletConfig", (JsonSerializable)this.kubeletConfig());
        jsonWriter.writeJsonField("linuxOSConfig", (JsonSerializable)this.linuxOSConfig());
        jsonWriter.writeBooleanField("enableEncryptionAtHost", this.enableEncryptionAtHost());
        jsonWriter.writeBooleanField("enableUltraSSD", this.enableUltraSsd());
        jsonWriter.writeBooleanField("enableFIPS", this.enableFips());
        jsonWriter.writeStringField("gpuInstanceProfile", this.gpuInstanceProfile() == null ? null : this.gpuInstanceProfile().toString());
        jsonWriter.writeJsonField("creationData", (JsonSerializable)this.creationData());
        jsonWriter.writeStringField("capacityReservationGroupID", this.capacityReservationGroupId());
        jsonWriter.writeStringField("hostGroupID", this.hostGroupId());
        jsonWriter.writeJsonField("networkProfile", (JsonSerializable)this.networkProfile());
        jsonWriter.writeJsonField("windowsProfile", (JsonSerializable)this.windowsProfile());
        jsonWriter.writeJsonField("securityProfile", (JsonSerializable)this.securityProfile());
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    public static ManagedClusterAgentPoolProfile fromJson(JsonReader jsonReader) throws IOException {
        return (ManagedClusterAgentPoolProfile)jsonReader.readObject(reader -> {
            ManagedClusterAgentPoolProfile deserializedManagedClusterAgentPoolProfile = new ManagedClusterAgentPoolProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("eTag".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfile.etag = reader.getString();
                    continue;
                }
                if ("count".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfile.withCount((Integer)reader.getNullable(JsonReader::getInt));
                    continue;
                }
                if ("vmSize".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfile.withVmSize(reader.getString());
                    continue;
                }
                if ("osDiskSizeGB".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfile.withOsDiskSizeGB((Integer)reader.getNullable(JsonReader::getInt));
                    continue;
                }
                if ("osDiskType".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfile.withOsDiskType(OSDiskType.fromString(reader.getString()));
                    continue;
                }
                if ("kubeletDiskType".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfile.withKubeletDiskType(KubeletDiskType.fromString(reader.getString()));
                    continue;
                }
                if ("workloadRuntime".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfile.withWorkloadRuntime(WorkloadRuntime.fromString(reader.getString()));
                    continue;
                }
                if ("messageOfTheDay".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfile.withMessageOfTheDay(reader.getString());
                    continue;
                }
                if ("vnetSubnetID".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfile.withVnetSubnetId(reader.getString());
                    continue;
                }
                if ("podSubnetID".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfile.withPodSubnetId(reader.getString());
                    continue;
                }
                if ("maxPods".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfile.withMaxPods((Integer)reader.getNullable(JsonReader::getInt));
                    continue;
                }
                if ("osType".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfile.withOsType(OSType.fromString(reader.getString()));
                    continue;
                }
                if ("osSKU".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfile.withOsSku(OSSku.fromString(reader.getString()));
                    continue;
                }
                if ("maxCount".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfile.withMaxCount((Integer)reader.getNullable(JsonReader::getInt));
                    continue;
                }
                if ("minCount".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfile.withMinCount((Integer)reader.getNullable(JsonReader::getInt));
                    continue;
                }
                if ("enableAutoScaling".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfile.withEnableAutoScaling((Boolean)reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("scaleDownMode".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfile.withScaleDownMode(ScaleDownMode.fromString(reader.getString()));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfile.withType(AgentPoolType.fromString(reader.getString()));
                    continue;
                }
                if ("mode".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfile.withMode(AgentPoolMode.fromString(reader.getString()));
                    continue;
                }
                if ("orchestratorVersion".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfile.withOrchestratorVersion(reader.getString());
                    continue;
                }
                if ("currentOrchestratorVersion".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfile.currentOrchestratorVersion = reader.getString();
                    continue;
                }
                if ("nodeImageVersion".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfile.nodeImageVersion = reader.getString();
                    continue;
                }
                if ("upgradeSettings".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfile.withUpgradeSettings(AgentPoolUpgradeSettings.fromJson(reader));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfile.provisioningState = reader.getString();
                    continue;
                }
                if ("powerState".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfile.withPowerState(PowerState.fromJson(reader));
                    continue;
                }
                if ("availabilityZones".equals(fieldName)) {
                    List availabilityZones = reader.readArray(reader1 -> reader1.getString());
                    deserializedManagedClusterAgentPoolProfile.withAvailabilityZones(availabilityZones);
                    continue;
                }
                if ("enableNodePublicIP".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfile.withEnableNodePublicIp((Boolean)reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("nodePublicIPPrefixID".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfile.withNodePublicIpPrefixId(reader.getString());
                    continue;
                }
                if ("scaleSetPriority".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfile.withScaleSetPriority(ScaleSetPriority.fromString(reader.getString()));
                    continue;
                }
                if ("scaleSetEvictionPolicy".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfile.withScaleSetEvictionPolicy(ScaleSetEvictionPolicy.fromString(reader.getString()));
                    continue;
                }
                if ("spotMaxPrice".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfile.withSpotMaxPrice((Float)reader.getNullable(JsonReader::getFloat));
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedManagedClusterAgentPoolProfile.withTags(tags);
                    continue;
                }
                if ("nodeLabels".equals(fieldName)) {
                    Map nodeLabels = reader.readMap(reader1 -> reader1.getString());
                    deserializedManagedClusterAgentPoolProfile.withNodeLabels(nodeLabels);
                    continue;
                }
                if ("nodeTaints".equals(fieldName)) {
                    List nodeTaints = reader.readArray(reader1 -> reader1.getString());
                    deserializedManagedClusterAgentPoolProfile.withNodeTaints(nodeTaints);
                    continue;
                }
                if ("proximityPlacementGroupID".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfile.withProximityPlacementGroupId(reader.getString());
                    continue;
                }
                if ("kubeletConfig".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfile.withKubeletConfig(KubeletConfig.fromJson(reader));
                    continue;
                }
                if ("linuxOSConfig".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfile.withLinuxOSConfig(LinuxOSConfig.fromJson(reader));
                    continue;
                }
                if ("enableEncryptionAtHost".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfile.withEnableEncryptionAtHost((Boolean)reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("enableUltraSSD".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfile.withEnableUltraSsd((Boolean)reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("enableFIPS".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfile.withEnableFips((Boolean)reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("gpuInstanceProfile".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfile.withGpuInstanceProfile(GpuInstanceProfile.fromString(reader.getString()));
                    continue;
                }
                if ("creationData".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfile.withCreationData(CreationData.fromJson(reader));
                    continue;
                }
                if ("capacityReservationGroupID".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfile.withCapacityReservationGroupId(reader.getString());
                    continue;
                }
                if ("hostGroupID".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfile.withHostGroupId(reader.getString());
                    continue;
                }
                if ("networkProfile".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfile.withNetworkProfile(AgentPoolNetworkProfile.fromJson(reader));
                    continue;
                }
                if ("windowsProfile".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfile.withWindowsProfile(AgentPoolWindowsProfile.fromJson(reader));
                    continue;
                }
                if ("securityProfile".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfile.withSecurityProfile(AgentPoolSecurityProfile.fromJson(reader));
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedManagedClusterAgentPoolProfile.name = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedClusterAgentPoolProfile;
        });
    }
}

