// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Storage profile for the container service cluster.
 */
@Fluent
public final class ManagedClusterStorageProfile implements JsonSerializable<ManagedClusterStorageProfile> {
    /*
     * AzureDisk CSI Driver settings for the storage profile.
     */
    private ManagedClusterStorageProfileDiskCsiDriver diskCsiDriver;

    /*
     * AzureFile CSI Driver settings for the storage profile.
     */
    private ManagedClusterStorageProfileFileCsiDriver fileCsiDriver;

    /*
     * Snapshot Controller settings for the storage profile.
     */
    private ManagedClusterStorageProfileSnapshotController snapshotController;

    /*
     * AzureBlob CSI Driver settings for the storage profile.
     */
    private ManagedClusterStorageProfileBlobCsiDriver blobCsiDriver;

    /**
     * Creates an instance of ManagedClusterStorageProfile class.
     */
    public ManagedClusterStorageProfile() {
    }

    /**
     * Get the diskCsiDriver property: AzureDisk CSI Driver settings for the storage profile.
     * 
     * @return the diskCsiDriver value.
     */
    public ManagedClusterStorageProfileDiskCsiDriver diskCsiDriver() {
        return this.diskCsiDriver;
    }

    /**
     * Set the diskCsiDriver property: AzureDisk CSI Driver settings for the storage profile.
     * 
     * @param diskCsiDriver the diskCsiDriver value to set.
     * @return the ManagedClusterStorageProfile object itself.
     */
    public ManagedClusterStorageProfile withDiskCsiDriver(ManagedClusterStorageProfileDiskCsiDriver diskCsiDriver) {
        this.diskCsiDriver = diskCsiDriver;
        return this;
    }

    /**
     * Get the fileCsiDriver property: AzureFile CSI Driver settings for the storage profile.
     * 
     * @return the fileCsiDriver value.
     */
    public ManagedClusterStorageProfileFileCsiDriver fileCsiDriver() {
        return this.fileCsiDriver;
    }

    /**
     * Set the fileCsiDriver property: AzureFile CSI Driver settings for the storage profile.
     * 
     * @param fileCsiDriver the fileCsiDriver value to set.
     * @return the ManagedClusterStorageProfile object itself.
     */
    public ManagedClusterStorageProfile withFileCsiDriver(ManagedClusterStorageProfileFileCsiDriver fileCsiDriver) {
        this.fileCsiDriver = fileCsiDriver;
        return this;
    }

    /**
     * Get the snapshotController property: Snapshot Controller settings for the storage profile.
     * 
     * @return the snapshotController value.
     */
    public ManagedClusterStorageProfileSnapshotController snapshotController() {
        return this.snapshotController;
    }

    /**
     * Set the snapshotController property: Snapshot Controller settings for the storage profile.
     * 
     * @param snapshotController the snapshotController value to set.
     * @return the ManagedClusterStorageProfile object itself.
     */
    public ManagedClusterStorageProfile
        withSnapshotController(ManagedClusterStorageProfileSnapshotController snapshotController) {
        this.snapshotController = snapshotController;
        return this;
    }

    /**
     * Get the blobCsiDriver property: AzureBlob CSI Driver settings for the storage profile.
     * 
     * @return the blobCsiDriver value.
     */
    public ManagedClusterStorageProfileBlobCsiDriver blobCsiDriver() {
        return this.blobCsiDriver;
    }

    /**
     * Set the blobCsiDriver property: AzureBlob CSI Driver settings for the storage profile.
     * 
     * @param blobCsiDriver the blobCsiDriver value to set.
     * @return the ManagedClusterStorageProfile object itself.
     */
    public ManagedClusterStorageProfile withBlobCsiDriver(ManagedClusterStorageProfileBlobCsiDriver blobCsiDriver) {
        this.blobCsiDriver = blobCsiDriver;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (diskCsiDriver() != null) {
            diskCsiDriver().validate();
        }
        if (fileCsiDriver() != null) {
            fileCsiDriver().validate();
        }
        if (snapshotController() != null) {
            snapshotController().validate();
        }
        if (blobCsiDriver() != null) {
            blobCsiDriver().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("diskCSIDriver", this.diskCsiDriver);
        jsonWriter.writeJsonField("fileCSIDriver", this.fileCsiDriver);
        jsonWriter.writeJsonField("snapshotController", this.snapshotController);
        jsonWriter.writeJsonField("blobCSIDriver", this.blobCsiDriver);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagedClusterStorageProfile from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagedClusterStorageProfile if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ManagedClusterStorageProfile.
     */
    public static ManagedClusterStorageProfile fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedClusterStorageProfile deserializedManagedClusterStorageProfile = new ManagedClusterStorageProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("diskCSIDriver".equals(fieldName)) {
                    deserializedManagedClusterStorageProfile.diskCsiDriver
                        = ManagedClusterStorageProfileDiskCsiDriver.fromJson(reader);
                } else if ("fileCSIDriver".equals(fieldName)) {
                    deserializedManagedClusterStorageProfile.fileCsiDriver
                        = ManagedClusterStorageProfileFileCsiDriver.fromJson(reader);
                } else if ("snapshotController".equals(fieldName)) {
                    deserializedManagedClusterStorageProfile.snapshotController
                        = ManagedClusterStorageProfileSnapshotController.fromJson(reader);
                } else if ("blobCSIDriver".equals(fieldName)) {
                    deserializedManagedClusterStorageProfile.blobCsiDriver
                        = ManagedClusterStorageProfileBlobCsiDriver.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagedClusterStorageProfile;
        });
    }
}
