// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * network properties of the machine.
 */
@Immutable
public final class MachineNetworkProperties implements JsonSerializable<MachineNetworkProperties> {
    /*
     * IPv4, IPv6 addresses of the machine
     */
    private List<MachineIpAddress> ipAddresses;

    /**
     * Creates an instance of MachineNetworkProperties class.
     */
    public MachineNetworkProperties() {
    }

    /**
     * Get the ipAddresses property: IPv4, IPv6 addresses of the machine.
     * 
     * @return the ipAddresses value.
     */
    public List<MachineIpAddress> ipAddresses() {
        return this.ipAddresses;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (ipAddresses() != null) {
            ipAddresses().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MachineNetworkProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MachineNetworkProperties if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MachineNetworkProperties.
     */
    public static MachineNetworkProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MachineNetworkProperties deserializedMachineNetworkProperties = new MachineNetworkProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("ipAddresses".equals(fieldName)) {
                    List<MachineIpAddress> ipAddresses
                        = reader.readArray(reader1 -> MachineIpAddress.fromJson(reader1));
                    deserializedMachineNetworkProperties.ipAddresses = ipAddresses;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMachineNetworkProperties;
        });
    }
}
