/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservice.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.containerservice.fluent.TrustedAccessRoleBindingsClient;
import com.azure.resourcemanager.containerservice.fluent.models.TrustedAccessRoleBindingInner;
import com.azure.resourcemanager.containerservice.implementation.ContainerServiceManagementClientImpl;
import com.azure.resourcemanager.containerservice.models.TrustedAccessRoleBindingListResult;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class TrustedAccessRoleBindingsClientImpl
implements TrustedAccessRoleBindingsClient {
    private final TrustedAccessRoleBindingsService service;
    private final ContainerServiceManagementClientImpl client;

    TrustedAccessRoleBindingsClientImpl(ContainerServiceManagementClientImpl client) {
        this.service = (TrustedAccessRoleBindingsService)RestProxy.create(TrustedAccessRoleBindingsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<TrustedAccessRoleBindingInner>> listSinglePageAsync(String resourceGroupName, String resourceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        String apiVersion = "2024-09-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), "2024-09-01", this.client.getSubscriptionId(), resourceGroupName, resourceName, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((TrustedAccessRoleBindingListResult)res.getValue()).value(), ((TrustedAccessRoleBindingListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<TrustedAccessRoleBindingInner>> listSinglePageAsync(String resourceGroupName, String resourceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        String apiVersion = "2024-09-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), "2024-09-01", this.client.getSubscriptionId(), resourceGroupName, resourceName, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((TrustedAccessRoleBindingListResult)res.getValue()).value(), ((TrustedAccessRoleBindingListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<TrustedAccessRoleBindingInner> listAsync(String resourceGroupName, String resourceName) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, resourceName), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<TrustedAccessRoleBindingInner> listAsync(String resourceGroupName, String resourceName, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, resourceName, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<TrustedAccessRoleBindingInner> list(String resourceGroupName, String resourceName) {
        return new PagedIterable(this.listAsync(resourceGroupName, resourceName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<TrustedAccessRoleBindingInner> list(String resourceGroupName, String resourceName, Context context) {
        return new PagedIterable(this.listAsync(resourceGroupName, resourceName, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<TrustedAccessRoleBindingInner>> getWithResponseAsync(String resourceGroupName, String resourceName, String trustedAccessRoleBindingName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (trustedAccessRoleBindingName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter trustedAccessRoleBindingName is required and cannot be null."));
        }
        String apiVersion = "2024-09-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), "2024-09-01", this.client.getSubscriptionId(), resourceGroupName, resourceName, trustedAccessRoleBindingName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<TrustedAccessRoleBindingInner>> getWithResponseAsync(String resourceGroupName, String resourceName, String trustedAccessRoleBindingName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (trustedAccessRoleBindingName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter trustedAccessRoleBindingName is required and cannot be null."));
        }
        String apiVersion = "2024-09-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), "2024-09-01", this.client.getSubscriptionId(), resourceGroupName, resourceName, trustedAccessRoleBindingName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TrustedAccessRoleBindingInner> getAsync(String resourceGroupName, String resourceName, String trustedAccessRoleBindingName) {
        return this.getWithResponseAsync(resourceGroupName, resourceName, trustedAccessRoleBindingName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((TrustedAccessRoleBindingInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<TrustedAccessRoleBindingInner> getWithResponse(String resourceGroupName, String resourceName, String trustedAccessRoleBindingName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, resourceName, trustedAccessRoleBindingName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public TrustedAccessRoleBindingInner get(String resourceGroupName, String resourceName, String trustedAccessRoleBindingName) {
        return (TrustedAccessRoleBindingInner)((Object)this.getWithResponse(resourceGroupName, resourceName, trustedAccessRoleBindingName, Context.NONE).getValue());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String resourceName, String trustedAccessRoleBindingName, TrustedAccessRoleBindingInner trustedAccessRoleBinding) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (trustedAccessRoleBindingName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter trustedAccessRoleBindingName is required and cannot be null."));
        }
        if (trustedAccessRoleBinding == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter trustedAccessRoleBinding is required and cannot be null."));
        }
        trustedAccessRoleBinding.validate();
        String apiVersion = "2024-09-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), "2024-09-01", this.client.getSubscriptionId(), resourceGroupName, resourceName, trustedAccessRoleBindingName, trustedAccessRoleBinding, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String resourceName, String trustedAccessRoleBindingName, TrustedAccessRoleBindingInner trustedAccessRoleBinding, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (trustedAccessRoleBindingName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter trustedAccessRoleBindingName is required and cannot be null."));
        }
        if (trustedAccessRoleBinding == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter trustedAccessRoleBinding is required and cannot be null."));
        }
        trustedAccessRoleBinding.validate();
        String apiVersion = "2024-09-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), "2024-09-01", this.client.getSubscriptionId(), resourceGroupName, resourceName, trustedAccessRoleBindingName, trustedAccessRoleBinding, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<TrustedAccessRoleBindingInner>, TrustedAccessRoleBindingInner> beginCreateOrUpdateAsync(String resourceGroupName, String resourceName, String trustedAccessRoleBindingName, TrustedAccessRoleBindingInner trustedAccessRoleBinding) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, resourceName, trustedAccessRoleBindingName, trustedAccessRoleBinding);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)TrustedAccessRoleBindingInner.class), (Type)((Object)TrustedAccessRoleBindingInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<TrustedAccessRoleBindingInner>, TrustedAccessRoleBindingInner> beginCreateOrUpdateAsync(String resourceGroupName, String resourceName, String trustedAccessRoleBindingName, TrustedAccessRoleBindingInner trustedAccessRoleBinding, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, resourceName, trustedAccessRoleBindingName, trustedAccessRoleBinding, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)TrustedAccessRoleBindingInner.class), (Type)((Object)TrustedAccessRoleBindingInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<TrustedAccessRoleBindingInner>, TrustedAccessRoleBindingInner> beginCreateOrUpdate(String resourceGroupName, String resourceName, String trustedAccessRoleBindingName, TrustedAccessRoleBindingInner trustedAccessRoleBinding) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, resourceName, trustedAccessRoleBindingName, trustedAccessRoleBinding).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<TrustedAccessRoleBindingInner>, TrustedAccessRoleBindingInner> beginCreateOrUpdate(String resourceGroupName, String resourceName, String trustedAccessRoleBindingName, TrustedAccessRoleBindingInner trustedAccessRoleBinding, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, resourceName, trustedAccessRoleBindingName, trustedAccessRoleBinding, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TrustedAccessRoleBindingInner> createOrUpdateAsync(String resourceGroupName, String resourceName, String trustedAccessRoleBindingName, TrustedAccessRoleBindingInner trustedAccessRoleBinding) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, resourceName, trustedAccessRoleBindingName, trustedAccessRoleBinding).last().flatMap(arg_0 -> ((ContainerServiceManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<TrustedAccessRoleBindingInner> createOrUpdateAsync(String resourceGroupName, String resourceName, String trustedAccessRoleBindingName, TrustedAccessRoleBindingInner trustedAccessRoleBinding, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, resourceName, trustedAccessRoleBindingName, trustedAccessRoleBinding, context).last().flatMap(arg_0 -> ((ContainerServiceManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public TrustedAccessRoleBindingInner createOrUpdate(String resourceGroupName, String resourceName, String trustedAccessRoleBindingName, TrustedAccessRoleBindingInner trustedAccessRoleBinding) {
        return (TrustedAccessRoleBindingInner)((Object)this.createOrUpdateAsync(resourceGroupName, resourceName, trustedAccessRoleBindingName, trustedAccessRoleBinding).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public TrustedAccessRoleBindingInner createOrUpdate(String resourceGroupName, String resourceName, String trustedAccessRoleBindingName, TrustedAccessRoleBindingInner trustedAccessRoleBinding, Context context) {
        return (TrustedAccessRoleBindingInner)((Object)this.createOrUpdateAsync(resourceGroupName, resourceName, trustedAccessRoleBindingName, trustedAccessRoleBinding, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String resourceName, String trustedAccessRoleBindingName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (trustedAccessRoleBindingName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter trustedAccessRoleBindingName is required and cannot be null."));
        }
        String apiVersion = "2024-09-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), "2024-09-01", this.client.getSubscriptionId(), resourceGroupName, resourceName, trustedAccessRoleBindingName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String resourceName, String trustedAccessRoleBindingName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (trustedAccessRoleBindingName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter trustedAccessRoleBindingName is required and cannot be null."));
        }
        String apiVersion = "2024-09-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), "2024-09-01", this.client.getSubscriptionId(), resourceGroupName, resourceName, trustedAccessRoleBindingName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String resourceName, String trustedAccessRoleBindingName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, resourceName, trustedAccessRoleBindingName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String resourceName, String trustedAccessRoleBindingName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, resourceName, trustedAccessRoleBindingName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String resourceName, String trustedAccessRoleBindingName) {
        return this.beginDeleteAsync(resourceGroupName, resourceName, trustedAccessRoleBindingName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String resourceName, String trustedAccessRoleBindingName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, resourceName, trustedAccessRoleBindingName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String resourceName, String trustedAccessRoleBindingName) {
        return this.beginDeleteAsync(resourceGroupName, resourceName, trustedAccessRoleBindingName).last().flatMap(arg_0 -> ((ContainerServiceManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String resourceName, String trustedAccessRoleBindingName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, resourceName, trustedAccessRoleBindingName, context).last().flatMap(arg_0 -> ((ContainerServiceManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String resourceName, String trustedAccessRoleBindingName) {
        this.deleteAsync(resourceGroupName, resourceName, trustedAccessRoleBindingName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String resourceName, String trustedAccessRoleBindingName, Context context) {
        this.deleteAsync(resourceGroupName, resourceName, trustedAccessRoleBindingName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<TrustedAccessRoleBindingInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((TrustedAccessRoleBindingListResult)res.getValue()).value(), ((TrustedAccessRoleBindingListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<TrustedAccessRoleBindingInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((TrustedAccessRoleBindingListResult)res.getValue()).value(), ((TrustedAccessRoleBindingListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ContainerServiceMana")
    public static interface TrustedAccessRoleBindingsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}/trustedAccessRoleBindings")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<TrustedAccessRoleBindingListResult>> list(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="resourceName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}/trustedAccessRoleBindings/{trustedAccessRoleBindingName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<TrustedAccessRoleBindingInner>> get(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="resourceName") String var5, @PathParam(value="trustedAccessRoleBindingName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}/trustedAccessRoleBindings/{trustedAccessRoleBindingName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="resourceName") String var5, @PathParam(value="trustedAccessRoleBindingName") String var6, @BodyParam(value="application/json") TrustedAccessRoleBindingInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}/trustedAccessRoleBindings/{trustedAccessRoleBindingName}")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="resourceName") String var5, @PathParam(value="trustedAccessRoleBindingName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<TrustedAccessRoleBindingListResult>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

