// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Details about a user assigned identity.
 */
@Fluent
public class UserAssignedIdentity implements JsonSerializable<UserAssignedIdentity> {
    /*
     * The resource ID of the user assigned identity.
     */
    private String resourceId;

    /*
     * The client ID of the user assigned identity.
     */
    private String clientId;

    /*
     * The object ID of the user assigned identity.
     */
    private String objectId;

    /**
     * Creates an instance of UserAssignedIdentity class.
     */
    public UserAssignedIdentity() {
    }

    /**
     * Get the resourceId property: The resource ID of the user assigned identity.
     * 
     * @return the resourceId value.
     */
    public String resourceId() {
        return this.resourceId;
    }

    /**
     * Set the resourceId property: The resource ID of the user assigned identity.
     * 
     * @param resourceId the resourceId value to set.
     * @return the UserAssignedIdentity object itself.
     */
    public UserAssignedIdentity withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    /**
     * Get the clientId property: The client ID of the user assigned identity.
     * 
     * @return the clientId value.
     */
    public String clientId() {
        return this.clientId;
    }

    /**
     * Set the clientId property: The client ID of the user assigned identity.
     * 
     * @param clientId the clientId value to set.
     * @return the UserAssignedIdentity object itself.
     */
    public UserAssignedIdentity withClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    /**
     * Get the objectId property: The object ID of the user assigned identity.
     * 
     * @return the objectId value.
     */
    public String objectId() {
        return this.objectId;
    }

    /**
     * Set the objectId property: The object ID of the user assigned identity.
     * 
     * @param objectId the objectId value to set.
     * @return the UserAssignedIdentity object itself.
     */
    public UserAssignedIdentity withObjectId(String objectId) {
        this.objectId = objectId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("resourceId", this.resourceId);
        jsonWriter.writeStringField("clientId", this.clientId);
        jsonWriter.writeStringField("objectId", this.objectId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of UserAssignedIdentity from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of UserAssignedIdentity if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the UserAssignedIdentity.
     */
    public static UserAssignedIdentity fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            UserAssignedIdentity deserializedUserAssignedIdentity = new UserAssignedIdentity();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("resourceId".equals(fieldName)) {
                    deserializedUserAssignedIdentity.resourceId = reader.getString();
                } else if ("clientId".equals(fieldName)) {
                    deserializedUserAssignedIdentity.clientId = reader.getString();
                } else if ("objectId".equals(fieldName)) {
                    deserializedUserAssignedIdentity.objectId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedUserAssignedIdentity;
        });
    }
}
