// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The restriction level applied to the cluster's node resource group. If not specified, the default is 'Unrestricted'.
 */
public final class RestrictionLevel extends ExpandableStringEnum<RestrictionLevel> {
    /**
     * Static value Unrestricted for RestrictionLevel.
     */
    public static final RestrictionLevel UNRESTRICTED = fromString("Unrestricted");

    /**
     * Static value ReadOnly for RestrictionLevel.
     */
    public static final RestrictionLevel READ_ONLY = fromString("ReadOnly");

    /**
     * Creates a new instance of RestrictionLevel value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public RestrictionLevel() {
    }

    /**
     * Creates or finds a RestrictionLevel from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding RestrictionLevel.
     */
    public static RestrictionLevel fromString(String name) {
        return fromString(name, RestrictionLevel.class);
    }

    /**
     * Gets known RestrictionLevel values.
     * 
     * @return known RestrictionLevel values.
     */
    public static Collection<RestrictionLevel> values() {
        return values(RestrictionLevel.class);
    }
}
