// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Contains information about orchestrator.
 */
@Fluent
public final class OrchestratorProfile implements JsonSerializable<OrchestratorProfile> {
    /*
     * Orchestrator type.
     */
    private String orchestratorType;

    /*
     * Orchestrator version (major, minor, patch).
     */
    private String orchestratorVersion;

    /*
     * Whether Kubernetes version is currently in preview.
     */
    private Boolean isPreview;

    /**
     * Creates an instance of OrchestratorProfile class.
     */
    public OrchestratorProfile() {
    }

    /**
     * Get the orchestratorType property: Orchestrator type.
     * 
     * @return the orchestratorType value.
     */
    public String orchestratorType() {
        return this.orchestratorType;
    }

    /**
     * Set the orchestratorType property: Orchestrator type.
     * 
     * @param orchestratorType the orchestratorType value to set.
     * @return the OrchestratorProfile object itself.
     */
    public OrchestratorProfile withOrchestratorType(String orchestratorType) {
        this.orchestratorType = orchestratorType;
        return this;
    }

    /**
     * Get the orchestratorVersion property: Orchestrator version (major, minor, patch).
     * 
     * @return the orchestratorVersion value.
     */
    public String orchestratorVersion() {
        return this.orchestratorVersion;
    }

    /**
     * Set the orchestratorVersion property: Orchestrator version (major, minor, patch).
     * 
     * @param orchestratorVersion the orchestratorVersion value to set.
     * @return the OrchestratorProfile object itself.
     */
    public OrchestratorProfile withOrchestratorVersion(String orchestratorVersion) {
        this.orchestratorVersion = orchestratorVersion;
        return this;
    }

    /**
     * Get the isPreview property: Whether Kubernetes version is currently in preview.
     * 
     * @return the isPreview value.
     */
    public Boolean isPreview() {
        return this.isPreview;
    }

    /**
     * Set the isPreview property: Whether Kubernetes version is currently in preview.
     * 
     * @param isPreview the isPreview value to set.
     * @return the OrchestratorProfile object itself.
     */
    public OrchestratorProfile withIsPreview(Boolean isPreview) {
        this.isPreview = isPreview;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (orchestratorVersion() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property orchestratorVersion in model OrchestratorProfile"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(OrchestratorProfile.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("orchestratorVersion", this.orchestratorVersion);
        jsonWriter.writeStringField("orchestratorType", this.orchestratorType);
        jsonWriter.writeBooleanField("isPreview", this.isPreview);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of OrchestratorProfile from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of OrchestratorProfile if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the OrchestratorProfile.
     */
    public static OrchestratorProfile fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            OrchestratorProfile deserializedOrchestratorProfile = new OrchestratorProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("orchestratorVersion".equals(fieldName)) {
                    deserializedOrchestratorProfile.orchestratorVersion = reader.getString();
                } else if ("orchestratorType".equals(fieldName)) {
                    deserializedOrchestratorProfile.orchestratorType = reader.getString();
                } else if ("isPreview".equals(fieldName)) {
                    deserializedOrchestratorProfile.isPreview = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedOrchestratorProfile;
        });
    }
}
