// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The SKU of a Managed Cluster.
 */
@Fluent
public final class ManagedClusterSku implements JsonSerializable<ManagedClusterSku> {
    /*
     * The name of a managed cluster SKU.
     */
    private ManagedClusterSkuName name;

    /*
     * If not specified, the default is 'Free'. See [AKS Pricing
     * Tier](https://learn.microsoft.com/azure/aks/free-standard-pricing-tiers) for more details.
     */
    private ManagedClusterSkuTier tier;

    /**
     * Creates an instance of ManagedClusterSku class.
     */
    public ManagedClusterSku() {
    }

    /**
     * Get the name property: The name of a managed cluster SKU.
     * 
     * @return the name value.
     */
    public ManagedClusterSkuName name() {
        return this.name;
    }

    /**
     * Set the name property: The name of a managed cluster SKU.
     * 
     * @param name the name value to set.
     * @return the ManagedClusterSku object itself.
     */
    public ManagedClusterSku withName(ManagedClusterSkuName name) {
        this.name = name;
        return this;
    }

    /**
     * Get the tier property: If not specified, the default is 'Free'. See [AKS Pricing
     * Tier](https://learn.microsoft.com/azure/aks/free-standard-pricing-tiers) for more details.
     * 
     * @return the tier value.
     */
    public ManagedClusterSkuTier tier() {
        return this.tier;
    }

    /**
     * Set the tier property: If not specified, the default is 'Free'. See [AKS Pricing
     * Tier](https://learn.microsoft.com/azure/aks/free-standard-pricing-tiers) for more details.
     * 
     * @param tier the tier value to set.
     * @return the ManagedClusterSku object itself.
     */
    public ManagedClusterSku withTier(ManagedClusterSkuTier tier) {
        this.tier = tier;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name == null ? null : this.name.toString());
        jsonWriter.writeStringField("tier", this.tier == null ? null : this.tier.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagedClusterSku from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagedClusterSku if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ManagedClusterSku.
     */
    public static ManagedClusterSku fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedClusterSku deserializedManagedClusterSku = new ManagedClusterSku();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedManagedClusterSku.name = ManagedClusterSkuName.fromString(reader.getString());
                } else if ("tier".equals(fieldName)) {
                    deserializedManagedClusterSku.tier = ManagedClusterSkuTier.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagedClusterSku;
        });
    }
}
