// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The metrics profile for the ManagedCluster.
 */
@Fluent
public final class ManagedClusterMetricsProfile implements JsonSerializable<ManagedClusterMetricsProfile> {
    /*
     * The cost analysis configuration for the cluster
     */
    private ManagedClusterCostAnalysis costAnalysis;

    /**
     * Creates an instance of ManagedClusterMetricsProfile class.
     */
    public ManagedClusterMetricsProfile() {
    }

    /**
     * Get the costAnalysis property: The cost analysis configuration for the cluster.
     * 
     * @return the costAnalysis value.
     */
    public ManagedClusterCostAnalysis costAnalysis() {
        return this.costAnalysis;
    }

    /**
     * Set the costAnalysis property: The cost analysis configuration for the cluster.
     * 
     * @param costAnalysis the costAnalysis value to set.
     * @return the ManagedClusterMetricsProfile object itself.
     */
    public ManagedClusterMetricsProfile withCostAnalysis(ManagedClusterCostAnalysis costAnalysis) {
        this.costAnalysis = costAnalysis;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (costAnalysis() != null) {
            costAnalysis().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("costAnalysis", this.costAnalysis);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagedClusterMetricsProfile from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagedClusterMetricsProfile if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ManagedClusterMetricsProfile.
     */
    public static ManagedClusterMetricsProfile fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedClusterMetricsProfile deserializedManagedClusterMetricsProfile = new ManagedClusterMetricsProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("costAnalysis".equals(fieldName)) {
                    deserializedManagedClusterMetricsProfile.costAnalysis = ManagedClusterCostAnalysis.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagedClusterMetricsProfile;
        });
    }
}
