// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Specifies a list of machine names from the agent pool to be deleted.
 */
@Fluent
public final class AgentPoolDeleteMachinesParameter implements JsonSerializable<AgentPoolDeleteMachinesParameter> {
    /*
     * The agent pool machine names.
     */
    private List<String> machineNames;

    /**
     * Creates an instance of AgentPoolDeleteMachinesParameter class.
     */
    public AgentPoolDeleteMachinesParameter() {
    }

    /**
     * Get the machineNames property: The agent pool machine names.
     * 
     * @return the machineNames value.
     */
    public List<String> machineNames() {
        return this.machineNames;
    }

    /**
     * Set the machineNames property: The agent pool machine names.
     * 
     * @param machineNames the machineNames value to set.
     * @return the AgentPoolDeleteMachinesParameter object itself.
     */
    public AgentPoolDeleteMachinesParameter withMachineNames(List<String> machineNames) {
        this.machineNames = machineNames;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (machineNames() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property machineNames in model AgentPoolDeleteMachinesParameter"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(AgentPoolDeleteMachinesParameter.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("machineNames", this.machineNames, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AgentPoolDeleteMachinesParameter from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AgentPoolDeleteMachinesParameter if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AgentPoolDeleteMachinesParameter.
     */
    public static AgentPoolDeleteMachinesParameter fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AgentPoolDeleteMachinesParameter deserializedAgentPoolDeleteMachinesParameter
                = new AgentPoolDeleteMachinesParameter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("machineNames".equals(fieldName)) {
                    List<String> machineNames = reader.readArray(reader1 -> reader1.getString());
                    deserializedAgentPoolDeleteMachinesParameter.machineNames = machineNames;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAgentPoolDeleteMachinesParameter;
        });
    }
}
