/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservice.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class RunCommandRequest
implements JsonSerializable<RunCommandRequest> {
    private String command;
    private String context;
    private String clusterToken;
    private static final ClientLogger LOGGER = new ClientLogger(RunCommandRequest.class);

    public String command() {
        return this.command;
    }

    public RunCommandRequest withCommand(String command) {
        this.command = command;
        return this;
    }

    public String context() {
        return this.context;
    }

    public RunCommandRequest withContext(String context) {
        this.context = context;
        return this;
    }

    public String clusterToken() {
        return this.clusterToken;
    }

    public RunCommandRequest withClusterToken(String clusterToken) {
        this.clusterToken = clusterToken;
        return this;
    }

    public void validate() {
        if (this.command() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property command in model RunCommandRequest"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("command", this.command);
        jsonWriter.writeStringField("context", this.context);
        jsonWriter.writeStringField("clusterToken", this.clusterToken);
        return jsonWriter.writeEndObject();
    }

    public static RunCommandRequest fromJson(JsonReader jsonReader) throws IOException {
        return (RunCommandRequest)jsonReader.readObject(reader -> {
            RunCommandRequest deserializedRunCommandRequest = new RunCommandRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("command".equals(fieldName)) {
                    deserializedRunCommandRequest.command = reader.getString();
                    continue;
                }
                if ("context".equals(fieldName)) {
                    deserializedRunCommandRequest.context = reader.getString();
                    continue;
                }
                if ("clusterToken".equals(fieldName)) {
                    deserializedRunCommandRequest.clusterToken = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRunCommandRequest;
        });
    }
}

