/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerservice.models.CompatibleVersions;
import com.azure.resourcemanager.containerservice.models.MeshRevision;
import java.io.IOException;
import java.util.List;

public final class MeshUpgradeProfileProperties
extends MeshRevision {
    @Override
    public MeshUpgradeProfileProperties withRevision(String revision) {
        super.withRevision(revision);
        return this;
    }

    @Override
    public MeshUpgradeProfileProperties withUpgrades(List<String> upgrades) {
        super.withUpgrades(upgrades);
        return this;
    }

    @Override
    public MeshUpgradeProfileProperties withCompatibleWith(List<CompatibleVersions> compatibleWith) {
        super.withCompatibleWith(compatibleWith);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("revision", this.revision());
        jsonWriter.writeArrayField("upgrades", this.upgrades(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("compatibleWith", this.compatibleWith(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static MeshUpgradeProfileProperties fromJson(JsonReader jsonReader) throws IOException {
        return (MeshUpgradeProfileProperties)jsonReader.readObject(reader -> {
            MeshUpgradeProfileProperties deserializedMeshUpgradeProfileProperties = new MeshUpgradeProfileProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("revision".equals(fieldName)) {
                    deserializedMeshUpgradeProfileProperties.withRevision(reader.getString());
                    continue;
                }
                if ("upgrades".equals(fieldName)) {
                    List upgrades = reader.readArray(reader1 -> reader1.getString());
                    deserializedMeshUpgradeProfileProperties.withUpgrades(upgrades);
                    continue;
                }
                if ("compatibleWith".equals(fieldName)) {
                    List compatibleWith = reader.readArray(reader1 -> CompatibleVersions.fromJson(reader1));
                    deserializedMeshUpgradeProfileProperties.withCompatibleWith(compatibleWith);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMeshUpgradeProfileProperties;
        });
    }
}

