// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Windows gMSA Profile in the managed cluster.
 */
@Fluent
public final class WindowsGmsaProfile implements JsonSerializable<WindowsGmsaProfile> {
    /*
     * Specifies whether to enable Windows gMSA in the managed cluster.
     */
    private Boolean enabled;

    /*
     * Specifies the DNS server for Windows gMSA. <br><br> Set it to empty if you have configured the DNS server in the
     * vnet which is used to create the managed cluster.
     */
    private String dnsServer;

    /*
     * Specifies the root domain name for Windows gMSA. <br><br> Set it to empty if you have configured the DNS server
     * in the vnet which is used to create the managed cluster.
     */
    private String rootDomainName;

    /**
     * Creates an instance of WindowsGmsaProfile class.
     */
    public WindowsGmsaProfile() {
    }

    /**
     * Get the enabled property: Specifies whether to enable Windows gMSA in the managed cluster.
     * 
     * @return the enabled value.
     */
    public Boolean enabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: Specifies whether to enable Windows gMSA in the managed cluster.
     * 
     * @param enabled the enabled value to set.
     * @return the WindowsGmsaProfile object itself.
     */
    public WindowsGmsaProfile withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Get the dnsServer property: Specifies the DNS server for Windows gMSA. &lt;br&gt;&lt;br&gt; Set it to empty if
     * you have configured the DNS server in the vnet which is used to create the managed cluster.
     * 
     * @return the dnsServer value.
     */
    public String dnsServer() {
        return this.dnsServer;
    }

    /**
     * Set the dnsServer property: Specifies the DNS server for Windows gMSA. &lt;br&gt;&lt;br&gt; Set it to empty if
     * you have configured the DNS server in the vnet which is used to create the managed cluster.
     * 
     * @param dnsServer the dnsServer value to set.
     * @return the WindowsGmsaProfile object itself.
     */
    public WindowsGmsaProfile withDnsServer(String dnsServer) {
        this.dnsServer = dnsServer;
        return this;
    }

    /**
     * Get the rootDomainName property: Specifies the root domain name for Windows gMSA. &lt;br&gt;&lt;br&gt; Set it to
     * empty if you have configured the DNS server in the vnet which is used to create the managed cluster.
     * 
     * @return the rootDomainName value.
     */
    public String rootDomainName() {
        return this.rootDomainName;
    }

    /**
     * Set the rootDomainName property: Specifies the root domain name for Windows gMSA. &lt;br&gt;&lt;br&gt; Set it to
     * empty if you have configured the DNS server in the vnet which is used to create the managed cluster.
     * 
     * @param rootDomainName the rootDomainName value to set.
     * @return the WindowsGmsaProfile object itself.
     */
    public WindowsGmsaProfile withRootDomainName(String rootDomainName) {
        this.rootDomainName = rootDomainName;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeStringField("dnsServer", this.dnsServer);
        jsonWriter.writeStringField("rootDomainName", this.rootDomainName);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of WindowsGmsaProfile from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of WindowsGmsaProfile if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the WindowsGmsaProfile.
     */
    public static WindowsGmsaProfile fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            WindowsGmsaProfile deserializedWindowsGmsaProfile = new WindowsGmsaProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("enabled".equals(fieldName)) {
                    deserializedWindowsGmsaProfile.enabled = reader.getNullable(JsonReader::getBoolean);
                } else if ("dnsServer".equals(fieldName)) {
                    deserializedWindowsGmsaProfile.dnsServer = reader.getString();
                } else if ("rootDomainName".equals(fieldName)) {
                    deserializedWindowsGmsaProfile.rootDomainName = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedWindowsGmsaProfile;
        });
    }
}
