// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerservice.fluent.models.TrustedAccessRoleInner;
import java.io.IOException;
import java.util.List;

/**
 * List of trusted access roles.
 */
@Immutable
public final class TrustedAccessRoleListResult implements JsonSerializable<TrustedAccessRoleListResult> {
    /*
     * Role list
     */
    private List<TrustedAccessRoleInner> value;

    /*
     * Link to next page of resources.
     */
    private String nextLink;

    /**
     * Creates an instance of TrustedAccessRoleListResult class.
     */
    public TrustedAccessRoleListResult() {
    }

    /**
     * Get the value property: Role list.
     * 
     * @return the value value.
     */
    public List<TrustedAccessRoleInner> value() {
        return this.value;
    }

    /**
     * Get the nextLink property: Link to next page of resources.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TrustedAccessRoleListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TrustedAccessRoleListResult if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the TrustedAccessRoleListResult.
     */
    public static TrustedAccessRoleListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TrustedAccessRoleListResult deserializedTrustedAccessRoleListResult = new TrustedAccessRoleListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<TrustedAccessRoleInner> value
                        = reader.readArray(reader1 -> TrustedAccessRoleInner.fromJson(reader1));
                    deserializedTrustedAccessRoleListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedTrustedAccessRoleListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTrustedAccessRoleListResult;
        });
    }
}
