// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerservice.models.TrustedAccessRoleBindingProvisioningState;
import java.io.IOException;
import java.util.List;

/**
 * Defines binding between a resource and role.
 */
@Fluent
public final class TrustedAccessRoleBindingInner extends ProxyResource {
    /*
     * Properties for trusted access role binding
     */
    private TrustedAccessRoleBindingProperties innerProperties = new TrustedAccessRoleBindingProperties();

    /*
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    private SystemData systemData;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * The type of the resource.
     */
    private String type;

    /**
     * Creates an instance of TrustedAccessRoleBindingInner class.
     */
    public TrustedAccessRoleBindingInner() {
    }

    /**
     * Get the innerProperties property: Properties for trusted access role binding.
     * 
     * @return the innerProperties value.
     */
    private TrustedAccessRoleBindingProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the systemData property: Azure Resource Manager metadata containing createdBy and modifiedBy information.
     * 
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the provisioningState property: The current provisioning state of trusted access role binding.
     * 
     * @return the provisioningState value.
     */
    public TrustedAccessRoleBindingProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the sourceResourceId property: The ARM resource ID of source resource that trusted access is configured for.
     * 
     * @return the sourceResourceId value.
     */
    public String sourceResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().sourceResourceId();
    }

    /**
     * Set the sourceResourceId property: The ARM resource ID of source resource that trusted access is configured for.
     * 
     * @param sourceResourceId the sourceResourceId value to set.
     * @return the TrustedAccessRoleBindingInner object itself.
     */
    public TrustedAccessRoleBindingInner withSourceResourceId(String sourceResourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TrustedAccessRoleBindingProperties();
        }
        this.innerProperties().withSourceResourceId(sourceResourceId);
        return this;
    }

    /**
     * Get the roles property: A list of roles to bind, each item is a resource type qualified role name. For example:
     * 'Microsoft.MachineLearningServices/workspaces/reader'.
     * 
     * @return the roles value.
     */
    public List<String> roles() {
        return this.innerProperties() == null ? null : this.innerProperties().roles();
    }

    /**
     * Set the roles property: A list of roles to bind, each item is a resource type qualified role name. For example:
     * 'Microsoft.MachineLearningServices/workspaces/reader'.
     * 
     * @param roles the roles value to set.
     * @return the TrustedAccessRoleBindingInner object itself.
     */
    public TrustedAccessRoleBindingInner withRoles(List<String> roles) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TrustedAccessRoleBindingProperties();
        }
        this.innerProperties().withRoles(roles);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property innerProperties in model TrustedAccessRoleBindingInner"));
        } else {
            innerProperties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(TrustedAccessRoleBindingInner.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TrustedAccessRoleBindingInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TrustedAccessRoleBindingInner if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the TrustedAccessRoleBindingInner.
     */
    public static TrustedAccessRoleBindingInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TrustedAccessRoleBindingInner deserializedTrustedAccessRoleBindingInner
                = new TrustedAccessRoleBindingInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedTrustedAccessRoleBindingInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedTrustedAccessRoleBindingInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedTrustedAccessRoleBindingInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedTrustedAccessRoleBindingInner.innerProperties
                        = TrustedAccessRoleBindingProperties.fromJson(reader);
                } else if ("systemData".equals(fieldName)) {
                    deserializedTrustedAccessRoleBindingInner.systemData = SystemData.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTrustedAccessRoleBindingInner;
        });
    }
}
