// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerservice.models.ClusterUpgradeSettings;
import com.azure.resourcemanager.containerservice.models.ContainerServiceLinuxProfile;
import com.azure.resourcemanager.containerservice.models.ContainerServiceNetworkProfile;
import com.azure.resourcemanager.containerservice.models.KubernetesSupportPlan;
import com.azure.resourcemanager.containerservice.models.ManagedClusterAadProfile;
import com.azure.resourcemanager.containerservice.models.ManagedClusterAddonProfile;
import com.azure.resourcemanager.containerservice.models.ManagedClusterAgentPoolProfile;
import com.azure.resourcemanager.containerservice.models.ManagedClusterApiServerAccessProfile;
import com.azure.resourcemanager.containerservice.models.ManagedClusterAutoUpgradeProfile;
import com.azure.resourcemanager.containerservice.models.ManagedClusterAzureMonitorProfile;
import com.azure.resourcemanager.containerservice.models.ManagedClusterHttpProxyConfig;
import com.azure.resourcemanager.containerservice.models.ManagedClusterIngressProfile;
import com.azure.resourcemanager.containerservice.models.ManagedClusterMetricsProfile;
import com.azure.resourcemanager.containerservice.models.ManagedClusterOidcIssuerProfile;
import com.azure.resourcemanager.containerservice.models.ManagedClusterPodIdentityProfile;
import com.azure.resourcemanager.containerservice.models.ManagedClusterPropertiesAutoScalerProfile;
import com.azure.resourcemanager.containerservice.models.ManagedClusterSecurityProfile;
import com.azure.resourcemanager.containerservice.models.ManagedClusterServicePrincipalProfile;
import com.azure.resourcemanager.containerservice.models.ManagedClusterStorageProfile;
import com.azure.resourcemanager.containerservice.models.ManagedClusterWindowsProfile;
import com.azure.resourcemanager.containerservice.models.ManagedClusterWorkloadAutoScalerProfile;
import com.azure.resourcemanager.containerservice.models.PowerState;
import com.azure.resourcemanager.containerservice.models.PublicNetworkAccess;
import com.azure.resourcemanager.containerservice.models.ServiceMeshProfile;
import com.azure.resourcemanager.containerservice.models.UserAssignedIdentity;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * Properties of the managed cluster.
 */
@Fluent
public final class ManagedClusterProperties implements JsonSerializable<ManagedClusterProperties> {
    /*
     * The current provisioning state.
     */
    private String provisioningState;

    /*
     * The Power State of the cluster.
     */
    private PowerState powerState;

    /*
     * The max number of agent pools for the managed cluster.
     */
    private Integer maxAgentPools;

    /*
     * Both patch version <major.minor.patch> (e.g. 1.20.13) and <major.minor> (e.g. 1.20) are supported. When
     * <major.minor> is specified, the latest supported GA patch version is chosen automatically. Updating the cluster
     * with the same <major.minor> once it has been created (e.g. 1.14.x -> 1.14) will not trigger an upgrade, even if a
     * newer patch version is available. When you upgrade a supported AKS cluster, Kubernetes minor versions cannot be
     * skipped. All upgrades must be performed sequentially by major version number. For example, upgrades between
     * 1.14.x -> 1.15.x or 1.15.x -> 1.16.x are allowed, however 1.14.x -> 1.16.x is not allowed. See [upgrading an AKS
     * cluster](https://docs.microsoft.com/azure/aks/upgrade-cluster) for more details.
     */
    private String kubernetesVersion;

    /*
     * If kubernetesVersion was a fully specified version <major.minor.patch>, this field will be exactly equal to it.
     * If kubernetesVersion was <major.minor>, this field will contain the full <major.minor.patch> version being used.
     */
    private String currentKubernetesVersion;

    /*
     * This cannot be updated once the Managed Cluster has been created.
     */
    private String dnsPrefix;

    /*
     * This cannot be updated once the Managed Cluster has been created.
     */
    private String fqdnSubdomain;

    /*
     * The FQDN of the master pool.
     */
    private String fqdn;

    /*
     * The FQDN of private cluster.
     */
    private String privateFqdn;

    /*
     * The Azure Portal requires certain Cross-Origin Resource Sharing (CORS) headers to be sent in some responses,
     * which Kubernetes APIServer doesn't handle by default. This special FQDN supports CORS, allowing the Azure Portal
     * to function properly.
     */
    private String azurePortalFqdn;

    /*
     * The agent pool properties.
     */
    private List<ManagedClusterAgentPoolProfile> agentPoolProfiles;

    /*
     * The profile for Linux VMs in the Managed Cluster.
     */
    private ContainerServiceLinuxProfile linuxProfile;

    /*
     * The profile for Windows VMs in the Managed Cluster.
     */
    private ManagedClusterWindowsProfile windowsProfile;

    /*
     * Information about a service principal identity for the cluster to use for manipulating Azure APIs.
     */
    private ManagedClusterServicePrincipalProfile servicePrincipalProfile;

    /*
     * The profile of managed cluster add-on.
     */
    private Map<String, ManagedClusterAddonProfile> addonProfiles;

    /*
     * See [use AAD pod identity](https://docs.microsoft.com/azure/aks/use-azure-ad-pod-identity) for more details on
     * AAD pod identity integration.
     */
    private ManagedClusterPodIdentityProfile podIdentityProfile;

    /*
     * The OIDC issuer profile of the Managed Cluster.
     */
    private ManagedClusterOidcIssuerProfile oidcIssuerProfile;

    /*
     * The name of the resource group containing agent pool nodes.
     */
    private String nodeResourceGroup;

    /*
     * Whether to enable Kubernetes Role-Based Access Control.
     */
    private Boolean enableRbac;

    /*
     * The support plan for the Managed Cluster. If unspecified, the default is 'KubernetesOfficial'.
     */
    private KubernetesSupportPlan supportPlan;

    /*
     * (DEPRECATED) Whether to enable Kubernetes pod security policy (preview). PodSecurityPolicy was deprecated in
     * Kubernetes v1.21, and removed from Kubernetes in v1.25. Learn more at https://aka.ms/k8s/psp and
     * https://aka.ms/aks/psp.
     */
    private Boolean enablePodSecurityPolicy;

    /*
     * The network configuration profile.
     */
    private ContainerServiceNetworkProfile networkProfile;

    /*
     * The Azure Active Directory configuration.
     */
    private ManagedClusterAadProfile aadProfile;

    /*
     * The auto upgrade configuration.
     */
    private ManagedClusterAutoUpgradeProfile autoUpgradeProfile;

    /*
     * Settings for upgrading a cluster.
     */
    private ClusterUpgradeSettings upgradeSettings;

    /*
     * Parameters to be applied to the cluster-autoscaler when enabled
     */
    private ManagedClusterPropertiesAutoScalerProfile autoScalerProfile;

    /*
     * The access profile for managed cluster API server.
     */
    private ManagedClusterApiServerAccessProfile apiServerAccessProfile;

    /*
     * This is of the form:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/
     * diskEncryptionSets/{encryptionSetName}'
     */
    private String diskEncryptionSetId;

    /*
     * Identities associated with the cluster.
     */
    private Map<String, UserAssignedIdentity> identityProfile;

    /*
     * Private link resources associated with the cluster.
     */
    private List<PrivateLinkResourceInner> privateLinkResources;

    /*
     * If set to true, getting static credentials will be disabled for this cluster. This must only be used on Managed
     * Clusters that are AAD enabled. For more details see [disable local
     * accounts](https://docs.microsoft.com/azure/aks/managed-aad#disable-local-accounts-preview).
     */
    private Boolean disableLocalAccounts;

    /*
     * Configurations for provisioning the cluster with HTTP proxy servers.
     */
    private ManagedClusterHttpProxyConfig httpProxyConfig;

    /*
     * Security profile for the managed cluster.
     */
    private ManagedClusterSecurityProfile securityProfile;

    /*
     * Storage profile for the managed cluster.
     */
    private ManagedClusterStorageProfile storageProfile;

    /*
     * Ingress profile for the managed cluster.
     */
    private ManagedClusterIngressProfile ingressProfile;

    /*
     * Allow or deny public network access for AKS
     */
    private PublicNetworkAccess publicNetworkAccess;

    /*
     * Workload Auto-scaler profile for the managed cluster.
     */
    private ManagedClusterWorkloadAutoScalerProfile workloadAutoScalerProfile;

    /*
     * Azure Monitor addon profiles for monitoring the managed cluster.
     */
    private ManagedClusterAzureMonitorProfile azureMonitorProfile;

    /*
     * Service mesh profile for a managed cluster.
     */
    private ServiceMeshProfile serviceMeshProfile;

    /*
     * The resourceUID uniquely identifies ManagedClusters that reuse ARM ResourceIds (i.e: create, delete, create
     * sequence)
     */
    private String resourceUid;

    /*
     * Optional cluster metrics configuration.
     */
    private ManagedClusterMetricsProfile metricsProfile;

    /**
     * Creates an instance of ManagedClusterProperties class.
     */
    public ManagedClusterProperties() {
    }

    /**
     * Get the provisioningState property: The current provisioning state.
     * 
     * @return the provisioningState value.
     */
    public String provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the powerState property: The Power State of the cluster.
     * 
     * @return the powerState value.
     */
    public PowerState powerState() {
        return this.powerState;
    }

    /**
     * Get the maxAgentPools property: The max number of agent pools for the managed cluster.
     * 
     * @return the maxAgentPools value.
     */
    public Integer maxAgentPools() {
        return this.maxAgentPools;
    }

    /**
     * Get the kubernetesVersion property: Both patch version &lt;major.minor.patch&gt; (e.g. 1.20.13) and
     * &lt;major.minor&gt; (e.g. 1.20) are supported. When &lt;major.minor&gt; is specified, the latest supported GA
     * patch version is chosen automatically. Updating the cluster with the same &lt;major.minor&gt; once it has been
     * created (e.g. 1.14.x -&gt; 1.14) will not trigger an upgrade, even if a newer patch version is available. When
     * you upgrade a supported AKS cluster, Kubernetes minor versions cannot be skipped. All upgrades must be performed
     * sequentially by major version number. For example, upgrades between 1.14.x -&gt; 1.15.x or 1.15.x -&gt; 1.16.x
     * are allowed, however 1.14.x -&gt; 1.16.x is not allowed. See [upgrading an AKS
     * cluster](https://docs.microsoft.com/azure/aks/upgrade-cluster) for more details.
     * 
     * @return the kubernetesVersion value.
     */
    public String kubernetesVersion() {
        return this.kubernetesVersion;
    }

    /**
     * Set the kubernetesVersion property: Both patch version &lt;major.minor.patch&gt; (e.g. 1.20.13) and
     * &lt;major.minor&gt; (e.g. 1.20) are supported. When &lt;major.minor&gt; is specified, the latest supported GA
     * patch version is chosen automatically. Updating the cluster with the same &lt;major.minor&gt; once it has been
     * created (e.g. 1.14.x -&gt; 1.14) will not trigger an upgrade, even if a newer patch version is available. When
     * you upgrade a supported AKS cluster, Kubernetes minor versions cannot be skipped. All upgrades must be performed
     * sequentially by major version number. For example, upgrades between 1.14.x -&gt; 1.15.x or 1.15.x -&gt; 1.16.x
     * are allowed, however 1.14.x -&gt; 1.16.x is not allowed. See [upgrading an AKS
     * cluster](https://docs.microsoft.com/azure/aks/upgrade-cluster) for more details.
     * 
     * @param kubernetesVersion the kubernetesVersion value to set.
     * @return the ManagedClusterProperties object itself.
     */
    public ManagedClusterProperties withKubernetesVersion(String kubernetesVersion) {
        this.kubernetesVersion = kubernetesVersion;
        return this;
    }

    /**
     * Get the currentKubernetesVersion property: If kubernetesVersion was a fully specified version
     * &lt;major.minor.patch&gt;, this field will be exactly equal to it. If kubernetesVersion was &lt;major.minor&gt;,
     * this field will contain the full &lt;major.minor.patch&gt; version being used.
     * 
     * @return the currentKubernetesVersion value.
     */
    public String currentKubernetesVersion() {
        return this.currentKubernetesVersion;
    }

    /**
     * Get the dnsPrefix property: This cannot be updated once the Managed Cluster has been created.
     * 
     * @return the dnsPrefix value.
     */
    public String dnsPrefix() {
        return this.dnsPrefix;
    }

    /**
     * Set the dnsPrefix property: This cannot be updated once the Managed Cluster has been created.
     * 
     * @param dnsPrefix the dnsPrefix value to set.
     * @return the ManagedClusterProperties object itself.
     */
    public ManagedClusterProperties withDnsPrefix(String dnsPrefix) {
        this.dnsPrefix = dnsPrefix;
        return this;
    }

    /**
     * Get the fqdnSubdomain property: This cannot be updated once the Managed Cluster has been created.
     * 
     * @return the fqdnSubdomain value.
     */
    public String fqdnSubdomain() {
        return this.fqdnSubdomain;
    }

    /**
     * Set the fqdnSubdomain property: This cannot be updated once the Managed Cluster has been created.
     * 
     * @param fqdnSubdomain the fqdnSubdomain value to set.
     * @return the ManagedClusterProperties object itself.
     */
    public ManagedClusterProperties withFqdnSubdomain(String fqdnSubdomain) {
        this.fqdnSubdomain = fqdnSubdomain;
        return this;
    }

    /**
     * Get the fqdn property: The FQDN of the master pool.
     * 
     * @return the fqdn value.
     */
    public String fqdn() {
        return this.fqdn;
    }

    /**
     * Get the privateFqdn property: The FQDN of private cluster.
     * 
     * @return the privateFqdn value.
     */
    public String privateFqdn() {
        return this.privateFqdn;
    }

    /**
     * Get the azurePortalFqdn property: The Azure Portal requires certain Cross-Origin Resource Sharing (CORS) headers
     * to be sent in some responses, which Kubernetes APIServer doesn't handle by default. This special FQDN supports
     * CORS, allowing the Azure Portal to function properly.
     * 
     * @return the azurePortalFqdn value.
     */
    public String azurePortalFqdn() {
        return this.azurePortalFqdn;
    }

    /**
     * Get the agentPoolProfiles property: The agent pool properties.
     * 
     * @return the agentPoolProfiles value.
     */
    public List<ManagedClusterAgentPoolProfile> agentPoolProfiles() {
        return this.agentPoolProfiles;
    }

    /**
     * Set the agentPoolProfiles property: The agent pool properties.
     * 
     * @param agentPoolProfiles the agentPoolProfiles value to set.
     * @return the ManagedClusterProperties object itself.
     */
    public ManagedClusterProperties withAgentPoolProfiles(List<ManagedClusterAgentPoolProfile> agentPoolProfiles) {
        this.agentPoolProfiles = agentPoolProfiles;
        return this;
    }

    /**
     * Get the linuxProfile property: The profile for Linux VMs in the Managed Cluster.
     * 
     * @return the linuxProfile value.
     */
    public ContainerServiceLinuxProfile linuxProfile() {
        return this.linuxProfile;
    }

    /**
     * Set the linuxProfile property: The profile for Linux VMs in the Managed Cluster.
     * 
     * @param linuxProfile the linuxProfile value to set.
     * @return the ManagedClusterProperties object itself.
     */
    public ManagedClusterProperties withLinuxProfile(ContainerServiceLinuxProfile linuxProfile) {
        this.linuxProfile = linuxProfile;
        return this;
    }

    /**
     * Get the windowsProfile property: The profile for Windows VMs in the Managed Cluster.
     * 
     * @return the windowsProfile value.
     */
    public ManagedClusterWindowsProfile windowsProfile() {
        return this.windowsProfile;
    }

    /**
     * Set the windowsProfile property: The profile for Windows VMs in the Managed Cluster.
     * 
     * @param windowsProfile the windowsProfile value to set.
     * @return the ManagedClusterProperties object itself.
     */
    public ManagedClusterProperties withWindowsProfile(ManagedClusterWindowsProfile windowsProfile) {
        this.windowsProfile = windowsProfile;
        return this;
    }

    /**
     * Get the servicePrincipalProfile property: Information about a service principal identity for the cluster to use
     * for manipulating Azure APIs.
     * 
     * @return the servicePrincipalProfile value.
     */
    public ManagedClusterServicePrincipalProfile servicePrincipalProfile() {
        return this.servicePrincipalProfile;
    }

    /**
     * Set the servicePrincipalProfile property: Information about a service principal identity for the cluster to use
     * for manipulating Azure APIs.
     * 
     * @param servicePrincipalProfile the servicePrincipalProfile value to set.
     * @return the ManagedClusterProperties object itself.
     */
    public ManagedClusterProperties
        withServicePrincipalProfile(ManagedClusterServicePrincipalProfile servicePrincipalProfile) {
        this.servicePrincipalProfile = servicePrincipalProfile;
        return this;
    }

    /**
     * Get the addonProfiles property: The profile of managed cluster add-on.
     * 
     * @return the addonProfiles value.
     */
    public Map<String, ManagedClusterAddonProfile> addonProfiles() {
        return this.addonProfiles;
    }

    /**
     * Set the addonProfiles property: The profile of managed cluster add-on.
     * 
     * @param addonProfiles the addonProfiles value to set.
     * @return the ManagedClusterProperties object itself.
     */
    public ManagedClusterProperties withAddonProfiles(Map<String, ManagedClusterAddonProfile> addonProfiles) {
        this.addonProfiles = addonProfiles;
        return this;
    }

    /**
     * Get the podIdentityProfile property: See [use AAD pod
     * identity](https://docs.microsoft.com/azure/aks/use-azure-ad-pod-identity) for more details on AAD pod identity
     * integration.
     * 
     * @return the podIdentityProfile value.
     */
    public ManagedClusterPodIdentityProfile podIdentityProfile() {
        return this.podIdentityProfile;
    }

    /**
     * Set the podIdentityProfile property: See [use AAD pod
     * identity](https://docs.microsoft.com/azure/aks/use-azure-ad-pod-identity) for more details on AAD pod identity
     * integration.
     * 
     * @param podIdentityProfile the podIdentityProfile value to set.
     * @return the ManagedClusterProperties object itself.
     */
    public ManagedClusterProperties withPodIdentityProfile(ManagedClusterPodIdentityProfile podIdentityProfile) {
        this.podIdentityProfile = podIdentityProfile;
        return this;
    }

    /**
     * Get the oidcIssuerProfile property: The OIDC issuer profile of the Managed Cluster.
     * 
     * @return the oidcIssuerProfile value.
     */
    public ManagedClusterOidcIssuerProfile oidcIssuerProfile() {
        return this.oidcIssuerProfile;
    }

    /**
     * Set the oidcIssuerProfile property: The OIDC issuer profile of the Managed Cluster.
     * 
     * @param oidcIssuerProfile the oidcIssuerProfile value to set.
     * @return the ManagedClusterProperties object itself.
     */
    public ManagedClusterProperties withOidcIssuerProfile(ManagedClusterOidcIssuerProfile oidcIssuerProfile) {
        this.oidcIssuerProfile = oidcIssuerProfile;
        return this;
    }

    /**
     * Get the nodeResourceGroup property: The name of the resource group containing agent pool nodes.
     * 
     * @return the nodeResourceGroup value.
     */
    public String nodeResourceGroup() {
        return this.nodeResourceGroup;
    }

    /**
     * Set the nodeResourceGroup property: The name of the resource group containing agent pool nodes.
     * 
     * @param nodeResourceGroup the nodeResourceGroup value to set.
     * @return the ManagedClusterProperties object itself.
     */
    public ManagedClusterProperties withNodeResourceGroup(String nodeResourceGroup) {
        this.nodeResourceGroup = nodeResourceGroup;
        return this;
    }

    /**
     * Get the enableRbac property: Whether to enable Kubernetes Role-Based Access Control.
     * 
     * @return the enableRbac value.
     */
    public Boolean enableRbac() {
        return this.enableRbac;
    }

    /**
     * Set the enableRbac property: Whether to enable Kubernetes Role-Based Access Control.
     * 
     * @param enableRbac the enableRbac value to set.
     * @return the ManagedClusterProperties object itself.
     */
    public ManagedClusterProperties withEnableRbac(Boolean enableRbac) {
        this.enableRbac = enableRbac;
        return this;
    }

    /**
     * Get the supportPlan property: The support plan for the Managed Cluster. If unspecified, the default is
     * 'KubernetesOfficial'.
     * 
     * @return the supportPlan value.
     */
    public KubernetesSupportPlan supportPlan() {
        return this.supportPlan;
    }

    /**
     * Set the supportPlan property: The support plan for the Managed Cluster. If unspecified, the default is
     * 'KubernetesOfficial'.
     * 
     * @param supportPlan the supportPlan value to set.
     * @return the ManagedClusterProperties object itself.
     */
    public ManagedClusterProperties withSupportPlan(KubernetesSupportPlan supportPlan) {
        this.supportPlan = supportPlan;
        return this;
    }

    /**
     * Get the enablePodSecurityPolicy property: (DEPRECATED) Whether to enable Kubernetes pod security policy
     * (preview). PodSecurityPolicy was deprecated in Kubernetes v1.21, and removed from Kubernetes in v1.25. Learn more
     * at https://aka.ms/k8s/psp and https://aka.ms/aks/psp.
     * 
     * @return the enablePodSecurityPolicy value.
     */
    public Boolean enablePodSecurityPolicy() {
        return this.enablePodSecurityPolicy;
    }

    /**
     * Set the enablePodSecurityPolicy property: (DEPRECATED) Whether to enable Kubernetes pod security policy
     * (preview). PodSecurityPolicy was deprecated in Kubernetes v1.21, and removed from Kubernetes in v1.25. Learn more
     * at https://aka.ms/k8s/psp and https://aka.ms/aks/psp.
     * 
     * @param enablePodSecurityPolicy the enablePodSecurityPolicy value to set.
     * @return the ManagedClusterProperties object itself.
     */
    public ManagedClusterProperties withEnablePodSecurityPolicy(Boolean enablePodSecurityPolicy) {
        this.enablePodSecurityPolicy = enablePodSecurityPolicy;
        return this;
    }

    /**
     * Get the networkProfile property: The network configuration profile.
     * 
     * @return the networkProfile value.
     */
    public ContainerServiceNetworkProfile networkProfile() {
        return this.networkProfile;
    }

    /**
     * Set the networkProfile property: The network configuration profile.
     * 
     * @param networkProfile the networkProfile value to set.
     * @return the ManagedClusterProperties object itself.
     */
    public ManagedClusterProperties withNetworkProfile(ContainerServiceNetworkProfile networkProfile) {
        this.networkProfile = networkProfile;
        return this;
    }

    /**
     * Get the aadProfile property: The Azure Active Directory configuration.
     * 
     * @return the aadProfile value.
     */
    public ManagedClusterAadProfile aadProfile() {
        return this.aadProfile;
    }

    /**
     * Set the aadProfile property: The Azure Active Directory configuration.
     * 
     * @param aadProfile the aadProfile value to set.
     * @return the ManagedClusterProperties object itself.
     */
    public ManagedClusterProperties withAadProfile(ManagedClusterAadProfile aadProfile) {
        this.aadProfile = aadProfile;
        return this;
    }

    /**
     * Get the autoUpgradeProfile property: The auto upgrade configuration.
     * 
     * @return the autoUpgradeProfile value.
     */
    public ManagedClusterAutoUpgradeProfile autoUpgradeProfile() {
        return this.autoUpgradeProfile;
    }

    /**
     * Set the autoUpgradeProfile property: The auto upgrade configuration.
     * 
     * @param autoUpgradeProfile the autoUpgradeProfile value to set.
     * @return the ManagedClusterProperties object itself.
     */
    public ManagedClusterProperties withAutoUpgradeProfile(ManagedClusterAutoUpgradeProfile autoUpgradeProfile) {
        this.autoUpgradeProfile = autoUpgradeProfile;
        return this;
    }

    /**
     * Get the upgradeSettings property: Settings for upgrading a cluster.
     * 
     * @return the upgradeSettings value.
     */
    public ClusterUpgradeSettings upgradeSettings() {
        return this.upgradeSettings;
    }

    /**
     * Set the upgradeSettings property: Settings for upgrading a cluster.
     * 
     * @param upgradeSettings the upgradeSettings value to set.
     * @return the ManagedClusterProperties object itself.
     */
    public ManagedClusterProperties withUpgradeSettings(ClusterUpgradeSettings upgradeSettings) {
        this.upgradeSettings = upgradeSettings;
        return this;
    }

    /**
     * Get the autoScalerProfile property: Parameters to be applied to the cluster-autoscaler when enabled.
     * 
     * @return the autoScalerProfile value.
     */
    public ManagedClusterPropertiesAutoScalerProfile autoScalerProfile() {
        return this.autoScalerProfile;
    }

    /**
     * Set the autoScalerProfile property: Parameters to be applied to the cluster-autoscaler when enabled.
     * 
     * @param autoScalerProfile the autoScalerProfile value to set.
     * @return the ManagedClusterProperties object itself.
     */
    public ManagedClusterProperties withAutoScalerProfile(ManagedClusterPropertiesAutoScalerProfile autoScalerProfile) {
        this.autoScalerProfile = autoScalerProfile;
        return this;
    }

    /**
     * Get the apiServerAccessProfile property: The access profile for managed cluster API server.
     * 
     * @return the apiServerAccessProfile value.
     */
    public ManagedClusterApiServerAccessProfile apiServerAccessProfile() {
        return this.apiServerAccessProfile;
    }

    /**
     * Set the apiServerAccessProfile property: The access profile for managed cluster API server.
     * 
     * @param apiServerAccessProfile the apiServerAccessProfile value to set.
     * @return the ManagedClusterProperties object itself.
     */
    public ManagedClusterProperties
        withApiServerAccessProfile(ManagedClusterApiServerAccessProfile apiServerAccessProfile) {
        this.apiServerAccessProfile = apiServerAccessProfile;
        return this;
    }

    /**
     * Get the diskEncryptionSetId property: This is of the form:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskEncryptionSets/{encryptionSetName}'.
     * 
     * @return the diskEncryptionSetId value.
     */
    public String diskEncryptionSetId() {
        return this.diskEncryptionSetId;
    }

    /**
     * Set the diskEncryptionSetId property: This is of the form:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskEncryptionSets/{encryptionSetName}'.
     * 
     * @param diskEncryptionSetId the diskEncryptionSetId value to set.
     * @return the ManagedClusterProperties object itself.
     */
    public ManagedClusterProperties withDiskEncryptionSetId(String diskEncryptionSetId) {
        this.diskEncryptionSetId = diskEncryptionSetId;
        return this;
    }

    /**
     * Get the identityProfile property: Identities associated with the cluster.
     * 
     * @return the identityProfile value.
     */
    public Map<String, UserAssignedIdentity> identityProfile() {
        return this.identityProfile;
    }

    /**
     * Set the identityProfile property: Identities associated with the cluster.
     * 
     * @param identityProfile the identityProfile value to set.
     * @return the ManagedClusterProperties object itself.
     */
    public ManagedClusterProperties withIdentityProfile(Map<String, UserAssignedIdentity> identityProfile) {
        this.identityProfile = identityProfile;
        return this;
    }

    /**
     * Get the privateLinkResources property: Private link resources associated with the cluster.
     * 
     * @return the privateLinkResources value.
     */
    public List<PrivateLinkResourceInner> privateLinkResources() {
        return this.privateLinkResources;
    }

    /**
     * Set the privateLinkResources property: Private link resources associated with the cluster.
     * 
     * @param privateLinkResources the privateLinkResources value to set.
     * @return the ManagedClusterProperties object itself.
     */
    public ManagedClusterProperties withPrivateLinkResources(List<PrivateLinkResourceInner> privateLinkResources) {
        this.privateLinkResources = privateLinkResources;
        return this;
    }

    /**
     * Get the disableLocalAccounts property: If set to true, getting static credentials will be disabled for this
     * cluster. This must only be used on Managed Clusters that are AAD enabled. For more details see [disable local
     * accounts](https://docs.microsoft.com/azure/aks/managed-aad#disable-local-accounts-preview).
     * 
     * @return the disableLocalAccounts value.
     */
    public Boolean disableLocalAccounts() {
        return this.disableLocalAccounts;
    }

    /**
     * Set the disableLocalAccounts property: If set to true, getting static credentials will be disabled for this
     * cluster. This must only be used on Managed Clusters that are AAD enabled. For more details see [disable local
     * accounts](https://docs.microsoft.com/azure/aks/managed-aad#disable-local-accounts-preview).
     * 
     * @param disableLocalAccounts the disableLocalAccounts value to set.
     * @return the ManagedClusterProperties object itself.
     */
    public ManagedClusterProperties withDisableLocalAccounts(Boolean disableLocalAccounts) {
        this.disableLocalAccounts = disableLocalAccounts;
        return this;
    }

    /**
     * Get the httpProxyConfig property: Configurations for provisioning the cluster with HTTP proxy servers.
     * 
     * @return the httpProxyConfig value.
     */
    public ManagedClusterHttpProxyConfig httpProxyConfig() {
        return this.httpProxyConfig;
    }

    /**
     * Set the httpProxyConfig property: Configurations for provisioning the cluster with HTTP proxy servers.
     * 
     * @param httpProxyConfig the httpProxyConfig value to set.
     * @return the ManagedClusterProperties object itself.
     */
    public ManagedClusterProperties withHttpProxyConfig(ManagedClusterHttpProxyConfig httpProxyConfig) {
        this.httpProxyConfig = httpProxyConfig;
        return this;
    }

    /**
     * Get the securityProfile property: Security profile for the managed cluster.
     * 
     * @return the securityProfile value.
     */
    public ManagedClusterSecurityProfile securityProfile() {
        return this.securityProfile;
    }

    /**
     * Set the securityProfile property: Security profile for the managed cluster.
     * 
     * @param securityProfile the securityProfile value to set.
     * @return the ManagedClusterProperties object itself.
     */
    public ManagedClusterProperties withSecurityProfile(ManagedClusterSecurityProfile securityProfile) {
        this.securityProfile = securityProfile;
        return this;
    }

    /**
     * Get the storageProfile property: Storage profile for the managed cluster.
     * 
     * @return the storageProfile value.
     */
    public ManagedClusterStorageProfile storageProfile() {
        return this.storageProfile;
    }

    /**
     * Set the storageProfile property: Storage profile for the managed cluster.
     * 
     * @param storageProfile the storageProfile value to set.
     * @return the ManagedClusterProperties object itself.
     */
    public ManagedClusterProperties withStorageProfile(ManagedClusterStorageProfile storageProfile) {
        this.storageProfile = storageProfile;
        return this;
    }

    /**
     * Get the ingressProfile property: Ingress profile for the managed cluster.
     * 
     * @return the ingressProfile value.
     */
    public ManagedClusterIngressProfile ingressProfile() {
        return this.ingressProfile;
    }

    /**
     * Set the ingressProfile property: Ingress profile for the managed cluster.
     * 
     * @param ingressProfile the ingressProfile value to set.
     * @return the ManagedClusterProperties object itself.
     */
    public ManagedClusterProperties withIngressProfile(ManagedClusterIngressProfile ingressProfile) {
        this.ingressProfile = ingressProfile;
        return this;
    }

    /**
     * Get the publicNetworkAccess property: Allow or deny public network access for AKS.
     * 
     * @return the publicNetworkAccess value.
     */
    public PublicNetworkAccess publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    /**
     * Set the publicNetworkAccess property: Allow or deny public network access for AKS.
     * 
     * @param publicNetworkAccess the publicNetworkAccess value to set.
     * @return the ManagedClusterProperties object itself.
     */
    public ManagedClusterProperties withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    /**
     * Get the workloadAutoScalerProfile property: Workload Auto-scaler profile for the managed cluster.
     * 
     * @return the workloadAutoScalerProfile value.
     */
    public ManagedClusterWorkloadAutoScalerProfile workloadAutoScalerProfile() {
        return this.workloadAutoScalerProfile;
    }

    /**
     * Set the workloadAutoScalerProfile property: Workload Auto-scaler profile for the managed cluster.
     * 
     * @param workloadAutoScalerProfile the workloadAutoScalerProfile value to set.
     * @return the ManagedClusterProperties object itself.
     */
    public ManagedClusterProperties
        withWorkloadAutoScalerProfile(ManagedClusterWorkloadAutoScalerProfile workloadAutoScalerProfile) {
        this.workloadAutoScalerProfile = workloadAutoScalerProfile;
        return this;
    }

    /**
     * Get the azureMonitorProfile property: Azure Monitor addon profiles for monitoring the managed cluster.
     * 
     * @return the azureMonitorProfile value.
     */
    public ManagedClusterAzureMonitorProfile azureMonitorProfile() {
        return this.azureMonitorProfile;
    }

    /**
     * Set the azureMonitorProfile property: Azure Monitor addon profiles for monitoring the managed cluster.
     * 
     * @param azureMonitorProfile the azureMonitorProfile value to set.
     * @return the ManagedClusterProperties object itself.
     */
    public ManagedClusterProperties withAzureMonitorProfile(ManagedClusterAzureMonitorProfile azureMonitorProfile) {
        this.azureMonitorProfile = azureMonitorProfile;
        return this;
    }

    /**
     * Get the serviceMeshProfile property: Service mesh profile for a managed cluster.
     * 
     * @return the serviceMeshProfile value.
     */
    public ServiceMeshProfile serviceMeshProfile() {
        return this.serviceMeshProfile;
    }

    /**
     * Set the serviceMeshProfile property: Service mesh profile for a managed cluster.
     * 
     * @param serviceMeshProfile the serviceMeshProfile value to set.
     * @return the ManagedClusterProperties object itself.
     */
    public ManagedClusterProperties withServiceMeshProfile(ServiceMeshProfile serviceMeshProfile) {
        this.serviceMeshProfile = serviceMeshProfile;
        return this;
    }

    /**
     * Get the resourceUid property: The resourceUID uniquely identifies ManagedClusters that reuse ARM ResourceIds
     * (i.e: create, delete, create sequence).
     * 
     * @return the resourceUid value.
     */
    public String resourceUid() {
        return this.resourceUid;
    }

    /**
     * Get the metricsProfile property: Optional cluster metrics configuration.
     * 
     * @return the metricsProfile value.
     */
    public ManagedClusterMetricsProfile metricsProfile() {
        return this.metricsProfile;
    }

    /**
     * Set the metricsProfile property: Optional cluster metrics configuration.
     * 
     * @param metricsProfile the metricsProfile value to set.
     * @return the ManagedClusterProperties object itself.
     */
    public ManagedClusterProperties withMetricsProfile(ManagedClusterMetricsProfile metricsProfile) {
        this.metricsProfile = metricsProfile;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (powerState() != null) {
            powerState().validate();
        }
        if (agentPoolProfiles() != null) {
            agentPoolProfiles().forEach(e -> e.validate());
        }
        if (linuxProfile() != null) {
            linuxProfile().validate();
        }
        if (windowsProfile() != null) {
            windowsProfile().validate();
        }
        if (servicePrincipalProfile() != null) {
            servicePrincipalProfile().validate();
        }
        if (addonProfiles() != null) {
            addonProfiles().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (podIdentityProfile() != null) {
            podIdentityProfile().validate();
        }
        if (oidcIssuerProfile() != null) {
            oidcIssuerProfile().validate();
        }
        if (networkProfile() != null) {
            networkProfile().validate();
        }
        if (aadProfile() != null) {
            aadProfile().validate();
        }
        if (autoUpgradeProfile() != null) {
            autoUpgradeProfile().validate();
        }
        if (upgradeSettings() != null) {
            upgradeSettings().validate();
        }
        if (autoScalerProfile() != null) {
            autoScalerProfile().validate();
        }
        if (apiServerAccessProfile() != null) {
            apiServerAccessProfile().validate();
        }
        if (identityProfile() != null) {
            identityProfile().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (privateLinkResources() != null) {
            privateLinkResources().forEach(e -> e.validate());
        }
        if (httpProxyConfig() != null) {
            httpProxyConfig().validate();
        }
        if (securityProfile() != null) {
            securityProfile().validate();
        }
        if (storageProfile() != null) {
            storageProfile().validate();
        }
        if (ingressProfile() != null) {
            ingressProfile().validate();
        }
        if (workloadAutoScalerProfile() != null) {
            workloadAutoScalerProfile().validate();
        }
        if (azureMonitorProfile() != null) {
            azureMonitorProfile().validate();
        }
        if (serviceMeshProfile() != null) {
            serviceMeshProfile().validate();
        }
        if (metricsProfile() != null) {
            metricsProfile().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kubernetesVersion", this.kubernetesVersion);
        jsonWriter.writeStringField("dnsPrefix", this.dnsPrefix);
        jsonWriter.writeStringField("fqdnSubdomain", this.fqdnSubdomain);
        jsonWriter.writeArrayField("agentPoolProfiles", this.agentPoolProfiles,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("linuxProfile", this.linuxProfile);
        jsonWriter.writeJsonField("windowsProfile", this.windowsProfile);
        jsonWriter.writeJsonField("servicePrincipalProfile", this.servicePrincipalProfile);
        jsonWriter.writeMapField("addonProfiles", this.addonProfiles, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("podIdentityProfile", this.podIdentityProfile);
        jsonWriter.writeJsonField("oidcIssuerProfile", this.oidcIssuerProfile);
        jsonWriter.writeStringField("nodeResourceGroup", this.nodeResourceGroup);
        jsonWriter.writeBooleanField("enableRBAC", this.enableRbac);
        jsonWriter.writeStringField("supportPlan", this.supportPlan == null ? null : this.supportPlan.toString());
        jsonWriter.writeBooleanField("enablePodSecurityPolicy", this.enablePodSecurityPolicy);
        jsonWriter.writeJsonField("networkProfile", this.networkProfile);
        jsonWriter.writeJsonField("aadProfile", this.aadProfile);
        jsonWriter.writeJsonField("autoUpgradeProfile", this.autoUpgradeProfile);
        jsonWriter.writeJsonField("upgradeSettings", this.upgradeSettings);
        jsonWriter.writeJsonField("autoScalerProfile", this.autoScalerProfile);
        jsonWriter.writeJsonField("apiServerAccessProfile", this.apiServerAccessProfile);
        jsonWriter.writeStringField("diskEncryptionSetID", this.diskEncryptionSetId);
        jsonWriter.writeMapField("identityProfile", this.identityProfile,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("privateLinkResources", this.privateLinkResources,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeBooleanField("disableLocalAccounts", this.disableLocalAccounts);
        jsonWriter.writeJsonField("httpProxyConfig", this.httpProxyConfig);
        jsonWriter.writeJsonField("securityProfile", this.securityProfile);
        jsonWriter.writeJsonField("storageProfile", this.storageProfile);
        jsonWriter.writeJsonField("ingressProfile", this.ingressProfile);
        jsonWriter.writeStringField("publicNetworkAccess",
            this.publicNetworkAccess == null ? null : this.publicNetworkAccess.toString());
        jsonWriter.writeJsonField("workloadAutoScalerProfile", this.workloadAutoScalerProfile);
        jsonWriter.writeJsonField("azureMonitorProfile", this.azureMonitorProfile);
        jsonWriter.writeJsonField("serviceMeshProfile", this.serviceMeshProfile);
        jsonWriter.writeJsonField("metricsProfile", this.metricsProfile);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagedClusterProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagedClusterProperties if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ManagedClusterProperties.
     */
    public static ManagedClusterProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedClusterProperties deserializedManagedClusterProperties = new ManagedClusterProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("provisioningState".equals(fieldName)) {
                    deserializedManagedClusterProperties.provisioningState = reader.getString();
                } else if ("powerState".equals(fieldName)) {
                    deserializedManagedClusterProperties.powerState = PowerState.fromJson(reader);
                } else if ("maxAgentPools".equals(fieldName)) {
                    deserializedManagedClusterProperties.maxAgentPools = reader.getNullable(JsonReader::getInt);
                } else if ("kubernetesVersion".equals(fieldName)) {
                    deserializedManagedClusterProperties.kubernetesVersion = reader.getString();
                } else if ("currentKubernetesVersion".equals(fieldName)) {
                    deserializedManagedClusterProperties.currentKubernetesVersion = reader.getString();
                } else if ("dnsPrefix".equals(fieldName)) {
                    deserializedManagedClusterProperties.dnsPrefix = reader.getString();
                } else if ("fqdnSubdomain".equals(fieldName)) {
                    deserializedManagedClusterProperties.fqdnSubdomain = reader.getString();
                } else if ("fqdn".equals(fieldName)) {
                    deserializedManagedClusterProperties.fqdn = reader.getString();
                } else if ("privateFQDN".equals(fieldName)) {
                    deserializedManagedClusterProperties.privateFqdn = reader.getString();
                } else if ("azurePortalFQDN".equals(fieldName)) {
                    deserializedManagedClusterProperties.azurePortalFqdn = reader.getString();
                } else if ("agentPoolProfiles".equals(fieldName)) {
                    List<ManagedClusterAgentPoolProfile> agentPoolProfiles
                        = reader.readArray(reader1 -> ManagedClusterAgentPoolProfile.fromJson(reader1));
                    deserializedManagedClusterProperties.agentPoolProfiles = agentPoolProfiles;
                } else if ("linuxProfile".equals(fieldName)) {
                    deserializedManagedClusterProperties.linuxProfile = ContainerServiceLinuxProfile.fromJson(reader);
                } else if ("windowsProfile".equals(fieldName)) {
                    deserializedManagedClusterProperties.windowsProfile = ManagedClusterWindowsProfile.fromJson(reader);
                } else if ("servicePrincipalProfile".equals(fieldName)) {
                    deserializedManagedClusterProperties.servicePrincipalProfile
                        = ManagedClusterServicePrincipalProfile.fromJson(reader);
                } else if ("addonProfiles".equals(fieldName)) {
                    Map<String, ManagedClusterAddonProfile> addonProfiles
                        = reader.readMap(reader1 -> ManagedClusterAddonProfile.fromJson(reader1));
                    deserializedManagedClusterProperties.addonProfiles = addonProfiles;
                } else if ("podIdentityProfile".equals(fieldName)) {
                    deserializedManagedClusterProperties.podIdentityProfile
                        = ManagedClusterPodIdentityProfile.fromJson(reader);
                } else if ("oidcIssuerProfile".equals(fieldName)) {
                    deserializedManagedClusterProperties.oidcIssuerProfile
                        = ManagedClusterOidcIssuerProfile.fromJson(reader);
                } else if ("nodeResourceGroup".equals(fieldName)) {
                    deserializedManagedClusterProperties.nodeResourceGroup = reader.getString();
                } else if ("enableRBAC".equals(fieldName)) {
                    deserializedManagedClusterProperties.enableRbac = reader.getNullable(JsonReader::getBoolean);
                } else if ("supportPlan".equals(fieldName)) {
                    deserializedManagedClusterProperties.supportPlan
                        = KubernetesSupportPlan.fromString(reader.getString());
                } else if ("enablePodSecurityPolicy".equals(fieldName)) {
                    deserializedManagedClusterProperties.enablePodSecurityPolicy
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("networkProfile".equals(fieldName)) {
                    deserializedManagedClusterProperties.networkProfile
                        = ContainerServiceNetworkProfile.fromJson(reader);
                } else if ("aadProfile".equals(fieldName)) {
                    deserializedManagedClusterProperties.aadProfile = ManagedClusterAadProfile.fromJson(reader);
                } else if ("autoUpgradeProfile".equals(fieldName)) {
                    deserializedManagedClusterProperties.autoUpgradeProfile
                        = ManagedClusterAutoUpgradeProfile.fromJson(reader);
                } else if ("upgradeSettings".equals(fieldName)) {
                    deserializedManagedClusterProperties.upgradeSettings = ClusterUpgradeSettings.fromJson(reader);
                } else if ("autoScalerProfile".equals(fieldName)) {
                    deserializedManagedClusterProperties.autoScalerProfile
                        = ManagedClusterPropertiesAutoScalerProfile.fromJson(reader);
                } else if ("apiServerAccessProfile".equals(fieldName)) {
                    deserializedManagedClusterProperties.apiServerAccessProfile
                        = ManagedClusterApiServerAccessProfile.fromJson(reader);
                } else if ("diskEncryptionSetID".equals(fieldName)) {
                    deserializedManagedClusterProperties.diskEncryptionSetId = reader.getString();
                } else if ("identityProfile".equals(fieldName)) {
                    Map<String, UserAssignedIdentity> identityProfile
                        = reader.readMap(reader1 -> UserAssignedIdentity.fromJson(reader1));
                    deserializedManagedClusterProperties.identityProfile = identityProfile;
                } else if ("privateLinkResources".equals(fieldName)) {
                    List<PrivateLinkResourceInner> privateLinkResources
                        = reader.readArray(reader1 -> PrivateLinkResourceInner.fromJson(reader1));
                    deserializedManagedClusterProperties.privateLinkResources = privateLinkResources;
                } else if ("disableLocalAccounts".equals(fieldName)) {
                    deserializedManagedClusterProperties.disableLocalAccounts
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("httpProxyConfig".equals(fieldName)) {
                    deserializedManagedClusterProperties.httpProxyConfig
                        = ManagedClusterHttpProxyConfig.fromJson(reader);
                } else if ("securityProfile".equals(fieldName)) {
                    deserializedManagedClusterProperties.securityProfile
                        = ManagedClusterSecurityProfile.fromJson(reader);
                } else if ("storageProfile".equals(fieldName)) {
                    deserializedManagedClusterProperties.storageProfile = ManagedClusterStorageProfile.fromJson(reader);
                } else if ("ingressProfile".equals(fieldName)) {
                    deserializedManagedClusterProperties.ingressProfile = ManagedClusterIngressProfile.fromJson(reader);
                } else if ("publicNetworkAccess".equals(fieldName)) {
                    deserializedManagedClusterProperties.publicNetworkAccess
                        = PublicNetworkAccess.fromString(reader.getString());
                } else if ("workloadAutoScalerProfile".equals(fieldName)) {
                    deserializedManagedClusterProperties.workloadAutoScalerProfile
                        = ManagedClusterWorkloadAutoScalerProfile.fromJson(reader);
                } else if ("azureMonitorProfile".equals(fieldName)) {
                    deserializedManagedClusterProperties.azureMonitorProfile
                        = ManagedClusterAzureMonitorProfile.fromJson(reader);
                } else if ("serviceMeshProfile".equals(fieldName)) {
                    deserializedManagedClusterProperties.serviceMeshProfile = ServiceMeshProfile.fromJson(reader);
                } else if ("resourceUID".equals(fieldName)) {
                    deserializedManagedClusterProperties.resourceUid = reader.getString();
                } else if ("metricsProfile".equals(fieldName)) {
                    deserializedManagedClusterProperties.metricsProfile = ManagedClusterMetricsProfile.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagedClusterProperties;
        });
    }
}
