// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/**
 * Managed cluster Access Profile.
 */
@Fluent
public final class ManagedClusterAccessProfileInner extends Resource {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    /*
     * AccessProfile of a managed cluster.
     */
    private AccessProfile innerProperties;

    /*
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    private SystemData systemData;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * The type of the resource.
     */
    private String type;

    /**
     * Creates an instance of ManagedClusterAccessProfileInner class.
     */
    public ManagedClusterAccessProfileInner() {
    }

    /**
     * Get the innerProperties property: AccessProfile of a managed cluster.
     * 
     * @return the innerProperties value.
     */
    private AccessProfile innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the systemData property: Azure Resource Manager metadata containing createdBy and modifiedBy information.
     * 
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ManagedClusterAccessProfileInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ManagedClusterAccessProfileInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Get the kubeConfig property: Base64-encoded Kubernetes configuration file.
     * 
     * @return the kubeConfig value.
     */
    public byte[] kubeConfig() {
        return this.innerProperties() == null ? EMPTY_BYTE_ARRAY : this.innerProperties().kubeConfig();
    }

    /**
     * Set the kubeConfig property: Base64-encoded Kubernetes configuration file.
     * 
     * @param kubeConfig the kubeConfig value to set.
     * @return the ManagedClusterAccessProfileInner object itself.
     */
    public ManagedClusterAccessProfileInner withKubeConfig(byte[] kubeConfig) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AccessProfile();
        }
        this.innerProperties().withKubeConfig(kubeConfig);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", location());
        jsonWriter.writeMapField("tags", tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagedClusterAccessProfileInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagedClusterAccessProfileInner if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ManagedClusterAccessProfileInner.
     */
    public static ManagedClusterAccessProfileInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedClusterAccessProfileInner deserializedManagedClusterAccessProfileInner
                = new ManagedClusterAccessProfileInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedManagedClusterAccessProfileInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedManagedClusterAccessProfileInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedManagedClusterAccessProfileInner.type = reader.getString();
                } else if ("location".equals(fieldName)) {
                    deserializedManagedClusterAccessProfileInner.withLocation(reader.getString());
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedManagedClusterAccessProfileInner.withTags(tags);
                } else if ("properties".equals(fieldName)) {
                    deserializedManagedClusterAccessProfileInner.innerProperties = AccessProfile.fromJson(reader);
                } else if ("systemData".equals(fieldName)) {
                    deserializedManagedClusterAccessProfileInner.systemData = SystemData.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagedClusterAccessProfileInner;
        });
    }
}
