// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/**
 * Mode of the service mesh.
 */
public final class ServiceMeshMode extends ExpandableStringEnum<ServiceMeshMode> {
    /**
     * Static value Istio for ServiceMeshMode.
     */
    public static final ServiceMeshMode ISTIO = fromString("Istio");

    /**
     * Static value Disabled for ServiceMeshMode.
     */
    public static final ServiceMeshMode DISABLED = fromString("Disabled");

    /**
     * Creates a new instance of ServiceMeshMode value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public ServiceMeshMode() {
    }

    /**
     * Creates or finds a ServiceMeshMode from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding ServiceMeshMode.
     */
    @JsonCreator
    public static ServiceMeshMode fromString(String name) {
        return fromString(name, ServiceMeshMode.class);
    }

    /**
     * Gets known ServiceMeshMode values.
     * 
     * @return known ServiceMeshMode values.
     */
    public static Collection<ServiceMeshMode> values() {
        return values(ServiceMeshMode.class);
    }
}
