// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/**
 * The network mode Azure CNI is configured with.
 * 
 * This cannot be specified if networkPlugin is anything other than 'azure'.
 */
public final class NetworkMode extends ExpandableStringEnum<NetworkMode> {
    /**
     * Static value transparent for NetworkMode.
     */
    public static final NetworkMode TRANSPARENT = fromString("transparent");

    /**
     * Static value bridge for NetworkMode.
     */
    public static final NetworkMode BRIDGE = fromString("bridge");

    /**
     * Creates a new instance of NetworkMode value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public NetworkMode() {
    }

    /**
     * Creates or finds a NetworkMode from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding NetworkMode.
     */
    @JsonCreator
    public static NetworkMode fromString(String name) {
        return fromString(name, NetworkMode.class);
    }

    /**
     * Gets known NetworkMode values.
     * 
     * @return known NetworkMode values.
     */
    public static Collection<NetworkMode> values() {
        return values(NetworkMode.class);
    }
}
